/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import org.eclipse.n4js.utils.MemoryTracker;

public class WithMemoryPrinter
implements AutoCloseable {
    private final String label;
    private final boolean gcOnClose;

    public WithMemoryPrinter(String label) {
        this(label, false, false);
    }

    public WithMemoryPrinter(String label, boolean gcStart) {
        this(label, gcStart, false);
    }

    public WithMemoryPrinter(String label, boolean gcOnEnter, boolean gcOnClose) {
        this.label = label;
        this.gcOnClose = gcOnClose;
        WithMemoryPrinter.printMem(String.valueOf(label) + "_enter", gcOnEnter);
    }

    public void printMemory() {
        WithMemoryPrinter.printMem(this.label, false);
    }

    public void printMemory(boolean runGC) {
        WithMemoryPrinter.printMem(this.label, runGC);
    }

    @Override
    public void close() {
        WithMemoryPrinter.printMem(String.valueOf(this.label) + "_exit", this.gcOnClose);
    }

    private static void printMem(String label, boolean runGC) {
        System.out.println(label);
        if (runGC) {
            MemoryTracker.printCurrentMemoryUsage("before GC");
            MemoryTracker.runGC();
            MemoryTracker.printCurrentMemoryUsage("after  GC");
        } else {
            MemoryTracker.printCurrentMemoryUsage("memory");
        }
    }
}

