/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.n4js.ui.external.ProjectStateChangeListener;
import org.eclipse.n4js.ui.internal.ContributingResourceDescriptionPersister;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.xtext.builder.builderState.IBuilderState;
import org.eclipse.xtext.builder.impl.BuilderStateDiscarder;
import org.eclipse.xtext.builder.impl.IBuildFlag;

public class N4JSExternalLibraryStartup
implements IStartup {
    @Inject
    private ContributingResourceDescriptionPersister descriptionPersister;
    @Inject
    private IWorkspace workspace;
    @Inject
    private BuilderStateDiscarder builderStateDiscarder;
    @Inject
    private IBuilderState builderState;
    @Inject
    private ProjectStateChangeListener indexSyncScheduler;

    public void earlyStartup() {
        new Thread(() -> {
            boolean indexIsEmpty = this.builderState.isEmpty();
            if (this.descriptionPersister.isRecoveryBuildRequired() || indexIsEmpty) {
                this.descriptionPersister.scheduleRecoveryBuildOnContributions();
                HashMap args = Maps.newHashMap();
                IBuildFlag.RECOVERY_BUILD.addToMap((Map)args);
                this.builderStateDiscarder.forgetLastBuildState(Arrays.asList(this.workspace.getRoot().getProjects()), (Map)args);
            }
        }).start();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
        if (commandService != null) {
            commandService.addExecutionListener((IExecutionListener)new CheckNodeModulesSyncOnRefresh());
        }
    }

    class CheckNodeModulesSyncOnRefresh
    implements IExecutionListener {
        CheckNodeModulesSyncOnRefresh() {
        }

        public void notHandled(String commandId, NotHandledException exception) {
        }

        public void postExecuteFailure(String commandId, ExecutionException exception) {
        }

        public void preExecute(String commandId, ExecutionEvent event) {
        }

        public void postExecuteSuccess(String commandId, Object returnValue) {
            if ("org.eclipse.ui.file.refresh".equals(commandId)) {
                N4JSExternalLibraryStartup.this.indexSyncScheduler.forceIndexSync();
            }
        }
    }
}

