/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.n4js.jsdoc2spec.SpecElementRef;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;

public class KeyUtils {
    public static String getSpecKey(RepoRelativePathHolder rrph, SpecInfo specInfo) {
        SpecElementRef ser = specInfo.specElementRef;
        if (ser.requirementID != null) {
            return ser.requirementID;
        }
        if (ser.identifiableElement != null) {
            return KeyUtils.getSpecKey(rrph, ser.identifiableElement);
        }
        return null;
    }

    public static String getSpecModuleKey(RepoRelativePathHolder rrph, SpecInfo specInfo) {
        SpecElementRef ser = specInfo.specElementRef;
        if (ser.requirementID != null) {
            return ser.requirementID;
        }
        if (ser.identifiableElement != null) {
            return KeyUtils.getSpecKeyPrefix(rrph, ser.identifiableElement);
        }
        return null;
    }

    public static String getSpecKey(RepoRelativePathHolder rrph, IdentifiableElement type, IdentifiableElement element) {
        return String.valueOf(KeyUtils.getSpecKeyPrefix(rrph, type)) + "." + element.getName();
    }

    public static String getSpecKey(RepoRelativePathHolder rrph, IdentifiableElement element) {
        return String.valueOf(KeyUtils.getSpecKeyPrefix(rrph, element)) + "." + element.getName();
    }

    public static String getSpecKeyPrefix(RepoRelativePathHolder rrph, IdentifiableElement element) {
        if (element instanceof TMember) {
            ContainerType containingType = ((TMember)element).getContainingType();
            return KeyUtils.getSpecKeyPrefix(rrph, (IdentifiableElement)containingType);
        }
        TModule module = element.getContainingModule();
        if (module == null) {
            return "GLOBAL.";
        }
        RepoRelativePath rrp = rrph.get(element);
        String key = rrp.getFullPath();
        return key;
    }

    public static String getSpecKeyWithoutProjectFolder(RepoRelativePath rrp, String elementName) {
        String key = "";
        if (rrp != null) {
            key = String.valueOf(key) + rrp.repositoryName;
            if (!rrp.pathInRepository.isEmpty()) {
                key = String.valueOf(key) + "." + rrp.pathInRepository;
            }
            key = String.valueOf(key) + "." + rrp.projectName;
            key = String.valueOf(key) + ".";
        }
        key = String.valueOf(key) + elementName;
        return key;
    }

    public static String getSpecKeyWithoutProjectFolder(RepoRelativePathHolder rrph, IdentifiableElement element) {
        if (element instanceof TMember) {
            ContainerType containingType = ((TMember)element).getContainingType();
            String specKeyOfType = KeyUtils.getSpecKeyWithoutProjectFolder(rrph, (IdentifiableElement)containingType);
            String specKey = String.valueOf(specKeyOfType) + "." + element.getName();
            return specKey;
        }
        TModule module = element.getContainingModule();
        if (module == null) {
            return "GLOBAL.";
        }
        RepoRelativePath rrp = rrph.get(element);
        String elementName = KeyUtils.nameFromElement(rrph, element);
        String key = KeyUtils.getSpecKeyWithoutProjectFolder(rrp, elementName);
        return key;
    }

    private static String nameFromElement(RepoRelativePathHolder rrph, IdentifiableElement element) {
        if (element instanceof TMember) {
            TMember tMember = (TMember)element;
            String name = KeyUtils.nameFromElement(rrph, (IdentifiableElement)tMember.getContainingType());
            return String.valueOf(name) + "#" + element.getName();
        }
        TModule module = element.getContainingModule();
        if (module == null) {
            String name = "##global##." + element.getName();
            return name;
        }
        String name = String.valueOf(module.getModuleSpecifier()) + "." + element.getName();
        return name;
    }
}

