/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.json.ui.editor.hyperlinking;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.n4js.json.ui.editor.hyperlinking.IJSONHyperlinkHelperExtension;
import org.eclipse.n4js.json.ui.extension.JSONUiExtensionRegistry;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.hyperlinking.HyperlinkHelper;

public class JSONHyperlinkHelperProvider
extends HyperlinkHelper {
    @Inject
    private JSONUiExtensionRegistry registry;

    public IHyperlink[] createHyperlinksByOffset(XtextResource resource, int offset, boolean createMultipleHyperlinks) {
        LinkedList links = new LinkedList();
        Collection<IJSONHyperlinkHelperExtension> hyperlinkHelperExtensions = this.registry.getHyperlinkHelperExtensions();
        for (IJSONHyperlinkHelperExtension hhExt : hyperlinkHelperExtensions) {
            IHyperlink[] hyperlinks = null;
            if (hhExt.isResponsible(resource)) {
                hyperlinks = hhExt.getHyperlinks(resource, offset);
            }
            if (hyperlinks == null) continue;
            List hyperlinkList = Arrays.asList(hyperlinks);
            links.addAll(hyperlinkList);
        }
        if (links.isEmpty()) {
            return null;
        }
        return links.toArray(new IHyperlink[links.size()]);
    }
}

