/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.es.transform;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportableElement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ModifiableElement;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableDeclarationOrBinding;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.scoping.utils.ImportSpecifierUtil;
import org.eclipse.n4js.transpiler.Transformation;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.utils.ResourceNameComputer;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ModuleWrappingTransformation
extends Transformation {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private ResourceNameComputer resourceNameComputer;
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;
    private String[] localModuleSpecifierSegments = null;

    public void assertPreConditions() {
    }

    public void assertPostConditions() {
    }

    public void analyze() {
        TModule localModule = this.getState().resource.getModule();
        String localModuleSpecifier = this.resourceNameComputer.getCompleteModuleSpecifier(localModule);
        this.localModuleSpecifierSegments = localModuleSpecifier.split("/", -1);
    }

    public void transform() {
        Consumer<ImportDeclaration> _function = it -> this.transformImportDecl((ImportDeclaration)it);
        this.collectNodes((EObject)this.getState().im, ImportDeclaration.class, false).forEach(_function);
        Functions.Function1 _function_1 = it -> it.getExportedElement();
        Consumer<ModifiableElement> _function_2 = it -> it.getDeclaredModifiers().clear();
        Iterables.filter((Iterable)ListExtensions.map((List)this.collectNodes((EObject)this.getState().im, ExportDeclaration.class, false), (Functions.Function1)_function_1), ModifiableElement.class).forEach(_function_2);
        Consumer<ExportDeclaration> _function_3 = it -> this.splitDefaultExportFromVarDecl((ExportDeclaration)it);
        this.collectNodes((EObject)this.getState().im, ExportDeclaration.class, false).forEach(_function_3);
        this.addEmptyImport("n4js-runtime");
    }

    private void transformImportDecl(ImportDeclaration importDeclIM) {
        TModule module = this.getState().info.getImportedModule(importDeclIM);
        String actualModuleSpecifier = this.computeActualModuleSpecifier(module);
        String actualModuleSpecifierNormalized = actualModuleSpecifier.replace("/./", "/");
        importDeclIM.setModuleSpecifierAsText(actualModuleSpecifierNormalized);
    }

    private String computeActualModuleSpecifier(TModule targetModule) {
        String definedPackageName;
        String targetModuleSpecifier = this.resourceNameComputer.getCompleteModuleSpecifier(targetModule);
        IN4JSProject targetProject = (IN4JSProject)this.n4jsCore.findProject(targetModule.eResource().getURI()).orNull();
        if (targetProject != null && targetProject.getProjectType() == ProjectType.DEFINITION && (definedPackageName = targetProject.getDefinesPackageName()) != null) {
            targetProject = (IN4JSProject)this.n4jsCore.findAllProjectMappings().get(definedPackageName);
        }
        if (targetProject != null) {
            URI _location_1;
            boolean _tripleEquals;
            ProjectType _projectType = targetProject.getProjectType();
            boolean bl = _tripleEquals = _projectType == ProjectType.RUNTIME_LIBRARY;
            if (_tripleEquals) {
                return targetModule.getModuleSpecifier();
            }
            URI _location = targetProject.getLocation();
            boolean _equals = com.google.common.base.Objects.equal((Object)_location, (Object)(_location_1 = this.getState().project.getLocation()));
            if (_equals) {
                return this.createRelativeModuleSpecifier(targetProject, targetModuleSpecifier);
            }
            return this.createAbsoluteModuleSpecifier(targetProject, targetModule, targetModuleSpecifier);
        }
        return targetModuleSpecifier;
    }

    private String createRelativeModuleSpecifier(IN4JSProject targetProject, String targetModuleSpecifier) {
        String[] targetSegments = targetModuleSpecifier.split("/", -1);
        int l = Math.min(targetSegments.length, this.localModuleSpecifierSegments.length);
        int i = 0;
        while (i < l && Objects.equals(targetSegments[i], this.localModuleSpecifierSegments[i])) {
            ++i;
        }
        Object[] differingSegments = Arrays.copyOfRange(targetSegments, i, targetSegments.length);
        int _length = this.localModuleSpecifierSegments.length;
        int _minus = _length - 1;
        int goUpCount = _minus - i;
        String _xifexpression = null;
        _xifexpression = goUpCount > 0 ? Strings.repeat((String)"../", (int)goUpCount) : "./";
        String _join = Joiner.on((String)"/").join(differingSegments);
        String result = String.valueOf(_xifexpression) + _join;
        return result;
    }

    private String createAbsoluteModuleSpecifier(IN4JSProject targetProject, TModule targetModule, String targetModuleSpecifier) {
        String targetProjectName;
        boolean _isNullOrEmpty;
        boolean _tripleNotEquals;
        String _mainModule = targetProject.getMainModule();
        boolean bl = _tripleNotEquals = _mainModule != null;
        if (_tripleNotEquals) {
            QualifiedName targetProjectMainModuleFQN = ImportSpecifierUtil.getMainModuleOfProject((IN4JSProject)targetProject);
            QualifiedName targetModuleFQN = this.qualifiedNameProvider.getFullyQualifiedName((EObject)targetModule);
            if (targetProjectMainModuleFQN != null && com.google.common.base.Objects.equal((Object)targetProjectMainModuleFQN, (Object)targetModuleFQN)) {
                return targetProject.getProjectName();
            }
        }
        if (_isNullOrEmpty = StringExtensions.isNullOrEmpty((String)(targetProjectName = targetProject.getProjectName()))) {
            return targetModuleSpecifier;
        }
        String outputPath = targetProject.getOutputPath();
        boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)outputPath);
        if (_isNullOrEmpty_1) {
            outputPath = "/";
        } else {
            boolean _endsWith;
            boolean _not_1;
            boolean _not;
            boolean _startsWith = outputPath.startsWith("/");
            boolean bl2 = _not = !_startsWith;
            if (_not) {
                outputPath = "/" + outputPath;
            }
            boolean bl3 = _not_1 = !(_endsWith = outputPath.endsWith("/"));
            if (_not_1) {
                outputPath = String.valueOf(outputPath) + "/";
            }
        }
        return String.valueOf(targetProjectName) + outputPath + targetModuleSpecifier;
    }

    private void splitDefaultExportFromVarDecl(ExportDeclaration exportDecl) {
        ExportableElement exportedElement;
        boolean _isDefaultExport = exportDecl.isDefaultExport();
        if (_isDefaultExport && (exportedElement = exportDecl.getExportedElement()) instanceof VariableStatement) {
            boolean _greaterThan;
            boolean _not;
            boolean _isEmpty = IterableExtensions.isEmpty((Iterable)Iterables.filter((Iterable)((VariableStatement)exportedElement).getVarDeclsOrBindings(), VariableBinding.class));
            boolean bl = _not = !_isEmpty;
            if (_not) {
                throw new UnsupportedOperationException("unsupported: default-exported variable binding");
            }
            int _size = ((VariableStatement)exportedElement).getVarDeclsOrBindings().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                throw new UnsupportedOperationException("unsupported: several default-exported variable declarations in a single export declaration");
            }
            VariableDeclarationOrBinding _head = (VariableDeclarationOrBinding)IterableExtensions.head((Iterable)((VariableStatement)exportedElement).getVarDeclsOrBindings());
            VariableDeclaration varDecl = (VariableDeclaration)_head;
            SymbolTableEntry varDeclSTE = this.findSymbolTableEntryForElement((NamedElement)varDecl, true);
            this.insertBefore((EObject)exportDecl, new EObject[]{exportedElement});
            exportDecl.setDefaultExportedExpression((Expression)TranspilerBuilderBlocks._IdentRef((SymbolTableEntry)varDeclSTE));
        }
    }
}

