/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.binaries.BinariesLocatorHelper;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.BinariesValidator;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class YarnBinary
implements Binary {
    private String memoizedCalculatedYarnPath = null;
    @Inject
    private BinariesValidator validator;
    @Inject
    private BinariesPreferenceStore preferenceStore;
    @Inject
    private BinariesLocatorHelper binariesLocatorHelper;

    @Override
    public String getId() {
        return YarnBinary.class.getName();
    }

    @Override
    public String getLabel() {
        return "Yarn";
    }

    @Override
    public String getDescription() {
        return "Configuration of the folder location of the Yarn executable can be provided here. If not given, then the '" + this.getDefaultYarnPath() + "' location will be used as the default location. The required minimum version for Yarn is '" + SemverSerializer.serialize((VersionNumber)this.getMinimumVersion()) + "'.";
    }

    @Override
    public VersionNumber getMinimumVersion() {
        return BinariesConstants.YARN_MIN_VERSION;
    }

    @Override
    public String getBinaryAbsolutePath() {
        return String.valueOf(this.getUserYarnPathOrDefault()) + File.separator + BinariesConstants.YARN_BINARY_NAME;
    }

    @Override
    public String getVersionArgument() {
        return "-v";
    }

    @Override
    public Binary getParent() {
        return null;
    }

    @Override
    public Iterable<Binary> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Map<String, String> updateEnvironment(Map<String, String> environment) {
        String additionalNodePath = this.getUserYarnPathOrDefault();
        String currentPathValue = environment.get("PATH");
        if (Strings.isNullOrEmpty((String)currentPathValue)) {
            environment.put("PATH", additionalNodePath);
        } else {
            environment.put("PATH", String.valueOf(currentPathValue) + File.pathSeparator + additionalNodePath);
        }
        return environment;
    }

    @Override
    public URI getUserConfiguredLocation() {
        return this.preferenceStore.getPath(this);
    }

    @Override
    public IStatus validate() {
        return this.validator.validate(this);
    }

    @Override
    public Optional<String[]> getCacheCleanCommand() {
        return Optional.of((Object)new String[]{"cache", "clean", "--force"});
    }

    @Override
    public boolean canInstallNpmPackages() {
        return true;
    }

    @Override
    public String getNpmInstallCommand(boolean readPackagesFromPackageJson) {
        return readPackagesFromPackageJson ? "install" : "add";
    }

    @Override
    public String getNpmUninstallCommand() {
        return "remove";
    }

    @Override
    public Optional<Pair<String, String>> getNpmSaveOptions() {
        return Optional.of((Object)new Pair((Object)"--save", (Object)"--no-save"));
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof YarnBinary)) {
            return false;
        }
        YarnBinary other = (YarnBinary)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public String getUserYarnPathOrDefault() {
        URI userConfiguredLocation = this.getUserConfiguredLocation();
        return userConfiguredLocation == null ? this.getDefaultYarnPath() : new File(userConfiguredLocation).getAbsolutePath();
    }

    private String getDefaultYarnPath() {
        if (this.memoizedCalculatedYarnPath == null) {
            this.memoizedCalculatedYarnPath = this.binariesLocatorHelper.findYarnPath().toString();
        }
        return this.memoizedCalculatedYarnPath;
    }
}

