/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.LazyProjectDescriptionHandle;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.URIUtils;

@Singleton
public class FileBasedWorkspace
extends InternalN4JSWorkspace {
    private final ProjectDescriptionLoader projectDescriptionLoader;
    private final Map<URI, LazyProjectDescriptionHandle> projectElementHandles = Maps.newConcurrentMap();
    public static final String N4FBPRJ = "n4fbprj:";

    @Inject
    public FileBasedWorkspace(ProjectDescriptionLoader projectDescriptionLoader) {
        this.projectDescriptionLoader = projectDescriptionLoader;
    }

    public void registerProject(URI unsafeLocation) {
        if (unsafeLocation.lastSegment().isEmpty()) {
            throw new IllegalArgumentException("lastSegment may not be empty");
        }
        URI location = URIUtils.normalize((URI)unsafeLocation);
        if (!this.projectElementHandles.containsKey(location)) {
            LazyProjectDescriptionHandle lazyDescriptionHandle = this.createLazyDescriptionHandle(location);
            this.projectElementHandles.put(location, lazyDescriptionHandle);
        }
    }

    public void clear() {
        this.projectElementHandles.clear();
    }

    protected LazyProjectDescriptionHandle createLazyDescriptionHandle(URI location) {
        return new LazyProjectDescriptionHandle(location, this.projectDescriptionLoader);
    }

    @Override
    public URI findProjectWith(URI nestedLocation) {
        URI key = URIUtils.normalize((URI)nestedLocation.trimFragment());
        while (key.segmentCount() > 0) {
            LazyProjectDescriptionHandle match = this.projectElementHandles.get(key);
            if (match != null) {
                return key;
            }
            key = key.trimSegments(1);
        }
        return null;
    }

    @Override
    public ProjectDescription getProjectDescription(URI unsafeLocation) {
        URI location = URIUtils.normalize((URI)unsafeLocation);
        LazyProjectDescriptionHandle handle = this.projectElementHandles.get(location);
        if (handle == null && location.hasTrailingPathSeparator()) {
            handle = this.projectElementHandles.get(location.trimSegments(1));
        }
        if (handle == null) {
            return null;
        }
        ProjectDescription description = handle.resolve();
        return description;
    }

    public Iterator<URI> getAllProjectLocationsIterator() {
        return this.projectElementHandles.values().stream().map(handle -> handle.getLocation()).iterator();
    }

    @Override
    public Collection<URI> getAllProjectLocations() {
        return this.projectElementHandles.values().stream().map(handle -> handle.getLocation()).collect(Collectors.toList());
    }

    @Override
    public URI getLocation(URI unsafeLocation, ProjectReference projectReference) {
        String projectName = projectReference.getProjectName();
        for (URI location : this.projectElementHandles.keySet()) {
            LazyProjectDescriptionHandle lazyHandle;
            String candidateProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(location);
            if (!candidateProjectName.equals(projectName) || (lazyHandle = this.projectElementHandles.get(location)) == null) continue;
            return lazyHandle.getLocation();
        }
        return null;
    }

    @Override
    public Iterator<URI> getFolderIterator(URI unsafeLocation) {
        URI folderLocation = URIUtils.normalize((URI)unsafeLocation);
        java.net.URI create = java.net.URI.create(folderLocation.toString());
        File sourceContainerDirectory = null;
        try {
            sourceContainerDirectory = new File(create);
        }
        catch (IllegalArgumentException iae) {
            System.err.println(String.valueOf(this.getClass().getName()) + " invalid URI " + unsafeLocation);
            iae.printStackTrace();
        }
        if (sourceContainerDirectory != null && sourceContainerDirectory.isDirectory()) {
            AbstractTreeIterator<File> treeIterator = new AbstractTreeIterator<File>((Object)sourceContainerDirectory, false){

                protected Iterator<? extends File> getChildren(Object root) {
                    File file;
                    if (root instanceof File && (file = (File)root).isDirectory()) {
                        if (file.getName().equals("node_modules")) {
                            return Collections.emptyIterator();
                        }
                        return Arrays.asList(((File)root).listFiles()).iterator();
                    }
                    return Collections.emptyIterator();
                }
            };
            return Iterators.unmodifiableIterator((Iterator)Iterators.transform((Iterator)Iterators.filter((Iterator)treeIterator, (Predicate)new Predicate<File>(){

                public boolean apply(File input) {
                    return !input.isDirectory();
                }
            }), (Function)new Function<File, URI>(){

                public URI apply(File input) {
                    return URI.createURI((String)input.toURI().toString());
                }
            }));
        }
        return Collections.emptyIterator();
    }

    @Override
    public URI findArtifactInFolder(URI unsafeLocation, String folderRelativePath) {
        Path subPath;
        URI folderLocation = URIUtils.normalize((URI)unsafeLocation);
        Path sourceContainerDirectory = Paths.get(java.net.URI.create(folderLocation.toString()));
        File file = sourceContainerDirectory.resolve(subPath = Paths.get(folderRelativePath.replace("/", File.separator), new String[0])).toFile().getAbsoluteFile();
        if (file.exists()) {
            return URI.createURI((String)file.toURI().toString());
        }
        return null;
    }

    public static URI uriFrom(String handle) {
        if (handle.startsWith(N4FBPRJ)) {
            return URI.createURI((String)handle.substring(N4FBPRJ.length()));
        }
        return null;
    }

    public static String handleFrom(URI uri) {
        return N4FBPRJ + uri.toString();
    }
}

