/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.validation.JavaScriptVariantHelper;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.MapBasedScope;
import org.eclipse.xtext.scoping.impl.MultimapBasedScope;
import org.eclipse.xtext.scoping.impl.SimpleScope;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public class ScopesHelper {
    @Inject
    private JavaScriptVariantHelper javaScriptVariantHelper;

    public IScope mapBasedScopeFor(EObject context, Iterable<IEObjectDescription> descriptions) {
        return this.mapBasedScopeFor(context, IScope.NULLSCOPE, descriptions);
    }

    public IScope mapBasedScopeFor(EObject context, IScope parent, Iterable<IEObjectDescription> descriptions) {
        boolean _isMultiQNScope = this.javaScriptVariantHelper.isMultiQNScope(context);
        if (_isMultiQNScope) {
            return MultimapBasedScope.createScope((IScope)parent, descriptions, (boolean)false);
        }
        return MapBasedScope.createScope((IScope)parent, descriptions);
    }

    public IScope scopeFor(Iterable<? extends EObject> elements, Function<IEObjectDescription, ? extends IEObjectDescription> wrapper) {
        return this.scopeFor(elements, wrapper, IScope.NULLSCOPE);
    }

    public IScope scopeFor(Iterable<? extends EObject> elements, Function<IEObjectDescription, ? extends IEObjectDescription> wrapper, IScope outer) {
        return this.scopeFor(elements, QualifiedName.wrapper((Function)SimpleAttributeResolver.NAME_RESOLVER), wrapper, outer);
    }

    public <T extends EObject> IScope scopeFor(Iterable<? extends T> elements, Function<T, QualifiedName> nameComputation, Function<IEObjectDescription, ? extends IEObjectDescription> wrapper, IScope outer) {
        Iterable _transform = Iterables.transform((Iterable)Scopes.scopedElementsFor(elements, nameComputation), wrapper);
        return new SimpleScope(outer, _transform);
    }
}

