/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.generator.headless.BuildSet;
import org.eclipse.n4js.generator.headless.N4JSCompileException;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.N4JSBrokenProjectException;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.URIUtils;

public class HeadlessHelper {
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private N4JSModel n4jsModel;
    @Inject
    private IHeadlessLogger logger;
    @Inject
    private ExternalLibraryHelper externalLibraryHelper;

    public void registerProjects(BuildSet buildSet, FileBasedWorkspace workspace) throws N4JSCompileException {
        Iterable projectUris = Iterables.transform(buildSet.getAllProjects(), p -> p.getLocation());
        this.registerProjectsToFileBasedWorkspace(projectUris, workspace);
    }

    public void registerProjectsToFileBasedWorkspace(Iterable<URI> projectURIs, FileBasedWorkspace workspace) throws N4JSCompileException {
        HashMap<String, URI> registeredProjects = new HashMap<String, URI>();
        workspace.getAllProjectLocationsIterator().forEachRemaining(uri -> {
            String projectName = workspace.getProjectDescription(uri).getProjectName();
            registeredProjects.put(projectName, URIUtils.normalize((URI)uri));
        });
        for (URI uri2 : projectURIs) {
            URI projectURI = URIUtils.normalize((URI)uri2);
            ProjectDescription projectDescription = this.projectDescriptionLoader.loadProjectDescriptionAtLocation(projectURI);
            if (projectDescription == null) {
                throw new N4JSCompileException("Cannot load project description for project at " + projectURI.toFileString() + ". Make sure the project contains a valid package.json file.");
            }
            String projectName = projectDescription.getProjectName();
            if (this.skipRegistering(projectName, projectURI, registeredProjects)) {
                if (this.logger == null || !this.logger.isCreateDebugOutput()) continue;
                this.logger.debug("Skipping already registered project '" + projectURI + "'");
                continue;
            }
            try {
                if (this.logger != null && this.logger.isCreateDebugOutput()) {
                    this.logger.debug("Registering project '" + projectURI + "'");
                }
                workspace.registerProject(projectURI);
                registeredProjects.put(projectName, projectURI);
            }
            catch (N4JSBrokenProjectException e) {
                throw new N4JSCompileException("Unable to register project '" + projectURI + "'", e);
            }
        }
    }

    public List<File> toAbsoluteFileList(List<File> relativeFiles) throws N4JSCompileException {
        ArrayList<File> absProjectRoots = new ArrayList<File>(relativeFiles.size());
        for (File relPR : relativeFiles) {
            try {
                absProjectRoots.add(relPR.getCanonicalFile());
            }
            catch (IOException e) {
                throw new N4JSCompileException("Unable to create canonical filename of file '" + relPR + "'", e);
            }
        }
        return absProjectRoots;
    }

    public List<File> findProjectsForSingleFiles(List<File> sourceFiles, FileBasedWorkspace workspace) throws N4JSCompileException {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (File sourceFile : sourceFiles) {
            URI sourceFileURI = URI.createFileURI((String)sourceFile.toString());
            URI projectURI = workspace.findProjectWith(sourceFileURI);
            if (projectURI == null) {
                throw new N4JSCompileException("No project for file '" + sourceFile.toString() + "' found.");
            }
            result.add(projectURI);
        }
        return result.stream().map(u -> new File(u.toFileString())).collect(Collectors.toList());
    }

    public List<File> collectAllProjectPaths(List<File> absProjectRoots) {
        List<File> projectRoots = this.getProjectStream(absProjectRoots).collect(Collectors.toList());
        return projectRoots;
    }

    public List<N4JSProject> getN4JSProjects(List<URI> projectURIs) {
        return projectURIs.stream().map(URIUtils::normalize).map(u -> this.n4jsModel.getN4JSProject(u)).filter(p -> this.isProjectToBeBuilt((IN4JSProject)p)).collect(Collectors.toList());
    }

    public boolean isProjectToBeBuilt(IN4JSProject project) {
        if (project.isExternal()) {
            return this.externalLibraryHelper.isExternalProjectDirectory(project.getLocationPath().toFile());
        }
        return true;
    }

    public List<URI> createFileURIs(List<File> files) {
        return files.stream().map(f -> URI.createFileURI((String)f.toString())).map(URIUtils::normalize).collect(Collectors.toList());
    }

    private boolean skipRegistering(String projectName, URI projectLocation, Map<String, URI> registeredProjects) throws N4JSCompileException {
        if (!registeredProjects.containsKey(projectName)) {
            return false;
        }
        URI registeredProjectLocation = registeredProjects.get(projectName);
        if (projectLocation.equals(registeredProjectLocation)) {
            return true;
        }
        if (registeredProjectLocation == null) {
            throw new N4JSCompileException("Duplicate project id [" + projectName + "]. Already registered project at " + registeredProjects.get(projectName) + ", trying to register project at " + projectLocation + ".");
        }
        throw new N4JSCompileException("Duplicate project id [" + projectName + "]. Already registered project at " + registeredProjectLocation + ", trying to register project at " + projectLocation + ".");
    }

    private Stream<File> getProjectStream(List<File> absProjectRoots) {
        Stream<File> scopeFolders = absProjectRoots.stream().filter(File::isDirectory).flatMap(root -> Arrays.asList(root.listFiles(File::isDirectory)).stream()).filter(f -> f.getName().startsWith("@"));
        return Stream.concat(scopeFolders, absProjectRoots.stream()).filter(File::isDirectory).flatMap(root -> Arrays.asList(root.listFiles(File::isDirectory)).stream().sorted()).filter(dir -> new File((File)dir, "package.json").isFile());
    }
}

