/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.external;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.binaries.BinariesCommandFactory;
import org.eclipse.n4js.binaries.nodejs.NpmBinary;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.LibraryChange;
import org.eclipse.n4js.external.NpmLogger;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceModel;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.SemverMatcher;
import org.eclipse.n4js.semver.SemverUtils;
import org.eclipse.n4js.utils.NodeModulesDiscoveryHelper;
import org.eclipse.n4js.utils.ProcessExecutionCommandStatus;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.process.ProcessResult;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class NpmCLI {
    @Inject
    private BinariesCommandFactory commandFactory;
    @Inject
    private ProcessExecutionCommandStatus executor;
    @Inject
    private ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    private NodeModulesDiscoveryHelper nodeModulesDiscoveryHelper;
    @Inject
    private StatusHelper statusHelper;
    @Inject
    private NpmLogger logger;
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private NpmBinary npmBinary;
    @Inject
    private SemverHelper semverHelper;

    public boolean invalidPackageName(String packageName) {
        return packageName == null || packageName.trim().isEmpty();
    }

    public boolean invalidPackageVersion(String packageVersion) {
        return packageVersion == null || !packageVersion.isEmpty() && !packageVersion.startsWith("@");
    }

    public VersionNumber getNpmVersion() {
        ProcessResult result = this.commandFactory.checkBinaryVersionCommand(this.npmBinary).execute();
        if (result.isOK()) {
            String output = result.getStdOut();
            return this.semverHelper.parseVersionNumber(output.trim());
        }
        return null;
    }

    public Collection<LibraryChange> uninstall(IProgressMonitor monitor, MultiStatus status, LibraryChange requestedChange) {
        if (requestedChange.type != LibraryChange.LibraryChangeType.Uninstall) {
            throw new IllegalArgumentException("The expected change type is " + (Object)((Object)LibraryChange.LibraryChangeType.Uninstall) + " but is " + (Object)((Object)requestedChange.type));
        }
        String msg = "Uninstalling npm package '" + requestedChange.name + "'";
        MultiStatus resultStatus = this.statusHelper.createMultiStatus(msg);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        java.net.URI nodeModulesLocationURI = this.externalLibraryWorkspace.getRootLocationForResource(requestedChange.location);
        ArrayList<String> packageNames = new ArrayList<String>();
        if (requestedChange.type == LibraryChange.LibraryChangeType.Uninstall && ExternalLibraryPreferenceModel.isNodeModulesLocation(nodeModulesLocationURI)) {
            packageNames.add(requestedChange.name);
        }
        File nodeModulesLocation = new File(nodeModulesLocationURI).getParentFile();
        IStatus installStatus = this.uninstall(packageNames, nodeModulesLocation);
        subMonitor.worked(1);
        LinkedList<LibraryChange> actualChanges = new LinkedList<LibraryChange>();
        if (installStatus == null || !installStatus.isOK()) {
            resultStatus.merge(installStatus);
        } else {
            File npmDirectory = new File(requestedChange.location.toFileString());
            String actualVersion = this.getActualVersion(npmDirectory.toPath());
            if (actualVersion.isEmpty()) {
                actualChanges.add(new LibraryChange(LibraryChange.LibraryChangeType.Removed, requestedChange.location, requestedChange.name, requestedChange.version));
            }
        }
        if (!resultStatus.isOK()) {
            this.logger.logInfo("Some packages could not be uninstalled due to errors, see log for details.");
            status.merge((IStatus)resultStatus);
        }
        return actualChanges;
    }

    public Collection<LibraryChange> batchInstall(IProgressMonitor monitor, MultiStatus status, Collection<LibraryChange> requestedChanges, URI target) {
        return this.batchInstallInternal(monitor, status, requestedChanges, target);
    }

    private Collection<LibraryChange> batchInstallInternal(IProgressMonitor monitor, MultiStatus status, Collection<LibraryChange> requestedChanges, URI target) {
        Set<LibraryChange> actualChanges;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        subMonitor.setTaskName("Installing npm packages.");
        URI localURI = CommonPlugin.asLocalURI((URI)target);
        File installPath = new File(localURI.toFileString());
        ArrayList packageNamesAndVersions = Lists.newArrayList();
        for (LibraryChange reqChg : requestedChanges) {
            if (reqChg.type != LibraryChange.LibraryChangeType.Install) continue;
            packageNamesAndVersions.add(Tuples.pair((Object)reqChg.name, (Object)("@" + reqChg.version)));
        }
        IStatus installStatus = this.install(packageNamesAndVersions, installPath);
        subMonitor.worked(1);
        MultiStatus batchStatus = this.statusHelper.createMultiStatus("Installing npm packages.");
        if (installStatus == null || !installStatus.isOK()) {
            actualChanges = Collections.emptySet();
            batchStatus.merge(installStatus);
        } else {
            actualChanges = this.computeActualChanges(installPath.toPath(), requestedChanges, batchStatus);
        }
        if (!batchStatus.isOK()) {
            this.logger.logInfo("Some packages could not be installed due to errors, see log for details.");
            status.merge((IStatus)batchStatus);
        }
        return actualChanges;
    }

    private Set<LibraryChange> computeActualChanges(Path installPath, Collection<LibraryChange> requestedChanges, MultiStatus mergeStatusHere) {
        LinkedHashSet<LibraryChange> result = new LinkedHashSet<LibraryChange>();
        Path nodeModulesFolder = installPath.resolve("node_modules");
        for (LibraryChange reqChg : requestedChanges) {
            if (reqChg.type != LibraryChange.LibraryChangeType.Install) continue;
            Path completePath = nodeModulesFolder.resolve(reqChg.name);
            String actualVersion = this.getActualVersion(completePath);
            if (actualVersion.isEmpty()) {
                NodeModulesDiscoveryHelper.NodeModulesFolder nmf = this.nodeModulesDiscoveryHelper.getNodeModulesFolder(installPath);
                if (nmf.isYarnWorkspace) {
                    Path nodeModulesFolderInYarnWorkspaceRoot = nmf.nodeModulesFolder.toPath();
                    completePath = nodeModulesFolderInYarnWorkspaceRoot.resolve(reqChg.name);
                    actualVersion = this.getActualVersion(completePath);
                }
            }
            if (actualVersion.isEmpty()) {
                String msg = "Error reading package json when " + reqChg.toString();
                IStatus packJsonError = this.statusHelper.createError(msg);
                mergeStatusHere.merge(packJsonError);
                continue;
            }
            URI actualLocation = URI.createFileURI((String)completePath.toString());
            LibraryChange actualChange = new LibraryChange(LibraryChange.LibraryChangeType.Added, actualLocation, reqChg.name, actualVersion);
            result.add(actualChange);
        }
        return result;
    }

    private String getActualVersion(Path completePath) {
        URI location = URI.createFileURI((String)completePath.toString());
        String versionStr = (String)this.projectDescriptionLoader.loadVersionAndN4JSNatureFromProjectDescriptionAtLocation(location).getFirst();
        return Strings.nullToEmpty((String)versionStr);
    }

    private IStatus install(List<Pair<String, String>> packageNamesAndVersions, File installPath) {
        boolean isNpmUsed;
        ArrayList<String> packageNamesAndVersionsMerged = new ArrayList<String>(packageNamesAndVersions.size());
        for (Pair<String, String> pair : packageNamesAndVersions) {
            String packageName = (String)pair.getFirst();
            String packageVersion = (String)pair.getSecond();
            if (this.invalidPackageName(packageName)) {
                return this.statusHelper.createError("Malformed npm package name: '" + packageName + "'.");
            }
            if (this.invalidPackageVersion(packageVersion)) {
                return this.statusHelper.createError("Malformed npm package version: '" + packageVersion + "'.");
            }
            String nameAndVersion = packageVersion.isEmpty() ? packageName : String.valueOf(packageName) + packageVersion;
            packageNamesAndVersionsMerged.add(nameAndVersion);
        }
        IStatus status = this.executor.execute(() -> this.commandFactory.createInstallPackageCommand(installPath, packageNamesAndVersionsMerged, true), "Error while installing npm package.");
        boolean bl = isNpmUsed = !this.isYarnUsed(installPath);
        if (isNpmUsed) {
            VersionNumber currNpmVersion = this.getNpmVersion();
            VersionNumber fixedNpmVersion = SemverUtils.createVersionNumber((Integer)5, (Integer)7, (Integer)1);
            if (currNpmVersion != null && SemverMatcher.compareLoose((VersionNumber)currNpmVersion, (VersionNumber)fixedNpmVersion) < 0) {
                IStatus workaroundStatus = this.executor.execute(() -> this.commandFactory.createInstallPackageCommand(installPath, Collections.emptyList(), false), "Error while running \"npm install\" after installing npm packages.");
                MultiStatus combinedStatus = this.statusHelper.createMultiStatus("Installing npm packages with additional \"npm install\" afterwards.");
                combinedStatus.merge(status);
                combinedStatus.merge(workaroundStatus);
                status = combinedStatus;
            }
        }
        return status;
    }

    private IStatus uninstall(List<String> packageNames, File uninstallPath) {
        for (String packageName : packageNames) {
            if (!this.invalidPackageName(packageName)) continue;
            return this.statusHelper.createError("Malformed npm package name: '" + packageName + "'.");
        }
        return this.executor.execute(() -> this.commandFactory.createUninstallPackageCommand(uninstallPath, packageNames, true), "Error while uninstalling npm package.");
    }

    public IStatus runNpmYarnInstall(File invocationPath) {
        IStatus status = this.executor.execute(() -> this.commandFactory.createInstallEverythingCommand(invocationPath, true), "Error while installing npm package.");
        return status;
    }

    public boolean isYarnUsed(URI projectURI) {
        URI projectFileURI = projectURI.isFile() ? projectURI : CommonPlugin.asLocalURI((URI)projectURI);
        File projectFile = new File(projectFileURI.toFileString()).getAbsoluteFile();
        return this.isYarnUsed(projectFile);
    }

    public boolean isYarnUsed(File invocationPath) {
        return this.commandFactory.isYarnUsed(invocationPath);
    }
}

