/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.utils;

import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.xtext.service.OperationCanceledManager;

public class EclipseUtils {
    public static void runInModalDialog(OperationCanceledManager ocm, IRunnableWithProgress runnable) {
        EclipseUtils.runInModalDialog(ocm, runnable, null);
    }

    public static void runInModalDialog(OperationCanceledManager ocm, IRunnableWithProgress runnable, Consumer<Throwable> throwableHandler) {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            ProgressMonitorDialog dlg = new ProgressMonitorDialog(shell);
            dlg.run(true, true, monitor -> {
                try {
                    runnable.run(monitor);
                }
                catch (Throwable th) {
                    if (ocm.isOperationCanceledException(th)) {
                        throw new InterruptedException();
                    }
                    if (throwableHandler != null) {
                        throwableHandler.accept(th);
                    }
                    throw th;
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    public static MessageConsole getOrCreateConsole(String name, boolean create, boolean reveal) {
        MessageConsole result = null;
        ConsolePlugin plugin = ConsolePlugin.getDefault();
        IConsoleManager mgr = plugin.getConsoleManager();
        IConsole[] consoles = mgr.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            IConsole currConsole = consoles[i];
            if (currConsole instanceof MessageConsole && name.equals(currConsole.getName())) {
                result = (MessageConsole)currConsole;
                break;
            }
            ++i;
        }
        if (result == null && create) {
            MessageConsole newConsole = new MessageConsole(name, null);
            mgr.addConsoles(new IConsole[]{newConsole});
            result = newConsole;
        }
        if (result != null && reveal) {
            EclipseUtils.revealConsole(result);
        }
        return result;
    }

    public static void revealConsole(final IConsole console) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IConsoleView view = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                    view.display(console);
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
            }
        });
    }
}

