/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.Host;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IRSEPersistableContainer;
import org.eclipse.rse.core.model.ISystemHostPool;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.RSEModelObject;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.core.model.SystemProfileManager;

public class SystemHostPool
extends RSEModelObject
implements ISystemHostPool {
    protected static final String NAME_EDEFAULT;
    private static Hashtable pools;
    private static String CONNECTION_FILE_NAME;
    protected String name = NAME_EDEFAULT;
    private List connections = new ArrayList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.internal.core.model.SystemHostPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        NAME_EDEFAULT = null;
        pools = new Hashtable();
        CONNECTION_FILE_NAME = "connection";
    }

    protected SystemHostPool() {
    }

    public static void reset() {
        pools.clear();
    }

    public static ISystemHostPool getSystemHostPool(ISystemProfile profile) {
        SystemHostPool pool = (SystemHostPool)pools.get(profile);
        if (pool == null) {
            pool = new SystemHostPool();
            pool.setName(profile.getName());
            pools.put(profile, pool);
        }
        return pool;
    }

    public ISystemProfile getSystemProfile() {
        return SystemProfileManager.getDefault().getSystemProfile(this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameHostPool(String newName) {
        List hostList;
        List list = hostList = this.getHostList();
        synchronized (list) {
            String oldName = this.getName();
            Iterator it = hostList.iterator();
            while (it.hasNext()) {
                IHost curHost = (IHost)it.next();
                curHost.renamingSystemProfile(oldName, newName);
            }
            this.setName(newName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printConnections() {
        List conns;
        List list = conns = this.getHostList();
        synchronized (list) {
            Iterator connsList = conns.iterator();
            if (!connsList.hasNext()) {
                System.out.println();
                System.out.println("No connections");
            }
            while (connsList.hasNext()) {
                System.out.println();
                IHost conn = (IHost)connsList.next();
                System.out.println("  AliasName.....: " + conn.getAliasName());
                System.out.println("  -----------------------------------------------------");
                System.out.println("  HostName......: " + conn.getHostName());
                System.out.println("  SystemType....: " + conn.getSystemType().getId());
                System.out.println("  Description...: " + conn.getDescription());
                System.out.println("  UserId........: " + conn.getDefaultUserId());
            }
        }
    }

    public IHost createHost(IRSESystemType systemType, String aliasName, String hostName) {
        return this.createHost(systemType, aliasName, hostName, null, null, 2);
    }

    public IHost createHost(IRSESystemType systemType, String aliasName, String hostName, String description) {
        return this.createHost(systemType, aliasName, hostName, description, null, 2);
    }

    public IHost createHost(IRSESystemType systemType, String aliasName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) {
        boolean exists;
        IHost conn = null;
        boolean bl = exists = this.getHost(aliasName) != null;
        if (exists) {
            return null;
        }
        ISystemProfile profile = this.getSystemProfile();
        if (systemType != null) {
            conn = systemType.createNewHostInstance(profile);
        }
        if (!$assertionsDisabled && conn == null) {
            throw new AssertionError();
        }
        if (conn == null) {
            conn = new Host(profile);
        }
        this.addHost(conn);
        conn.setHostPool(this);
        conn.setAliasName(aliasName);
        conn.setSystemType(systemType);
        if (defaultUserId == null && defaultUserIdLocation == 2) {
            defaultUserId = conn.getDefaultUserId();
        }
        this.updateHost(conn, systemType, aliasName, hostName, description, defaultUserId, defaultUserIdLocation);
        return conn;
    }

    public void updateHost(IHost conn, IRSESystemType systemType, String aliasName, String hostName, String description, String defaultUserId, int defaultUserIdLocation) {
        boolean aliasNameChanged;
        boolean bl = aliasNameChanged = !aliasName.equalsIgnoreCase(conn.getAliasName());
        if (aliasNameChanged) {
            this.renameHost(conn, aliasName);
        }
        conn.setSystemType(systemType);
        conn.setHostName(hostName);
        if (defaultUserIdLocation != 0) {
            if (defaultUserIdLocation != 2) {
                conn.setDefaultUserId(null);
                boolean forceToUpperCase = conn.getForceUserIdToUpperCase();
                if (forceToUpperCase && defaultUserId != null) {
                    defaultUserId = defaultUserId.toUpperCase();
                }
                if (defaultUserIdLocation == 3) {
                    RSEPreferencesManager.setDefaultUserId(systemType, defaultUserId);
                }
            } else {
                conn.setDefaultUserId(defaultUserId);
            }
        }
        conn.setDescription(description);
        this.commit(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHost[] getHosts() {
        List conns;
        List list = conns = this.getHostList();
        synchronized (list) {
            return conns.toArray(new IHost[conns.size()]);
        }
    }

    protected void invalidateCache() {
        this.setDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IHost getHost(String aliasName) {
        List conns;
        List list = conns = this.getHostList();
        synchronized (list) {
            Iterator i = conns.iterator();
            while (i.hasNext()) {
                IHost currconn = (IHost)i.next();
                if (!currconn.getAliasName().equalsIgnoreCase(aliasName)) continue;
                return currconn;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IHost getHost(int pos) {
        List conns;
        List list = conns = this.getHostList();
        synchronized (list) {
            if (pos < conns.size()) {
                return (IHost)conns.get(pos);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHostPosition(IHost conn) {
        List hostList;
        List list = hostList = this.getHostList();
        synchronized (list) {
            return hostList.indexOf(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHostCount() {
        List conns;
        List list = conns = this.getHostList();
        synchronized (list) {
            return conns.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHost(IHost conn) {
        if (!$assertionsDisabled && conn == null) {
            throw new AssertionError();
        }
        if (conn != null) {
            List hostList;
            List list = hostList = this.getHostList();
            synchronized (list) {
                if (!hostList.contains(conn)) {
                    hostList.add(conn);
                }
            }
            conn.setHostPool(this);
            this.invalidateCache();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteHost(IHost conn) {
        List hostList;
        conn.deletingHost();
        List list = hostList = this.getHostList();
        synchronized (list) {
            hostList.remove(conn);
        }
        this.setDirty(true);
        conn.getSystemProfile().commit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameHost(IHost conn, String newName) {
        List list = this.connections;
        synchronized (list) {
            conn.setAliasName(newName);
        }
        this.invalidateCache();
        this.commit(conn);
    }

    public IHost cloneHost(ISystemHostPool targetPool, IHost conn, String aliasName) {
        IHost copy = targetPool.createHost(conn.getSystemType(), aliasName, conn.getHostName(), conn.getDescription(), conn.getLocalDefaultUserId(), 2);
        conn.clonePropertySets(copy);
        return copy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHosts(IHost[] hosts, int delta) {
        boolean moved;
        List hostList;
        final int m = delta > 0 ? -1 : 1;
        TreeSet<Integer> indices = new TreeSet<Integer>(new Comparator(){

            public int compare(Object o1, Object o2) {
                return m * ((Integer)o1).compareTo((Integer)o2);
            }
        });
        List list = hostList = this.getHostList();
        synchronized (list) {
            int i = 0;
            while (i < hosts.length) {
                IHost host = hosts[i];
                int index = hostList.indexOf(host);
                if (index >= 0) {
                    indices.add(new Integer(index));
                }
                ++i;
            }
            moved = indices.size() > 0;
            Iterator z = indices.iterator();
            while (z.hasNext() && moved) {
                int index = (Integer)z.next();
                moved &= this.moveHost(hostList, index, delta);
            }
        }
        if (moved) {
            this.invalidateCache();
            this.commit();
        }
    }

    private boolean moveHost(List hostList, int oldPos, int delta) {
        int newPos;
        boolean moved = false;
        if (oldPos >= 0 && oldPos < hostList.size() && delta != 0 && (newPos = oldPos + delta) >= 0 && newPos < hostList.size()) {
            IHost host = (IHost)hostList.remove(oldPos);
            hostList.add(newPos, host);
            moved = true;
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orderHosts(String[] names) {
        List connList;
        List list = connList = this.getHostList();
        synchronized (list) {
            IHost[] conns = new IHost[names.length];
            int idx = 0;
            while (idx < conns.length) {
                conns[idx] = this.getHost(names[idx]);
                ++idx;
            }
            connList.clear();
            idx = 0;
            while (idx < conns.length) {
                if (conns[idx] != null) {
                    connList.add(conns[idx]);
                }
                ++idx;
            }
        }
        this.invalidateCache();
    }

    protected static String getSaveFileName(IHost connection) {
        return null;
    }

    protected static String getRootSaveFileName(IHost connection) {
        return SystemHostPool.getRootSaveFileName(connection.getAliasName());
    }

    protected static String getRootSaveFileName(String connectionName) {
        String fileName = CONNECTION_FILE_NAME;
        return fileName;
    }

    public String toString() {
        if (this.getName() == null) {
            return this.toStringGen();
        }
        return this.getName();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return RSECoreMessages.RESID_MODELOBJECTS_HOSTPOOL_DESCRIPTION;
    }

    protected void setName(String newName) {
        this.name = newName;
    }

    protected List getHostList() {
        return this.connections;
    }

    public String toStringGen() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(')');
        return result.toString();
    }

    protected void restore() throws Exception {
    }

    protected IHost restore(String connectionName) throws Exception {
        return null;
    }

    public IRSEPersistableContainer getPersistableParent() {
        return null;
    }

    public IRSEPersistableContainer[] getPersistableChildren() {
        return IRSEPersistableContainer.NO_CHILDREN;
    }

    public boolean commit() {
        ISystemProfile profile = this.getSystemProfile();
        boolean result = profile.commit();
        return result;
    }

    public void commit(IHost connection) {
        this.commit();
    }
}

