/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.validation.validators.packagejson;

import com.google.common.base.Optional;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONPackage;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.JSON.NameValuePair;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.packagejson.PackageJsonUtils;
import org.eclipse.n4js.projectDescription.ModuleFilterType;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.resource.XpectAwareFileExtensionCalculator;
import org.eclipse.n4js.semver.Semver.GitHubVersionRequirement;
import org.eclipse.n4js.semver.Semver.LocalPathVersionRequirement;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.SimpleVersion;
import org.eclipse.n4js.semver.Semver.TagVersionRequirement;
import org.eclipse.n4js.semver.Semver.URLVersionRequirement;
import org.eclipse.n4js.semver.Semver.VersionComparator;
import org.eclipse.n4js.semver.Semver.VersionRangeConstraint;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.n4js.semver.SemverHelper;
import org.eclipse.n4js.semver.model.SemverSerializer;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.n4js.utils.io.FileUtils;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.n4js.validation.helper.FolderContainmentHelper;
import org.eclipse.n4js.validation.validators.packagejson.ASTTraceable;
import org.eclipse.n4js.validation.validators.packagejson.AbstractJSONValidatorExtension;
import org.eclipse.n4js.validation.validators.packagejson.CheckProperty;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.Issue;

@Singleton
public class PackageJsonValidatorExtension
extends AbstractJSONValidatorExtension {
    private static final String N4JS_SOURCE_CONTAINERS = "N4JS_SOURCE_CONTAINERS";
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private XpectAwareFileExtensionCalculator fileExtensionCalculator;
    @Inject
    private FolderContainmentHelper containmentHelper;
    @Inject
    private SemverHelper semverHelper;

    @Override
    protected boolean isResponsible(Map<Object, Object> context, EObject eObject) {
        return this.fileExtensionCalculator.getFilenameWithoutXpectExtension(eObject.eResource().getURI()).equals("package.json");
    }

    @Check
    public void checkDocument(JSONDocument document) {
        JSONValue rootValue = document.getContent();
        if (rootValue == null) {
            return;
        }
        if (!this.checkIsType(rootValue, JSONPackage.Literals.JSON_OBJECT, " as document root of a package.json file.")) {
            return;
        }
    }

    @CheckProperty(property=PackageJsonProperties.NAME)
    public void checkName(JSONValue projectNameValue) {
        String msg;
        String scopeNameWithoutPrefix;
        if (!this.checkIsType(projectNameValue, JSONPackage.Literals.JSON_STRING_LITERAL, "as package name")) {
            return;
        }
        JSONStringLiteral projectNameLiteral = (JSONStringLiteral)projectNameValue;
        String projectName = projectNameLiteral.getValue();
        String projectNameWithoutScope = ProjectDescriptionUtils.getPlainProjectName(projectName);
        String scopeName = ProjectDescriptionUtils.getScopeName(projectName);
        if (!ProjectDescriptionUtils.isValidPlainProjectName(projectNameWithoutScope)) {
            this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_PROJECT_NAME(projectNameWithoutScope), (EObject)projectNameValue, "PKGJ_INVALID_PROJECT_NAME");
        }
        if (scopeName != null && !ProjectDescriptionUtils.isValidScopeName(scopeNameWithoutPrefix = scopeName.substring(1))) {
            String msg2 = IssueCodes.getMessageForPKGJ_INVALID_SCOPE_NAME(scopeNameWithoutPrefix);
            this.addIssue(msg2, (EObject)projectNameValue, "PKGJ_INVALID_SCOPE_NAME");
        }
        URI projectUri = projectNameValue.eResource().getURI().trimSegments(1);
        ProjectDescriptionUtils.ProjectNameInfo nameInfo = ProjectDescriptionUtils.ProjectNameInfo.of(projectUri);
        if (!projectNameWithoutScope.equals(nameInfo.projectFolderName)) {
            msg = IssueCodes.getMessageForPKGJ_PACKAGE_NAME_MISMATCH(projectNameWithoutScope, nameInfo.projectFolderName);
            this.addIssue(msg, (EObject)projectNameLiteral, "PKGJ_PACKAGE_NAME_MISMATCH");
        }
        if (scopeName != null && !scopeName.equals(nameInfo.parentFolderName)) {
            msg = IssueCodes.getMessageForPKGJ_SCOPE_NAME_MISMATCH(scopeName, nameInfo.parentFolderName);
            this.addIssue(msg, (EObject)projectNameLiteral, "PKGJ_SCOPE_NAME_MISMATCH");
        }
        if (Platform.isRunning()) {
            if (!nameInfo.eclipseProjectName.isPresent()) {
                return;
            }
            String expectedEclipseProjectName = ProjectDescriptionUtils.convertN4JSProjectNameToEclipseProjectName(projectName);
            if (!expectedEclipseProjectName.equals(nameInfo.eclipseProjectName.get())) {
                String msg3 = IssueCodes.getMessageForPKGJ_PROJECT_NAME_ECLIPSE_MISMATCH(expectedEclipseProjectName, nameInfo.eclipseProjectName.get());
                this.addIssue(msg3, (EObject)projectNameLiteral, "PKGJ_PROJECT_NAME_ECLIPSE_MISMATCH");
            }
        }
    }

    @CheckProperty(property=PackageJsonProperties.VERSION)
    public void checkVersion(JSONValue versionValue) {
        VersionRangeConstraint vrc;
        SimpleVersion simpleVersion;
        if (!this.checkIsType(versionValue, JSONPackage.Literals.JSON_STRING_LITERAL, "as package version")) {
            return;
        }
        JSONStringLiteral versionJsonString = (JSONStringLiteral)versionValue;
        String versionString = versionJsonString.getValue();
        IParseResult parseResult = this.validateSemver(versionValue, versionString);
        NPMVersionRequirement npmVersion = this.semverHelper.parse(parseResult);
        VersionRangeSetRequirement vrs = this.semverHelper.parseVersionRangeSet(parseResult);
        if (vrs == null) {
            String reason = "Cannot parse given string";
            if (npmVersion != null) {
                reason = "Given string is parsed as " + this.getVersionRequirementType(npmVersion);
            }
            String msg = IssueCodes.getMessageForPKGJ_INVALID_VERSION_NUMBER(versionString, reason);
            this.addIssue(msg, (EObject)versionValue, "PKGJ_INVALID_VERSION_NUMBER");
            return;
        }
        if (!vrs.getRanges().isEmpty() && vrs.getRanges().get(0) instanceof VersionRangeConstraint && !(simpleVersion = (SimpleVersion)(vrc = (VersionRangeConstraint)vrs.getRanges().get(0)).getVersionConstraints().get(0)).getComparators().isEmpty()) {
            String comparator = SemverSerializer.serialize((VersionComparator)((VersionComparator)simpleVersion.getComparators().get(0)));
            String reason = "Version numbers must not have comparators: '" + comparator + "'";
            String msg = IssueCodes.getMessageForPKGJ_INVALID_VERSION_NUMBER(versionString, reason);
            this.addIssue(msg, (EObject)versionValue, "PKGJ_INVALID_VERSION_NUMBER");
            return;
        }
    }

    private IParseResult validateSemver(JSONValue versionValue, String versionString) {
        IParseResult parseResult = this.semverHelper.getParseResult(versionString);
        if (parseResult.hasSyntaxErrors()) {
            for (INode firstErrorNode : parseResult.getSyntaxErrors()) {
                String reason = firstErrorNode.getSyntaxErrorMessage().getMessage();
                String msg = IssueCodes.getMessageForPKGJ_INVALID_VERSION_NUMBER(versionString, reason);
                ICompositeNode actualNode = NodeModelUtils.findActualNodeFor((EObject)versionValue);
                int actOffset = actualNode.getOffset();
                int actLength = actualNode.getLength();
                int offset = actOffset + firstErrorNode.getOffset() + 1;
                int lengthTmp = actLength - firstErrorNode.getOffset() - 2;
                int length = Math.max(1, lengthTmp);
                this.addIssue(msg, (EObject)versionValue, offset, length, "PKGJ_INVALID_VERSION_NUMBER");
            }
            return parseResult;
        }
        List issues = this.semverHelper.validate(parseResult);
        for (Issue issue : issues) {
            String msg = "";
            String issueCode = "PKGJ_INVALID_VERSION_NUMBER";
            switch (issue.getSeverity()) {
                case WARNING: {
                    msg = IssueCodes.getMessageForPKGJ_SEMVER_WARNING(issue.getMessage());
                    issueCode = "PKGJ_SEMVER_WARNING";
                    break;
                }
                case ERROR: {
                    msg = IssueCodes.getMessageForPKGJ_SEMVER_ERROR(issue.getMessage());
                    issueCode = "PKGJ_SEMVER_ERROR";
                    break;
                }
            }
            ICompositeNode actualNode = NodeModelUtils.findActualNodeFor((EObject)versionValue);
            int offset = actualNode.getOffset() + issue.getOffset() + 1;
            int length = issue.getLength();
            this.addIssue(msg, (EObject)versionValue, offset, length, issueCode);
        }
        return parseResult;
    }

    private String getVersionRequirementType(NPMVersionRequirement npmVersion) {
        if (npmVersion instanceof TagVersionRequirement) {
            return "tag";
        }
        if (npmVersion instanceof URLVersionRequirement) {
            return "url";
        }
        if (npmVersion instanceof GitHubVersionRequirement) {
            return "github location";
        }
        if (npmVersion instanceof LocalPathVersionRequirement) {
            return "local path";
        }
        return "unknown";
    }

    @CheckProperty(property=PackageJsonProperties.DEPENDENCIES)
    public void checkDependenciesStructure(JSONValue dependenciesValue) {
        this.checkIsDependenciesSection(dependenciesValue);
    }

    @CheckProperty(property=PackageJsonProperties.DEV_DEPENDENCIES)
    public void checkDevDependenciesStructure(JSONValue devDependenciesValue) {
        this.checkIsDependenciesSection(devDependenciesValue);
    }

    private void checkIsDependenciesSection(JSONValue sectionValue) {
        if (!this.checkIsType(sectionValue, JSONPackage.Literals.JSON_OBJECT, "as list of dependencies")) {
            return;
        }
        JSONObject dependenciesObject = (JSONObject)sectionValue;
        for (NameValuePair entry : dependenciesObject.getNameValuePairs()) {
            JSONValue versionRequirement = entry.getValue();
            if (!this.checkIsType(versionRequirement, JSONPackage.Literals.JSON_STRING_LITERAL, "as version specifier")) continue;
            JSONStringLiteral jsonStringVersionRequirement = (JSONStringLiteral)versionRequirement;
            String constraintValue = jsonStringVersionRequirement.getValue();
            this.validateSemver((JSONValue)jsonStringVersionRequirement, constraintValue);
        }
    }

    @CheckProperty(property=PackageJsonProperties.N4JS)
    public void checkN4JSSection(JSONValue n4jsSection) {
        if (!this.checkIsType(n4jsSection, JSONPackage.Literals.JSON_OBJECT, "as package.json n4js section.")) {
            return;
        }
        JSONObject n4jsSectionJO = (JSONObject)n4jsSection;
        Multimap<String, JSONValue> n4jsValues = this.collectObjectValues(n4jsSectionJO);
        this.checkIsType(n4jsValues.get((Object)PackageJsonProperties.VENDOR_ID.name), JSONPackage.Literals.JSON_STRING_LITERAL, "as vendor ID");
        this.checkIsType(n4jsValues.get((Object)PackageJsonProperties.VENDOR_NAME.name), JSONPackage.Literals.JSON_STRING_LITERAL, "as vendor name");
        this.checkIsType(n4jsValues.get((Object)PackageJsonProperties.OUTPUT.name), JSONPackage.Literals.JSON_STRING_LITERAL, "as output folder path");
        this.checkIsType(n4jsValues.get((Object)PackageJsonProperties.EXTENDED_RUNTIME_ENVIRONMENT.name), JSONPackage.Literals.JSON_STRING_LITERAL, "as reference to extended runtime environment");
        this.checkIsArrayOfType(n4jsValues.get((Object)PackageJsonProperties.PROVIDED_RUNTIME_LIBRARIES.name), JSONPackage.Literals.JSON_STRING_LITERAL, "as provided runtime libraries", "as library reference");
        this.checkIsArrayOfType(n4jsValues.get((Object)PackageJsonProperties.REQUIRED_RUNTIME_LIBRARIES.name), JSONPackage.Literals.JSON_STRING_LITERAL, "as required runtime libraries", "as library reference");
        this.checkIsNonEmptyString(n4jsValues.get((Object)PackageJsonProperties.VENDOR_ID.name), PackageJsonProperties.VENDOR_ID);
        this.checkIsNonEmptyString(n4jsValues.get((Object)PackageJsonProperties.VENDOR_NAME.name), PackageJsonProperties.VENDOR_NAME);
        Set<String> allN4JSPropertyNames = PackageJsonProperties.getAllN4JSPropertyNames();
        for (NameValuePair nameValuePair : n4jsSectionJO.getNameValuePairs()) {
            String nvpName = nameValuePair.getName();
            if (allN4JSPropertyNames.contains(nvpName)) continue;
            String msg = IssueCodes.getMessageForPKGJ_PROPERTY_UNKNOWN(nvpName);
            this.addIssue(msg, (EObject)nameValuePair, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME, "PKGJ_PROPERTY_UNKNOWN", new String[0]);
        }
    }

    @CheckProperty(property=PackageJsonProperties.PROJECT_TYPE)
    public void checkProjectType(JSONValue projectTypeValue) {
        String msg;
        boolean hasDefPck;
        if (!this.checkIsType(projectTypeValue, JSONPackage.Literals.JSON_STRING_LITERAL)) {
            return;
        }
        if (!this.checkIsNonEmptyString((JSONStringLiteral)projectTypeValue, PackageJsonProperties.PROJECT_TYPE)) {
            return;
        }
        String projectTypeString = ((JSONStringLiteral)projectTypeValue).getValue();
        ProjectType type = PackageJsonUtils.parseProjectType(projectTypeString);
        if (type == null) {
            this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_PROJECT_TYPE(projectTypeString), (EObject)projectTypeValue, "PKGJ_INVALID_PROJECT_TYPE");
            return;
        }
        boolean isDefType = type == ProjectType.DEFINITION;
        JSONValue propDefinesPck = this.getSingleDocumentValue(PackageJsonProperties.DEFINES_PACKAGE);
        boolean bl = hasDefPck = propDefinesPck != null;
        if (isDefType != hasDefPck) {
            JSONValue issueObj = propDefinesPck == null ? projectTypeValue : propDefinesPck.eContainer();
            String not = propDefinesPck == null ? "" : "not ";
            msg = IssueCodes.getMessageForPKGJ_DEFINES_PROPERTY(type.toString(), not, "definesPackage");
            this.addIssue(msg, (EObject)issueObj, "PKGJ_DEFINES_PROPERTY");
        }
        if (this.isRequiresOutputAndSourceFolder(type)) {
            boolean hasOutput;
            boolean hasSources = this.getSingleDocumentValue(PackageJsonProperties.SOURCES) != null;
            boolean bl2 = hasOutput = this.getSingleDocumentValue(PackageJsonProperties.OUTPUT) != null;
            if (!hasSources || !hasOutput) {
                msg = IssueCodes.getMessageForPKGJ_PROJECT_TYPE_MANDATORY_OUTPUT_AND_SOURCES(projectTypeString);
                this.addIssue(msg, (EObject)projectTypeValue, "PKGJ_PROJECT_TYPE_MANDATORY_OUTPUT_AND_SOURCES");
            }
        }
    }

    private boolean isRequiresOutputAndSourceFolder(ProjectType type) {
        return type != ProjectType.DEFINITION && type != ProjectType.VALIDATION && type != ProjectType.PLAINJS;
    }

    private boolean checkIsNonEmptyString(Iterable<JSONValue> values, PackageJsonProperties property) {
        boolean overallResult = true;
        for (JSONValue value : values) {
            if (!(value instanceof JSONStringLiteral)) continue;
            overallResult &= this.checkIsNonEmptyString((JSONStringLiteral)value, property);
        }
        return overallResult;
    }

    private boolean checkIsType(Iterable<JSONValue> values, EClass valueClass, String locationClause) {
        boolean overallResult = true;
        for (JSONValue value : values) {
            overallResult &= this.checkIsType(value, valueClass, locationClause);
        }
        return overallResult;
    }

    private boolean checkIsArrayOfType(JSONValue value, EClass elementClass, String locationClass, String elementLocation) {
        return this.checkIsType(value, JSONPackage.Literals.JSON_ARRAY, locationClass) && this.checkIsType((Iterable<JSONValue>)((JSONArray)value).getElements(), elementClass, elementLocation);
    }

    private boolean checkIsArrayOfType(Iterable<JSONValue> values, EClass elementClass, String locationClass, String elementLocation) {
        boolean overallResult = true;
        for (JSONValue value : values) {
            overallResult &= this.checkIsType(value, JSONPackage.Literals.JSON_ARRAY, locationClass) && this.checkIsType((Iterable<JSONValue>)((JSONArray)value).getElements(), elementClass, elementLocation);
        }
        return overallResult;
    }

    @CheckProperty(property=PackageJsonProperties.SOURCES)
    public void checkSourceContainers() {
        Multimap<SourceContainerType, List<JSONStringLiteral>> sourceContainers = this.getSourceContainers();
        List<JSONStringLiteral> allDeclaredSourceContainers = sourceContainers.entries().stream().flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toList());
        List<JSONStringLiteral> validSourceContainerLiterals = allDeclaredSourceContainers.stream().filter(l -> this.internalCheckSourceContainerLiteral((JSONStringLiteral)l)).collect(Collectors.toList());
        List<List<JSONStringLiteral>> containerDuplicates = this.findPathDuplicates(allDeclaredSourceContainers);
        for (List<JSONStringLiteral> duplicateGroup : containerDuplicates) {
            String normalizedPath = FileUtils.normalize((String)duplicateGroup.get(0).getValue());
            for (JSONStringLiteral duplicate : duplicateGroup) {
                String inClause = this.createInSourceContainerTypeClause(duplicate, duplicateGroup);
                this.addIssue(IssueCodes.getMessageForPKGJ_DUPLICATE_SOURCE_CONTAINER(normalizedPath, inClause), (EObject)duplicate, "PKGJ_DUPLICATE_SOURCE_CONTAINER");
            }
        }
        this.internalCheckNoNestedSourceContainers(validSourceContainerLiterals);
    }

    private void internalCheckNoNestedSourceContainers(List<JSONStringLiteral> sourceContainers) {
        HashMultimap conflictingPrefixes = HashMultimap.create();
        List containerPaths = sourceContainers.stream().map(ASTTraceable.map(l -> new File(l.getValue()).toPath().normalize())).collect(Collectors.toList());
        for (ASTTraceable path : containerPaths) {
            for (ASTTraceable otherPaths : containerPaths) {
                if (path == otherPaths || ((Path)path.element).equals(otherPaths.element) || !((Path)path.element).startsWith((Path)otherPaths.element) && !((Path)otherPaths.element).toString().isEmpty()) continue;
                conflictingPrefixes.put((Object)path, (Object)otherPaths);
            }
        }
        for (ASTTraceable path : conflictingPrefixes.keySet()) {
            Collection containers = conflictingPrefixes.get((Object)path);
            String containersDescription = containers.stream().map(c -> "\"" + ((JSONStringLiteral)c.astElement).getValue() + "\"").sorted((s1, s2) -> s1.length() - s2.length()).collect(Collectors.joining(", "));
            this.addIssue(IssueCodes.getMessageForPKGJ_NESTED_SOURCE_CONTAINER(containersDescription), path.astElement, "PKGJ_NESTED_SOURCE_CONTAINER");
        }
    }

    private boolean internalCheckSourceContainerLiteral(JSONStringLiteral containerLiteral) {
        if (containerLiteral.getValue().isEmpty()) {
            this.addIssue(IssueCodes.getMessageForPKGJ_EMPTY_SOURCE_PATH(), (EObject)containerLiteral, "PKGJ_EMPTY_SOURCE_PATH");
            return false;
        }
        return this.holdsValidRelativePath(containerLiteral) && this.holdsExistingDirectoryPath(containerLiteral);
    }

    @CheckProperty(property=PackageJsonProperties.MAIN_MODULE)
    public void checkMainModule(JSONValue mainModuleValue) {
        if (!this.checkIsType(mainModuleValue, JSONPackage.Literals.JSON_STRING_LITERAL, "as main module specifier")) {
            return;
        }
        JSONStringLiteral mainModuleLiteral = (JSONStringLiteral)mainModuleValue;
        String mainModuleSpecifier = mainModuleLiteral.getValue();
        if (mainModuleSpecifier.isEmpty() || !this.isExistingModule(mainModuleLiteral)) {
            String specifierToShow = mainModuleSpecifier.isEmpty() ? "<empty string>" : mainModuleSpecifier;
            this.addIssue(IssueCodes.getMessageForPKGJ_NON_EXISTING_MAIN_MODULE(specifierToShow), (EObject)mainModuleLiteral, "PKGJ_NON_EXISTING_MAIN_MODULE");
        }
    }

    @CheckProperty(property=PackageJsonProperties.IMPLEMENTATION_ID)
    public void checkImplementationId(JSONValue value) {
        JSONArray implementedProjectsValue = this.getSingleDocumentValue(PackageJsonProperties.IMPLEMENTED_PROJECTS, JSONArray.class);
        if (!this.checkIsType(value, JSONPackage.Literals.JSON_STRING_LITERAL, "as implementation ID")) {
            return;
        }
        if (!this.checkIsNonEmptyString((JSONStringLiteral)value, PackageJsonProperties.IMPLEMENTATION_ID)) {
            return;
        }
        JSONStringLiteral implementationId = (JSONStringLiteral)value;
        if (implementedProjectsValue == null || implementedProjectsValue.getElements().isEmpty()) {
            this.addIssue(IssueCodes.getMessageForPKGJ_APIIMPL_MISSING_IMPL_PROJECTS(), implementationId.eContainer(), (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME, "PKGJ_APIIMPL_MISSING_IMPL_PROJECTS", new String[0]);
        }
    }

    @CheckProperty(property=PackageJsonProperties.IMPLEMENTED_PROJECTS)
    public void checkImplementedProjects(JSONValue value) {
        if (!this.checkIsType(value, JSONPackage.Literals.JSON_ARRAY, "as list of implemented projects")) {
            return;
        }
        EList implementedProjectValues = ((JSONArray)value).getElements();
        List implementedProjectLiterals = implementedProjectValues.stream().map(v -> {
            if (!this.checkIsType((JSONValue)v, JSONPackage.Literals.JSON_STRING_LITERAL, "as implemented project reference")) {
                return null;
            }
            return (JSONStringLiteral)v;
        }).filter(p -> p != null).collect(Collectors.toList());
        JSONStringLiteral declaredProjectNameValue = this.getSingleDocumentValue(PackageJsonProperties.NAME, JSONStringLiteral.class);
        if (declaredProjectNameValue == null) {
            return;
        }
        for (JSONStringLiteral implementedProjectLiteral : implementedProjectLiterals) {
            if (!implementedProjectLiteral.getValue().equals(declaredProjectNameValue.getValue())) continue;
            this.addIssue(IssueCodes.getMessageForPKGJ_APIIMPL_REFLEXIVE(), (EObject)implementedProjectLiteral, "PKGJ_APIIMPL_REFLEXIVE");
        }
    }

    @CheckProperty(property=PackageJsonProperties.TESTED_PROJECTS)
    public void checkTestedProjects(JSONValue testedProjectsValues) {
        if (!this.checkIsArrayOfType(testedProjectsValues, JSONPackage.Literals.JSON_STRING_LITERAL, "as list of tested projects", "as tested project reference")) {
            return;
        }
    }

    private URI getResourceRelativeURI(Resource resource, String relativePath) {
        String normalizedStringPath = FileUtils.normalize((String)relativePath);
        URI relativeLocation = URI.createURI((String)normalizedStringPath);
        URI resourceContainerLocation = resource.getURI().trimSegments(1).appendSegment("");
        return relativeLocation.resolve(resourceContainerLocation);
    }

    @Check
    public void checkOutputFolder(JSONDocument document) {
        JSONValue outputPathValue = this.getSingleDocumentValue(PackageJsonProperties.OUTPUT);
        if (outputPathValue != null) {
            if (!(outputPathValue instanceof JSONStringLiteral)) {
                return;
            }
            if (!this.checkIsNonEmptyString((JSONStringLiteral)outputPathValue, PackageJsonProperties.OUTPUT)) {
                return;
            }
        }
        if (outputPathValue != null) {
            this.internalCheckOutput(((JSONStringLiteral)outputPathValue).getValue(), (Optional<JSONValue>)Optional.fromNullable((Object)outputPathValue));
        } else {
            this.internalCheckOutput(PackageJsonProperties.OUTPUT.defaultValue, (Optional<JSONValue>)Optional.absent());
        }
    }

    private void internalCheckOutput(String outputPath, Optional<JSONValue> astOutputValue) {
        Resource resource = this.getDocument().eResource();
        URI absoluteOutputLocation = this.getResourceRelativeURI(resource, outputPath);
        ProjectType projectType = this.getProjectType();
        if (projectType == ProjectType.DEFINITION && astOutputValue.isPresent()) {
            String message = IssueCodes.getMessageForPKGJ_DEFINES_PROPERTY(projectType.name(), "not ", "output");
            this.addIssue(message, ((JSONValue)astOutputValue.get()).eContainer(), "PKGJ_DEFINES_PROPERTY");
        }
        if (!this.isRequiresOutputAndSourceFolder(projectType)) {
            return;
        }
        Multimap<SourceContainerType, List<JSONStringLiteral>> sourceContainers = this.getSourceContainers();
        for (Map.Entry sourceContainerType : sourceContainers.entries()) {
            for (JSONStringLiteral sourceContainerSpecifier : (List)sourceContainerType.getValue()) {
                String message;
                String nestedFolder;
                String containingFolder;
                URI absoluteSourceLocation = this.getResourceRelativeURI(resource, sourceContainerSpecifier.getValue());
                String srcFrgmtName = ((SourceContainerType)sourceContainerType.getKey()).getLiteral().toLowerCase();
                if (this.containmentHelper.isContained(absoluteSourceLocation, absoluteOutputLocation)) {
                    containingFolder = "A " + srcFrgmtName + " folder";
                    nestedFolder = astOutputValue.isPresent() ? "the output folder" : "the default output folder \"" + PackageJsonProperties.OUTPUT.defaultValue + "\"";
                    message = IssueCodes.getMessageForOUTPUT_AND_SOURCES_FOLDER_NESTING(containingFolder, nestedFolder);
                    this.addIssue(message, (EObject)sourceContainerSpecifier, "OUTPUT_AND_SOURCES_FOLDER_NESTING");
                }
                if (!astOutputValue.isPresent() || !this.containmentHelper.isContained(absoluteOutputLocation, absoluteSourceLocation)) continue;
                containingFolder = "The output folder";
                nestedFolder = "a " + srcFrgmtName + " folder";
                message = IssueCodes.getMessageForOUTPUT_AND_SOURCES_FOLDER_NESTING("The output folder", nestedFolder);
                this.addIssue(message, (EObject)astOutputValue.get(), "OUTPUT_AND_SOURCES_FOLDER_NESTING");
            }
        }
    }

    @CheckProperty(property=PackageJsonProperties.MODULE_FILTERS)
    public void checkModuleFilters(JSONValue moduleFilterSection) {
        if (!this.checkIsType(moduleFilterSection, JSONPackage.Literals.JSON_OBJECT, "as moduleFilters section")) {
            return;
        }
        for (NameValuePair pair : ((JSONObject)moduleFilterSection).getNameValuePairs()) {
            this.internalCheckModuleFilterEntry(pair);
        }
    }

    private void internalCheckModuleFilterEntry(NameValuePair moduleFilterPair) {
        ModuleFilterType filterType = PackageJsonUtils.parseModuleFilterType(moduleFilterPair.getName());
        if (filterType == null) {
            String message = IssueCodes.getMessageForPKGJ_INVALID_MODULE_FILTER_TYPE(moduleFilterPair.getName(), "noValidate");
            this.addIssue(message, (EObject)moduleFilterPair, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME, "PKGJ_INVALID_MODULE_FILTER_TYPE", new String[0]);
        }
        if (!this.checkIsType(moduleFilterPair.getValue(), JSONPackage.Literals.JSON_ARRAY, "as module filter specifiers")) {
            return;
        }
        EList specifierValues = ((JSONArray)moduleFilterPair.getValue()).getElements();
        Set<String> sourceContainerPaths = this.getAllSourceContainerPaths();
        List<ValidationModuleFilterSpecifier> declaredFilterSpecifiers = specifierValues.stream().map(v -> this.getModuleFilterInformation((JSONValue)v, filterType)).collect(Collectors.toList());
        declaredFilterSpecifiers.forEach(specifier -> this.checkModuleFilterSpecifier((ValidationModuleFilterSpecifier)specifier));
        Map<String, List<ValidationModuleFilterSpecifier>> duplicateGroups = declaredFilterSpecifiers.stream().filter(i -> i != null).flatMap(i -> {
            if (i.sourceContainerPath == null) {
                return sourceContainerPaths.stream().map(sourceContainer -> new ValidationModuleFilterSpecifier(validationModuleFilterSpecifier.filter, (String)sourceContainer, validationModuleFilterSpecifier.filterType, validationModuleFilterSpecifier.astRepresentation));
            }
            return Stream.of(i);
        }).collect(Collectors.groupingBy(s -> String.valueOf(s.filter) + ":" + s.sourceContainerPath));
        HashSet duplicateFilterSpecifiers = new HashSet();
        duplicateGroups.entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).flatMap(group -> ((List)group.getValue()).stream().skip(1L)).forEach(duplicate -> {
            boolean bl = duplicateFilterSpecifiers.add(duplicate.astRepresentation);
        });
        for (JSONValue duplicateFilterSpecifier : duplicateFilterSpecifiers) {
            this.addIssue(IssueCodes.getMessageForPKGJ_DUPLICATE_MODULE_FILTER_SPECIFIER(), (EObject)duplicateFilterSpecifier, "PKGJ_DUPLICATE_MODULE_FILTER_SPECIFIER");
        }
    }

    private void checkModuleFilterSpecifier(ValidationModuleFilterSpecifier specifier) {
        Set<String> sourceContainerPaths = this.getAllSourceContainerPaths();
        if (specifier != null && specifier.sourceContainerPath != null && !sourceContainerPaths.contains(specifier.sourceContainerPath)) {
            this.addIssue(IssueCodes.getMessageForPKGJ_SRC_IN_FILTER_IS_NO_DECLARED_SOURCE(specifier.sourceContainerPath), (EObject)specifier.astRepresentation, "PKGJ_SRC_IN_FILTER_IS_NO_DECLARED_SOURCE");
        }
    }

    private ValidationModuleFilterSpecifier getModuleFilterInformation(JSONValue value, ModuleFilterType type) {
        if (value instanceof JSONStringLiteral) {
            return new ValidationModuleFilterSpecifier(((JSONStringLiteral)value).getValue(), null, type, value);
        }
        if (value instanceof JSONObject) {
            EList pairs = ((JSONObject)value).getNameValuePairs();
            NameValuePair sourceContainerPair = pairs.stream().filter(p -> PackageJsonProperties.NV_SOURCE_CONTAINER.name.equals(p.getName())).findFirst().orElse(null);
            NameValuePair moduleFilterPair = pairs.stream().filter(p -> PackageJsonProperties.NV_MODULE.name.equals(p.getName())).findFirst().orElse(null);
            if ((sourceContainerPair == null || this.checkIsType(sourceContainerPair.getValue(), JSONPackage.Literals.JSON_STRING_LITERAL)) && moduleFilterPair != null && this.checkIsType(moduleFilterPair.getValue(), JSONPackage.Literals.JSON_STRING_LITERAL)) {
                String sourceContainer = sourceContainerPair != null ? ((JSONStringLiteral)sourceContainerPair.getValue()).getValue() : null;
                String moduleFilter = ((JSONStringLiteral)moduleFilterPair.getValue()).getValue();
                return new ValidationModuleFilterSpecifier(moduleFilter, sourceContainer, type, value);
            }
        }
        this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_MODULE_FILTER_SPECIFIER(), (EObject)value, "PKGJ_INVALID_MODULE_FILTER_SPECIFIER");
        return null;
    }

    private boolean isExistingModule(JSONStringLiteral moduleSpecifierLiteral) {
        URI uri = moduleSpecifierLiteral.eResource().getURI();
        String moduleSpecifier = moduleSpecifierLiteral.getValue();
        String relativeModulePath = moduleSpecifier.replace('/', File.separator.charAt(0));
        Path absoluteProjectPath = this.getAbsoluteProjectPath(uri);
        Stream<File> sourceFolders = this.getAllSourceContainerPaths().stream().map(sourcePath -> new File(absoluteProjectPath.toFile(), (String)sourcePath));
        List<String> moduleExtensions = Arrays.asList("n4js", "n4jsx", "n4jsd", "js", "jsx");
        return sourceFolders.filter(sourceFolder -> moduleExtensions.stream().filter(ext -> new File((File)sourceFolder, String.valueOf(relativeModulePath) + "." + ext).exists()).findAny().isPresent()).findAny().isPresent();
    }

    private boolean holdsValidRelativePath(JSONStringLiteral pathLiteral) {
        block4: {
            try {
                Path path = Paths.get(pathLiteral.getValue(), new String[0]);
                if (!path.isAbsolute()) break block4;
                this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_ABSOLUTE_PATH(pathLiteral.getValue()), (EObject)pathLiteral, "PKGJ_INVALID_ABSOLUTE_PATH");
                return false;
            }
            catch (InvalidPathException e) {
                this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_PATH(pathLiteral.getValue()), (EObject)pathLiteral, "PKGJ_INVALID_PATH");
                return false;
            }
        }
        if (pathLiteral.getValue().contains("*")) {
            this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_PATH(pathLiteral.getValue()), (EObject)pathLiteral, "PKGJ_INVALID_PATH");
            return false;
        }
        return true;
    }

    private boolean holdsExistingDirectoryPath(JSONStringLiteral pathLiteral) {
        URI resourceURI = pathLiteral.eResource().getURI();
        Optional<? extends IN4JSProject> n4jsProject = this.n4jsCore.findProject(resourceURI);
        if (!n4jsProject.isPresent()) {
            return true;
        }
        URI projectLocation = ((IN4JSProject)n4jsProject.get()).getLocation();
        URI projectRelativeResourceURI = resourceURI.deresolve(projectLocation.appendSegment(""));
        Path absoluteProjectPath = ((IN4JSProject)n4jsProject.get()).getLocationPath().toAbsolutePath();
        if (absoluteProjectPath == null) {
            throw new IllegalStateException("Failed to compute project path for package.json at " + resourceURI.toString());
        }
        Path baseResourcePath = new File(absoluteProjectPath.toString(), projectRelativeResourceURI.trimSegments(1).toFileString()).toPath();
        String relativePath = pathLiteral.getValue();
        File file = new File(baseResourcePath.toString(), relativePath);
        if (!file.exists()) {
            this.addIssue(IssueCodes.getMessageForPKGJ_NON_EXISTING_SOURCE_PATH(relativePath), (EObject)pathLiteral, "PKGJ_NON_EXISTING_SOURCE_PATH");
            return false;
        }
        if (!file.isDirectory()) {
            this.addIssue(IssueCodes.getMessageForPKGJ_EXPECTED_DIRECTORY_PATH(relativePath), (EObject)pathLiteral, "PKGJ_EXPECTED_DIRECTORY_PATH");
            return false;
        }
        return true;
    }

    private String createInSourceContainerTypeClause(JSONStringLiteral issueTarget, List<JSONStringLiteral> duplicates) {
        SourceContainerType targetContainerType = this.getSourceContainerType(issueTarget);
        Set otherTypes = duplicates.stream().filter(d -> d != issueTarget).map(d -> this.getSourceContainerType((JSONStringLiteral)d)).collect(Collectors.toSet());
        if (otherTypes.size() == 1 && otherTypes.iterator().next() == targetContainerType) {
            return "";
        }
        return " in " + otherTypes.stream().map(t -> t.getLiteral().toLowerCase()).collect(Collectors.joining(", "));
    }

    private Path getAbsoluteProjectPath(URI nestedLocation) {
        Optional<? extends IN4JSProject> n4jsProject = this.n4jsCore.findProject(nestedLocation);
        if (!n4jsProject.isPresent()) {
            return null;
        }
        return ((IN4JSProject)n4jsProject.get()).getLocationPath().toAbsolutePath();
    }

    private List<List<JSONStringLiteral>> findPathDuplicates(List<JSONStringLiteral> paths) {
        Map<String, List<JSONStringLiteral>> groupedStrings = paths.stream().collect(Collectors.groupingBy(s -> FileUtils.normalize((String)s.getValue())));
        return groupedStrings.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).map(entry -> (List)entry.getValue()).collect(Collectors.toList());
    }

    private Set<String> getAllSourceContainerPaths() {
        return this.getSourceContainers().entries().stream().flatMap(e -> ((List)e.getValue()).stream()).map(literal -> literal.getValue()).collect(Collectors.toSet());
    }

    private ProjectType getProjectType() {
        JSONValue projectTypeValue = this.getSingleDocumentValue(PackageJsonProperties.PROJECT_TYPE);
        if (projectTypeValue instanceof JSONStringLiteral) {
            return PackageJsonUtils.parseProjectType(JSONModelUtils.asNonEmptyStringOrNull((JSONValue)projectTypeValue));
        }
        return ProjectType.PLAINJS;
    }

    private Multimap<SourceContainerType, List<JSONStringLiteral>> getSourceContainers() {
        return (Multimap)this.contextMemoize(N4JS_SOURCE_CONTAINERS, this::doGetSourceContainers);
    }

    private Multimap<SourceContainerType, List<JSONStringLiteral>> doGetSourceContainers() {
        Collection<JSONValue> sourcesValues = this.getDocumentValues(PackageJsonProperties.SOURCES);
        if (sourcesValues.isEmpty()) {
            return ImmutableMultimap.of();
        }
        if (!this.checkIsType(sourcesValues, JSONPackage.Literals.JSON_OBJECT, "as source container section")) {
            return ImmutableMultimap.of();
        }
        JSONValue sourcesValue = sourcesValues.iterator().next();
        JSONObject sourceContainerObject = (JSONObject)sourcesValue;
        HashMultimap sourceContainerValues = HashMultimap.create();
        for (NameValuePair pair : sourceContainerObject.getNameValuePairs()) {
            String sourceContainerType = pair.getName();
            if (!this.isValidSourceContainerTypeLiteral(sourceContainerType)) {
                this.addIssue(IssueCodes.getMessageForPKGJ_INVALID_SOURCE_CONTAINER_TYPE(sourceContainerType), (EObject)pair, (EStructuralFeature)JSONPackage.Literals.NAME_VALUE_PAIR__NAME, "PKGJ_INVALID_SOURCE_CONTAINER_TYPE", new String[0]);
                continue;
            }
            SourceContainerType containerType = SourceContainerType.get((String)pair.getName().toUpperCase());
            if (!this.checkIsType(pair.getValue(), JSONPackage.Literals.JSON_ARRAY, "as source container list")) continue;
            JSONArray sourceContainerSpecifiers = (JSONArray)pair.getValue();
            ArrayList<JSONStringLiteral> specifierLiterals = new ArrayList<JSONStringLiteral>();
            for (JSONValue specifier : sourceContainerSpecifiers.getElements()) {
                if (!this.checkIsType(specifier, JSONPackage.Literals.JSON_STRING_LITERAL, "as source container specifier")) continue;
                specifierLiterals.add((JSONStringLiteral)specifier);
            }
            sourceContainerValues.put((Object)containerType, specifierLiterals);
        }
        return sourceContainerValues;
    }

    private SourceContainerType getSourceContainerType(JSONStringLiteral containerSpecifierLiteral) {
        if (!(containerSpecifierLiteral.eContainer() instanceof JSONArray && containerSpecifierLiteral.eContainer().eContainer() instanceof NameValuePair && this.isValidSourceContainerTypeLiteral(((NameValuePair)containerSpecifierLiteral.eContainer().eContainer()).getName()))) {
            return null;
        }
        NameValuePair containerTypeAssignment = (NameValuePair)containerSpecifierLiteral.eContainer().eContainer();
        return SourceContainerType.get((String)containerTypeAssignment.getName().toUpperCase());
    }

    private boolean isValidSourceContainerTypeLiteral(String typeLiteral) {
        return typeLiteral.toLowerCase().equals(typeLiteral) && SourceContainerType.get((String)typeLiteral.toUpperCase()) != null;
    }

    private static class ValidationModuleFilterSpecifier {
        final String filter;
        final String sourceContainerPath;
        final ModuleFilterType filterType;
        final JSONValue astRepresentation;

        public ValidationModuleFilterSpecifier(String filter, String sourceContainerPath, ModuleFilterType filterType, JSONValue astRepresentation) {
            this.filter = filter;
            this.sourceContainerPath = sourceContainerPath;
            this.filterType = filterType;
            this.astRepresentation = astRepresentation;
        }

        public String toString() {
            return "ModuleFilterSpecifer(" + this.filter + (this.sourceContainerPath != null ? " in " + this.sourceContainerPath : "") + ")";
        }
    }
}

