/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Composite;
import org.eclipse.n4js.jsdoc.dom.ContentNode;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.InlineTag;
import org.eclipse.n4js.jsdoc.dom.LineTag;
import org.eclipse.n4js.jsdoc.dom.Literal;
import org.eclipse.n4js.jsdoc.dom.SimpleTypeReference;
import org.eclipse.n4js.jsdoc.dom.TagValue;
import org.eclipse.n4js.jsdoc.dom.Text;
import org.eclipse.n4js.jsdoc.dom.VariableReference;
import org.eclipse.n4js.jsdoc2spec.KeyUtils;
import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.n4js.jsdoc2spec.SpecTestInfo;
import org.eclipse.n4js.jsdoc2spec.adoc.Html2ADocConverter;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.jsdoc2spec.adoc.SourceEntry;
import org.eclipse.n4js.jsdoc2spec.adoc.SourceEntryFactory;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecIdentifiableElementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecRequirementSection;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecSection;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.FieldAccessor;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMemberWithAccessModifier;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TN4Classifier;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.util.AllSuperTypesCollector;
import org.eclipse.n4js.validation.N4JSElementKeywordProvider;
import org.eclipse.n4js.validation.ValidatorMessageHelper;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ADocSerializer {
    @Inject
    @Extension
    private Html2ADocConverter _html2ADocConverter;
    @Inject
    private ValidatorMessageHelper validatorMessageHelper;
    @Inject
    private N4JSElementKeywordProvider keywordProvider;
    @Inject
    private RepoRelativePathHolder repoPathHolder;

    public CharSequence process(SpecRequirementSection spec, Map<String, SpecSection> specsByKey) {
        StringBuilder strb = new StringBuilder();
        this.appendSpecElementPost(strb, spec, specsByKey);
        return strb;
    }

    public CharSequence process(SpecIdentifiableElementSection spec, Map<String, SpecSection> specsByKey) {
        StringBuilder strb = new StringBuilder();
        this.appendSpecElementPre(strb, spec);
        this.appendSpec(strb, spec);
        this.appendSpecElementPost(strb, spec, specsByKey);
        return strb;
    }

    private StringBuilder appendSpecElementPost(StringBuilder strb, SpecRequirementSection spec, Map<String, SpecSection> map) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(spec.getTestInfosForType());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.testTitle;
            Map groupdTests = IterableExtensions.groupBy(spec.getTestInfosForType(), (Functions.Function1)_function);
            this.appendApiConstraints(strb, groupdTests);
        }
        return strb;
    }

    private StringBuilder appendSpec(StringBuilder strb, SpecIdentifiableElementSection spec) {
        strb.append("\n");
        boolean addedTaskLinks = false;
        EList taskTags = spec.getDoclet().lineTags(N4JSDocletParser.TAG_TASK.getTitle());
        for (LineTag tag : taskTags) {
            boolean _not;
            String taskID = N4JSDocletParser.TAG_TASK.getValue(tag, "");
            boolean _isEmpty = taskID.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            boolean _startsWith = taskID.startsWith("*");
            if (_startsWith) {
                this.appendTaskLink(strb, taskID.substring(1));
            } else {
                this.appendTaskLink(strb, taskID);
            }
            strb.append(" ");
            addedTaskLinks = true;
        }
        if (addedTaskLinks) {
            strb.append("\n\n");
        }
        this.appendSpecDescription(strb, spec);
        return strb;
    }

    private StringBuilder appendSpecDescription(StringBuilder strb, SpecIdentifiableElementSection spec) {
        boolean _isEmpty;
        boolean _not;
        Doclet doclet = spec.getDoclet();
        boolean bSpecFromDescr = doclet.hasLineTag(N4JSDocletParser.TAG_SPECFROMDESCR.getTitle());
        String reqID = this.getReqId(doclet);
        EList specTags = doclet.lineTags(N4JSDocletParser.TAG_SPEC.getTitle());
        if (specTags.isEmpty() && !bSpecFromDescr && reqID.isEmpty()) {
            return strb;
        }
        if (!(spec.idElement instanceof TN4Classifier) && !(spec.idElement instanceof TEnum)) {
            strb.append("==== Description\n\n");
        }
        boolean bl = _not = !(_isEmpty = reqID.isEmpty());
        if (_not) {
            strb.append("See req:" + reqID + "[].\n");
        }
        this.appendContents(strb, (Composite)doclet);
        for (LineTag tag : specTags) {
            this.appendContents(strb, (Composite)tag.getValueByKey("CONTENTS"));
        }
        strb.append("\n");
        return strb;
    }

    private StringBuilder appendSpecDescriptions(StringBuilder strb, Iterable<Doclet> doclets) {
        for (Doclet doclet : doclets) {
            boolean bSpecFromDescr = doclet.hasLineTag(N4JSDocletParser.TAG_SPECFROMDESCR.getTitle());
            EList specTags = doclet.lineTags(N4JSDocletParser.TAG_SPEC.getTitle());
            if (specTags.isEmpty() && !bSpecFromDescr) continue;
            this.appendContents(strb, (Composite)doclet);
            for (LineTag tag : specTags) {
                this.appendContents(strb, (Composite)tag.getValueByKey("CONTENTS"));
            }
        }
        return strb;
    }

    private StringBuilder appendContents(StringBuilder strb, Composite composite) {
        boolean _not;
        EList _contents = composite.getContents();
        for (ContentNode c : _contents) {
            strb.append(this.processContent(c));
        }
        boolean _isEmpty = composite.getContents().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            strb.append("\n");
        }
        return strb;
    }

    private CharSequence _processContent(ContentNode node) {
        return null;
    }

    private CharSequence _processContent(Text node) {
        return this._html2ADocConverter.transformHTML(node.getText());
    }

    private CharSequence _processContent(Literal node) {
        return this._html2ADocConverter.transformHTML(node.getValue());
    }

    private CharSequence _processContent(SimpleTypeReference node) {
        return this._html2ADocConverter.passThenMonospace(this._html2ADocConverter.transformHTML(node.getTypeName()));
    }

    private CharSequence _processContent(VariableReference node) {
        return this._html2ADocConverter.passThenMonospace(this._html2ADocConverter.transformHTML(node.getVariableName()));
    }

    private CharSequence _processContent(InlineTag node) {
        String _title_2;
        String _switchResult = null;
        String _title = node.getTitle().getTitle();
        boolean _matched = false;
        String _title_1 = N4JSDocletParser.TAG_CODE.getTitle();
        if (Objects.equal((Object)_title, (Object)_title_1)) {
            _matched = true;
            _switchResult = this._html2ADocConverter.passThenMonospace(this._html2ADocConverter.transformHTML(N4JSDocletParser.TAG_CODE.getValue(node, "")));
        }
        if (!_matched && Objects.equal((Object)_title, (Object)(_title_2 = N4JSDocletParser.TAG_LINK.getTitle()))) {
            _matched = true;
            _switchResult = this._html2ADocConverter.passThenMonospace(this._html2ADocConverter.transformHTML(N4JSDocletParser.TAG_LINK.getValue(node, "")));
        }
        if (!_matched) {
            StringBuilder strb = new StringBuilder();
            Consumer<TagValue> _function = it -> this.appendContents(strb, (Composite)it);
            node.getValues().forEach(_function);
            return strb;
        }
        return _switchResult;
    }

    private StringBuilder appendSpecElementPre(StringBuilder strb, SpecIdentifiableElementSection spec) {
        return this.appendElementCodePre(strb, spec.getIdentifiableElement(), spec);
    }

    private StringBuilder _appendElementCodePre(StringBuilder strb, IdentifiableElement element, SpecIdentifiableElementSection spec) {
        boolean _hasTodo = this.hasTodo(spec.getDoclet());
        if (_hasTodo) {
            strb.append(this.getTodoLink(spec.getDoclet()));
        }
        return strb;
    }

    private StringBuilder _appendElementCodePre(StringBuilder strb, TMember element, SpecIdentifiableElementSection spec) {
        return this.appendMemberOrVarOrFuncPre(strb, this.validatorMessageHelper.shortDescription(element), this.validatorMessageHelper.shortQualifiedName(element), element.getMemberAsString(), (SyntaxRelatedTElement)element, spec);
    }

    private StringBuilder _appendElementCodePre(StringBuilder strb, TMethod element, SpecIdentifiableElementSection spec) {
        return this.appendMemberOrVarOrFuncPre(strb, this.validatorMessageHelper.shortDescription((TMember)element), this.validatorMessageHelper.shortQualifiedName((TMember)element), element.getMemberAsString(), (SyntaxRelatedTElement)element, spec);
    }

    private StringBuilder _appendElementCodePre(StringBuilder strb, TFunction element, SpecIdentifiableElementSection spec) {
        return this.appendMemberOrVarOrFuncPre(strb, this.validatorMessageHelper.shortDescription(element), this.validatorMessageHelper.shortQualifiedName(element), element.getName(), (SyntaxRelatedTElement)element, spec);
    }

    private StringBuilder _appendElementCodePre(StringBuilder strb, TVariable element, SpecIdentifiableElementSection spec) {
        return this.appendMemberOrVarOrFuncPre(strb, this.validatorMessageHelper.shortDescription(element), this.validatorMessageHelper.shortQualifiedName(element), element.getName(), (SyntaxRelatedTElement)element, spec);
    }

    private StringBuilder appendMemberOrVarOrFuncPre(StringBuilder strb, String shortDescr, String shortQN, String reqName, SyntaxRelatedTElement element, SpecIdentifiableElementSection spec) {
        boolean isIntegratedFromPolyfill = !Objects.equal((Object)spec.sourceEntry.trueFolder, (Object)spec.sourceEntry.folder);
        String trueSrcFolder = String.valueOf(spec.sourceEntry.repository) + ":" + spec.sourceEntry.trueFolder;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("[[gsec:spec_");
        String _adocCompatibleAnchorID = spec.sourceEntry.getAdocCompatibleAnchorID();
        _builder.append(_adocCompatibleAnchorID);
        _builder.append("]]");
        _builder.newLineIfNotEmpty();
        _builder.append("[role=memberdoc]");
        _builder.newLine();
        _builder.append("=== ");
        String _pass = this._html2ADocConverter.pass((CharSequence)StringExtensions.toFirstUpper((String)shortDescr));
        _builder.append(_pass);
        _builder.newLineIfNotEmpty();
        boolean _hasTodo = this.hasTodo(spec.getDoclet());
        if (_hasTodo) {
            String _todoLink = this.getTodoLink(spec.getDoclet());
            _builder.append(_todoLink);
            _builder.newLineIfNotEmpty();
        }
        if (isIntegratedFromPolyfill) {
            _builder.newLine();
            _builder.append("[.small]#(Integrated from static polyfill aware class in: ");
            _builder.append(trueSrcFolder);
            _builder.append(")#");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("==== Signature");
        _builder.newLine();
        _builder.newLine();
        CharSequence _codeLink = this.codeLink((EObject)element);
        _builder.append((Object)_codeLink);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        strb.append((CharSequence)_builder);
        return strb;
    }

    private CharSequence _codeLink(TMember member) {
        return this.doCodeLink((IdentifiableElement)member, this.fullSignature(member));
    }

    private CharSequence _codeLink(TMethod method) {
        return this.doCodeLink((IdentifiableElement)method, this.fullSignature(method));
    }

    private CharSequence _codeLink(TFunction func) {
        return this.doCodeLink((IdentifiableElement)func, this.fullSignature(func));
    }

    private CharSequence _codeLink(TVariable tvar) {
        return this.doCodeLink((IdentifiableElement)tvar, this.fullSignature(tvar));
    }

    private String fullSignature(TMember member) {
        StringBuilder strb = new StringBuilder();
        Functions.Function1 _function = it -> {
            String _name = it.getName();
            return !Objects.equal((Object)_name, (Object)AnnotationDefinition.INTERNAL.name);
        };
        Iterable _filter = IterableExtensions.filter((Iterable)member.getAnnotations(), (Functions.Function1)_function);
        for (TAnnotation a : _filter) {
            String _annotationAsString = a.getAnnotationAsString();
            String _plus = String.valueOf(_annotationAsString) + " ";
            strb.append(_plus);
        }
        String _keyword = this.keywordProvider.keyword((Object)member.getMemberAccessModifier());
        String _plus_1 = String.valueOf(_keyword) + " ";
        strb.append(_plus_1);
        boolean _isAbstract = member.isAbstract();
        if (_isAbstract) {
            strb.append("@abstract ");
        }
        strb.append(member.getMemberAsString());
        return strb.toString();
    }

    private String fullSignature(TMethod method) {
        return this.validatorMessageHelper.fullFunctionSignature((TFunction)method);
    }

    private String fullSignature(TFunction func) {
        return this.validatorMessageHelper.fullFunctionSignature(func);
    }

    private String fullSignature(TVariable tvar) {
        boolean _tripleEquals;
        TypeRef _typeRef = tvar.getTypeRef();
        boolean bl = _tripleEquals = _typeRef == null;
        if (_tripleEquals) {
            return tvar.getName();
        }
        StringConcatenation _builder = new StringConcatenation();
        String _name = tvar.getName();
        _builder.append(_name);
        _builder.append(": ");
        String _typeRefAsString = tvar.getTypeRef().getTypeRefAsString();
        _builder.append(_typeRefAsString);
        return _builder.toString();
    }

    private CharSequence doCodeLink(IdentifiableElement element, String signature) {
        RepoRelativePath rrp = this.repoPathHolder.get(element);
        StringBuilder strb = new StringBuilder();
        if (rrp != null) {
            SourceEntry se = SourceEntryFactory.create(this.repoPathHolder, rrp, element);
            this.appendSourceLink(strb, se, this._html2ADocConverter.passThenMonospace(signature));
        }
        return strb.toString();
    }

    private StringBuilder appendSpecElementPost(StringBuilder strb, SpecIdentifiableElementSection spec, Map<String, SpecSection> map) {
        return this.appendElementPost(strb, spec.getIdentifiableElement(), spec, map);
    }

    private StringBuilder _appendElementPost(StringBuilder strb, IdentifiableElement element, SpecIdentifiableElementSection specRegion, Map<String, SpecSection> specsByKey) {
        if (element instanceof ContainerType) {
            Map<TMember, SortedSet<SpecTestInfo>> testsForInherited = specRegion.getTestInfosForInheritedMember();
            if (testsForInherited == null || testsForInherited.isEmpty()) {
                return strb;
            }
            String typeName = ((ContainerType)element).getName();
            List superTypes = AllSuperTypesCollector.collect((ContainerType)((ContainerType)element));
            Functions.Function1 _function = it -> it.getValue() != null && !((SortedSet)it.getValue()).isEmpty();
            Iterable tests = IterableExtensions.filter(testsForInherited.entrySet(), (Functions.Function1)_function);
            Functions.Function1 _function_1 = it -> this.getFormattedID((Map.Entry<TMember, SortedSet<SpecTestInfo>>)it, superTypes);
            List sortedTests = IterableExtensions.sortBy((Iterable)tests, (Functions.Function1)_function_1);
            for (Map.Entry tmemberSpecs : sortedTests) {
                String shortDescr = this.validatorMessageHelper.shortDescription((TMember)tmemberSpecs.getKey());
                String _shortQualifiedName = this.validatorMessageHelper.shortQualifiedName((TMember)tmemberSpecs.getKey());
                String secSpecLink = String.valueOf(typeName) + "." + _shortQualifiedName;
                String secSpecLinkEsc = SourceEntry.getEscapedAdocAnchorString(secSpecLink);
                String description = this.validatorMessageHelper.description((EObject)((TMember)tmemberSpecs.getKey()).getContainingType());
                String shortQualName = this.validatorMessageHelper.shortQualifiedName((TMember)tmemberSpecs.getKey());
                StringConcatenation _builder = new StringConcatenation();
                _builder.newLine();
                _builder.append("[[gsec:spec_");
                _builder.append(secSpecLinkEsc);
                _builder.append("]]");
                _builder.newLineIfNotEmpty();
                _builder.append("[role=memberdoc]");
                _builder.newLine();
                _builder.append("=== ");
                String _pass = this._html2ADocConverter.pass((CharSequence)StringExtensions.toFirstUpper((String)shortDescr));
                _builder.append(_pass);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                _builder.append("Inherited from");
                _builder.newLine();
                String _pass_1 = this._html2ADocConverter.pass((CharSequence)description);
                _builder.append(_pass_1);
                _builder.newLineIfNotEmpty();
                boolean _isInSpec = this.isInSpec((TMember)tmemberSpecs.getKey(), specsByKey);
                if (_isInSpec) {
                    _builder.append("<<gsec:spec_");
                    String _pass_2 = this._html2ADocConverter.pass((CharSequence)shortQualName);
                    _builder.append(_pass_2);
                    _builder.append(">>");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
                strb.append((CharSequence)_builder);
                this.appendConstraints(strb, (TMember)tmemberSpecs.getKey(), specRegion, (Set)tmemberSpecs.getValue(), false);
            }
        }
        return strb;
    }

    private boolean isInSpec(TMember member, Map<String, SpecSection> specsByKey) {
        if (member == null) {
            return false;
        }
        return specsByKey.containsKey(KeyUtils.getSpecKey(this.repoPathHolder, (IdentifiableElement)member));
    }

    private String getFormattedID(Map.Entry<TMember, SortedSet<SpecTestInfo>> entry, List<TClassifier> superTypes) {
        int index = superTypes.indexOf(entry.getKey().getContainingType());
        String _format = String.format("%04d", index);
        String _name = entry.getKey().getName();
        return String.valueOf(_format) + _name;
    }

    private StringBuilder _appendElementPost(StringBuilder strb, TMember element, SpecIdentifiableElementSection specRegion, Map<String, SpecSection> specsByKey) {
        SortedSet<SpecTestInfo> _testInfosForMember = specRegion.getTestInfosForMember();
        boolean _hasReqId = this.hasReqId(specRegion.getDoclet());
        boolean _not = !_hasReqId;
        this.appendConstraints(strb, element, specRegion, _testInfosForMember, _not);
        return strb;
    }

    private StringBuilder _appendElementPost(StringBuilder strb, TMethod element, SpecIdentifiableElementSection specRegion, Map<String, SpecSection> specsByKey) {
        SortedSet<SpecTestInfo> _testInfosForMember = specRegion.getTestInfosForMember();
        boolean _hasReqId = this.hasReqId(specRegion.getDoclet());
        boolean _not = !_hasReqId;
        this.appendConstraints(strb, (TMember)element, specRegion, _testInfosForMember, _not);
        return strb;
    }

    private StringBuilder _appendElementPost(StringBuilder strb, TFunction element, SpecIdentifiableElementSection specRegion, Map<String, SpecSection> specsByKey) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(specRegion.getTestInfosForType());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.testTitle;
            Map groupdTests = IterableExtensions.groupBy(specRegion.getTestInfosForType(), (Functions.Function1)_function);
            strb.append("==== Semantics\n");
            this.appendApiConstraints(strb, groupdTests);
        } else {
            String reqID = this.getReqId(specRegion.getDoclet());
            boolean _isEmpty = reqID.isEmpty();
            if (_isEmpty) {
                String _passThenMonospace = this._html2ADocConverter.passThenMonospace(element.getName());
                String _plus = "Add tests specifying semantics for " + _passThenMonospace;
                String _pass = this._html2ADocConverter.pass((CharSequence)element.getName());
                String _plus_1 = "test function " + _pass;
                String todoLink = this.getTodoLink(_plus, _plus_1);
                StringConcatenation _builder = new StringConcatenation();
                _builder.newLine();
                _builder.append("==== Semantics");
                _builder.newLine();
                _builder.append(todoLink);
                _builder.newLineIfNotEmpty();
                strb.append((CharSequence)_builder);
            } else {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("% tests see ");
                _builder_1.append(reqID);
                strb.append((CharSequence)_builder_1);
            }
        }
        return strb;
    }

    private StringBuilder _appendElementPost(StringBuilder strb, TVariable element, SpecSection specRegion, Map<String, SpecSection> specsByKey) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(specRegion.getTestInfosForType());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.testTitle;
            Map groupdTests = IterableExtensions.groupBy(specRegion.getTestInfosForType(), (Functions.Function1)_function);
            strb.append("==== Semantics\n");
            this.appendApiConstraints(strb, groupdTests);
        }
        return strb;
    }

    private StringBuilder appendConstraints(StringBuilder strb, TMember element, SpecIdentifiableElementSection specRegion, Set<SpecTestInfo> specTestInfos, boolean addTodo) {
        boolean _elementMayNeedsTest;
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(specTestInfos);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            Functions.Function1 _function = it -> it.testTitle;
            Map groupdTests = IterableExtensions.groupBy(specTestInfos, (Functions.Function1)_function);
            strb.append("==== Semantics\n");
            this.appendApiConstraints(strb, groupdTests);
        } else if (addTodo && (_elementMayNeedsTest = this.elementMayNeedsTest(element, specRegion))) {
            String _passThenMonospace = this._html2ADocConverter.passThenMonospace(element.getMemberAsString());
            String _plus = "Add tests specifying semantics for " + _passThenMonospace;
            String _name = element.getContainingType().getName();
            String _plus_1 = String.valueOf(_name) + ".";
            String _name_1 = element.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            String _pass = this._html2ADocConverter.pass((CharSequence)_plus_2);
            String _plus_3 = "test " + _pass;
            String todoLink = this.getTodoLink(_plus, _plus_3);
            StringConcatenation _builder = new StringConcatenation();
            _builder.newLine();
            _builder.append("==== Semantics");
            _builder.newLine();
            _builder.append(todoLink);
            _builder.newLineIfNotEmpty();
            strb.append((CharSequence)_builder);
        }
        return strb;
    }

    private boolean elementMayNeedsTest(TMember element, SpecIdentifiableElementSection spec) {
        boolean _not;
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(spec.getTestInfosForType());
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            return true;
        }
        if (element instanceof TMethod || element instanceof FieldAccessor) {
            ContainerType _containingType = element.getContainingType();
            if (_containingType instanceof TInterface && element instanceof TMemberWithAccessModifier) {
                boolean _isHasNoBody = ((TMemberWithAccessModifier)element).isHasNoBody();
                return !_isHasNoBody;
            }
            boolean _isAbstract = element.isAbstract();
            return !_isAbstract;
        }
        return false;
    }

    private <T> StringBuilder appendApiConstraints(StringBuilder strb, Map<T, ? extends Collection<SpecTestInfo>> groupdTests) {
        Functions.Function1 _function = it -> it.getKey().toString();
        List _sortBy = IterableExtensions.sortBy(groupdTests.entrySet(), (Functions.Function1)_function);
        for (Map.Entry group : _sortBy) {
            boolean _greaterThan;
            strb.append("\n");
            strb.append(". *");
            String key = group.getKey().toString();
            String keyWithoutPrecedingNumber = this.removePrecedingNumber(key);
            strb.append(this._html2ADocConverter.pass((CharSequence)keyWithoutPrecedingNumber));
            strb.append("* (");
            Iterator iter = ((Collection)group.getValue()).iterator();
            while (iter.hasNext()) {
                SpecTestInfo testSpec = (SpecTestInfo)iter.next();
                strb.append(this.nfgitTest(testSpec));
                boolean _hasNext = iter.hasNext();
                if (!_hasNext) continue;
                strb.append(", \n");
            }
            strb.append(")\n");
            Functions.Function1 _function_1 = it -> it.doclet != null;
            Functions.Function1 _function_2 = it -> it.doclet;
            Iterable doclets = IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)((Iterable)group.getValue()), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
            StringBuilder strbTmp = new StringBuilder();
            this.appendSpecDescriptions(strbTmp, doclets);
            int _length = strbTmp.length();
            boolean bl = _greaterThan = _length > 0;
            if (!_greaterThan) continue;
            strb.append("+\n");
            strb.append("[.generatedApiConstraint]\n");
            strb.append("====\n\n");
            strb.append((CharSequence)strbTmp);
            strb.append("\n====\n");
        }
        return strb;
    }

    private CharSequence nfgitTest(SpecTestInfo testInfo) {
        StringBuilder strb = new StringBuilder();
        if (testInfo.rrp == null) {
            CharSequence _testModuleSpec = testInfo.testModuleSpec();
            String _plus = _testModuleSpec + ".";
            strb.append(this.small(_plus));
            String _testMethodTypeName = testInfo.testMethodTypeName();
            String _plus_1 = String.valueOf(_testMethodTypeName) + ".";
            String _testMethodName = testInfo.testMethodName();
            String _plus_2 = String.valueOf(_plus_1) + _testMethodName;
            strb.append(_plus_2);
        } else {
            SourceEntry pc = SourceEntryFactory.create(testInfo);
            String _xifexpression = null;
            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)testInfo.testCase);
            if (_isNullOrEmpty) {
                _xifexpression = "Test";
            } else {
                String _xblockexpression = null;
                String formattedCase = this.removePrecedingNumber(testInfo.testCase);
                boolean _isNullOrEmpty_1 = StringExtensions.isNullOrEmpty((String)formattedCase);
                if (_isNullOrEmpty_1) {
                    formattedCase = testInfo.testCase;
                }
                _xifexpression = _xblockexpression = this._html2ADocConverter.pass((CharSequence)formattedCase);
            }
            String strCase = _xifexpression;
            StringBuilder strbTmp = new StringBuilder();
            this.appendSourceLink(strbTmp, pc, strCase);
            strb.append(this.small(strbTmp));
        }
        return strb.toString();
    }

    private StringBuilder appendSourceLink(StringBuilder strb, SourceEntry pc, String caption) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("srclnk:++");
        String _pQN = pc.toPQN();
        _builder.append(_pQN);
        _builder.append("++[");
        _builder.append(caption);
        _builder.append("]");
        strb.append((CharSequence)_builder);
        return strb;
    }

    private String getReqId(Doclet doclet) {
        return N4JSDocletParser.TAG_REQID.getValue(doclet, "");
    }

    private boolean hasReqId(Doclet doclet) {
        boolean _isEmpty = this.getReqId(doclet).isEmpty();
        return !_isEmpty;
    }

    private boolean hasTodo(Doclet doclet) {
        boolean _isEmpty = this.getTodo(doclet).isEmpty();
        return !_isEmpty;
    }

    private String getTodo(Doclet doclet) {
        return N4JSDocletParser.TAG_TODO.getValue(doclet, "");
    }

    private String getTodoLink(String todoText, String sideText) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("[TODO");
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)sideText);
        boolean bl = _not = !_isNullOrEmpty;
        if (_not) {
            _builder.append(", title=\"");
            _builder.append(sideText);
            _builder.append("\"");
        }
        _builder.append("]");
        _builder.newLineIfNotEmpty();
        _builder.append("--");
        _builder.newLine();
        _builder.append(todoText);
        _builder.newLineIfNotEmpty();
        _builder.append("--");
        _builder.newLine();
        _builder.newLine();
        String todo = _builder.toString();
        return todo;
    }

    private String getTodoLink(Doclet doclet) {
        return this.getTodoLink(this.getTodo(doclet), "");
    }

    private StringBuilder appendTaskLink(StringBuilder strb, String taskID) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("task:");
        _builder.append(taskID);
        _builder.append("[]");
        strb.append((CharSequence)_builder);
        return strb;
    }

    private String small(CharSequence smallString) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("[.small]#");
        _builder.append((Object)smallString);
        _builder.append("#");
        return _builder.toString();
    }

    private String removePrecedingNumber(String key) {
        int i = 0;
        while (i < key.length()) {
            boolean _not;
            String stringAt = Character.toString(key.charAt(i));
            boolean _contains = "0123456789 ".contains(stringAt);
            boolean bl = _not = !_contains;
            if (_not) {
                return key.substring(i);
            }
            ++i;
        }
        return "";
    }

    private CharSequence processContent(ContentNode node) {
        if (node instanceof InlineTag) {
            return this._processContent((InlineTag)node);
        }
        if (node instanceof Literal) {
            return this._processContent((Literal)node);
        }
        if (node instanceof SimpleTypeReference) {
            return this._processContent((SimpleTypeReference)node);
        }
        if (node instanceof Text) {
            return this._processContent((Text)node);
        }
        if (node instanceof VariableReference) {
            return this._processContent((VariableReference)node);
        }
        if (node != null) {
            return this._processContent(node);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(node).toString());
    }

    private StringBuilder appendElementCodePre(StringBuilder strb, IdentifiableElement element, SpecIdentifiableElementSection spec) {
        if (element instanceof TMethod) {
            return this._appendElementCodePre(strb, (TMethod)element, spec);
        }
        if (element instanceof TFunction) {
            return this._appendElementCodePre(strb, (TFunction)element, spec);
        }
        if (element instanceof TVariable) {
            return this._appendElementCodePre(strb, (TVariable)element, spec);
        }
        if (element instanceof TMember) {
            return this._appendElementCodePre(strb, (TMember)element, spec);
        }
        if (element != null) {
            return this._appendElementCodePre(strb, element, spec);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(strb, element, spec).toString());
    }

    private CharSequence codeLink(EObject method) {
        if (method instanceof TMethod) {
            return this._codeLink((TMethod)method);
        }
        if (method instanceof TFunction) {
            return this._codeLink((TFunction)method);
        }
        if (method instanceof TVariable) {
            return this._codeLink((TVariable)method);
        }
        if (method instanceof TMember) {
            return this._codeLink((TMember)method);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(method).toString());
    }

    private StringBuilder appendElementPost(StringBuilder strb, IdentifiableElement element, SpecSection specRegion, Map<String, SpecSection> specsByKey) {
        if (element instanceof TMethod && specRegion instanceof SpecIdentifiableElementSection) {
            return this._appendElementPost(strb, (TMethod)element, (SpecIdentifiableElementSection)specRegion, specsByKey);
        }
        if (element instanceof TFunction && specRegion instanceof SpecIdentifiableElementSection) {
            return this._appendElementPost(strb, (TFunction)element, (SpecIdentifiableElementSection)specRegion, specsByKey);
        }
        if (element instanceof TVariable && specRegion != null) {
            return this._appendElementPost(strb, (TVariable)element, specRegion, specsByKey);
        }
        if (element instanceof TMember && specRegion instanceof SpecIdentifiableElementSection) {
            return this._appendElementPost(strb, (TMember)element, (SpecIdentifiableElementSection)specRegion, specsByKey);
        }
        if (element != null && specRegion instanceof SpecIdentifiableElementSection) {
            return this._appendElementPost(strb, element, (SpecIdentifiableElementSection)specRegion, specsByKey);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(strb, element, specRegion, specsByKey).toString());
    }
}

