/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.n4js.smith.ui.Activator;
import org.eclipse.n4js.smith.ui.editoroverlay.EditorOverlay;
import org.eclipse.n4js.smith.ui.graph.Graph;
import org.eclipse.n4js.smith.ui.graph.GraphCanvas;
import org.eclipse.n4js.smith.ui.graph.GraphType;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class GraphList
extends Composite {
    protected final List<ListEntry> entries = new ArrayList<ListEntry>();
    protected TableViewer listViewer;
    protected GraphCanvas canvas;

    public GraphList(Composite parent, int style, EditorOverlay editorOverlay) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        SashForm sf = new SashForm((Composite)this, 256);
        sf.setLayout((Layout)new FillLayout());
        this.canvas = new GraphCanvas((Composite)sf, 0, editorOverlay);
        this.listViewer = new TableViewer((Composite)sf, 514);
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setLabelProvider((IBaseLabelProvider)new MyLabelProvider());
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GraphList.this.onSelectionChanged(event);
            }
        });
        this.listViewer.getTable().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u007f') {
                    GraphList.this.removeSelectedGraphs(false);
                }
            }
        });
        sf.setWeights(new int[]{85, 15});
    }

    public GraphCanvas getCanvas() {
        return this.canvas;
    }

    public void addGraph(String label, Graph<?> graph, GraphType graphType, boolean select) {
        this.addEntry(new ListEntry(label, graphType, graph), select);
    }

    public void removeSelectedGraphs(boolean removeAllIfNothingSelected) {
        ISelection sel = this.listViewer.getSelection();
        if (!sel.isEmpty()) {
            this.removeEntries(((IStructuredSelection)sel).toList());
        } else if (removeAllIfNothingSelected) {
            this.removeEntries(new ArrayList<ListEntry>(this.entries));
        }
    }

    protected void addEntry(ListEntry entry, boolean select) {
        if (!this.entries.contains(entry)) {
            this.entries.add(entry);
            this.refreshList();
            if (select) {
                this.listViewer.setSelection((ISelection)new StructuredSelection((Object)entry));
                this.listViewer.reveal((Object)entry);
            }
        }
    }

    protected void removeEntry(ListEntry entry) {
        if (this.entries.remove(entry)) {
            this.refreshList();
            if (entry.graph == this.canvas.getGraph()) {
                this.canvas.clear();
            }
        }
    }

    protected void removeEntries(Collection<?> entries) {
        if (this.entries.removeAll(entries)) {
            this.refreshList();
            if (entries.stream().anyMatch(e -> e instanceof ListEntry && ((ListEntry)e).graph == this.canvas.getGraph())) {
                this.canvas.clear();
            }
        }
    }

    protected void refreshList() {
        this.listViewer.setInput((Object)this.entries.toArray());
    }

    protected ListEntry getSingleSelectedEntry() {
        Object obj;
        IStructuredSelection sel = (IStructuredSelection)this.listViewer.getSelection();
        Object object = obj = sel.size() == 1 ? sel.getFirstElement() : null;
        if (obj instanceof ListEntry) {
            return (ListEntry)obj;
        }
        return null;
    }

    protected void onSelectionChanged(SelectionChangedEvent event) {
        ListEntry selEntry = this.getSingleSelectedEntry();
        if (selEntry != null) {
            this.canvas.setGraph(selEntry.graph);
        } else {
            this.canvas.clear();
        }
    }

    public boolean setFocus() {
        return this.listViewer.getTable().setFocus();
    }

    protected static class ListEntry {
        public final String label;
        public final GraphType type;
        public final Graph<?> graph;

        public ListEntry(String label, GraphType type, Graph<?> graph) {
            this.label = label;
            this.type = type;
            this.graph = graph;
        }
    }

    protected class MyLabelProvider
    extends LabelProvider {
        final Image imageAST;
        final Image imageCFG;
        final Image imageDFG;

        protected MyLabelProvider() {
            this.imageAST = Activator.getInstance().ICON_GRAPH_AST.createImage();
            this.imageCFG = Activator.getInstance().ICON_GRAPH_CF.createImage();
            this.imageDFG = Activator.getInstance().ICON_GRAPH_DF.createImage();
        }

        public String getText(Object element) {
            return ((ListEntry)element).label;
        }

        public Image getImage(Object element) {
            if (((ListEntry)element).type == GraphType.AST) {
                return this.imageAST;
            }
            if (((ListEntry)element).type == GraphType.CFG) {
                return this.imageCFG;
            }
            return null;
        }
    }
}

