/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.ui.resultsview;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.n4js.tester.domain.ID;
import org.eclipse.n4js.tester.domain.TestCase;
import org.eclipse.n4js.tester.domain.TestElement;
import org.eclipse.n4js.tester.domain.TestResult;
import org.eclipse.n4js.tester.domain.TestStatus;
import org.eclipse.n4js.tester.domain.TestSuite;
import org.eclipse.n4js.tester.domain.TestTree;
import org.eclipse.n4js.tester.ui.resultsview.TestStatusCounter;

class ResultNode {
    private final ResultNode parent;
    private final List<ResultNode> children;
    private final TestStatusCounter childrenStatus;
    private final Map<ID, ResultNode> nodeRegistry;
    private final TestElement element;
    private boolean running = false;

    public ResultNode(ResultNode parent, TestElement element) {
        this.parent = parent;
        this.element = element;
        this.children = this.isContainer() ? new ArrayList() : null;
        this.childrenStatus = this.isContainer() ? new TestStatusCounter() : null;
        HashMap hashMap = this.nodeRegistry = this.isRoot() ? new HashMap() : null;
        if (this.isRoot() && this.getId() != null) {
            this.nodeRegistry.put(this.getId(), this);
        }
        if (parent != null) {
            parent.addChild(this);
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isContainer() {
        return !this.isLeaf();
    }

    public boolean isLeaf() {
        return this.element instanceof TestCase;
    }

    public ResultNode getParent() {
        return this.parent;
    }

    public ResultNode getRoot() {
        ResultNode n = this;
        while (n.parent != null) {
            n = n.parent;
        }
        return n;
    }

    public boolean isAncestorOf(ResultNode other) {
        while (other != null) {
            other = other.parent;
            if (this != other) continue;
            return true;
        }
        return false;
    }

    public boolean hasChildren() {
        return this.isContainer() && !this.children.isEmpty();
    }

    public ResultNode[] getChildren() {
        return this.isContainer() ? this.children.toArray(new ResultNode[this.children.size()]) : new ResultNode[]{};
    }

    private void addChild(ResultNode child) {
        if (this.isLeaf()) {
            throw new IllegalStateException("cannot add a child to a leaf node");
        }
        this.children.add(child);
        ID childId = child.getId();
        if (childId != null) {
            this.getRoot().nodeRegistry.put(childId, child);
        }
    }

    public ResultNode findById(ID id) {
        return id != null ? this.getRoot().nodeRegistry.get(id) : null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void startRunning() {
        this.running = true;
    }

    public void stopRunning() {
        this.running = false;
    }

    public TestElement getElement() {
        return this.element;
    }

    public TestTree getTestTree() {
        if (this.element instanceof TestTree) {
            return (TestTree)this.element;
        }
        return null;
    }

    public TestSuite getTestSuite() {
        if (this.element instanceof TestSuite) {
            return (TestSuite)this.element;
        }
        return null;
    }

    public TestCase getTestCase() {
        if (this.element instanceof TestCase) {
            return (TestCase)this.element;
        }
        return null;
    }

    public void updateResult(TestResult newResult) {
        TestCase tc = this.getTestCase();
        if (tc != null) {
            tc.setResult(newResult);
            this.refreshCachedStatus();
        }
    }

    public ID getId() {
        if (this.element instanceof TestTree) {
            return ((TestTree)this.element).getSessionId();
        }
        if (this.element instanceof TestCase) {
            return ((TestCase)this.element).getId();
        }
        return null;
    }

    public TestStatus getStatus() {
        TestResult tr;
        TestCase tc = this.getTestCase();
        if (tc != null && (tr = tc.getResult()) != null) {
            return tr.getTestStatus();
        }
        return null;
    }

    public long getElapsedTime() {
        TestResult tr;
        TestCase tc = this.getTestCase();
        if (tc != null && (tr = tc.getResult()) != null) {
            return tr.getElapsedTime();
        }
        return 0L;
    }

    public TestStatusCounter getChildrenStatus() {
        return this.childrenStatus;
    }

    protected void refreshCachedStatus() {
        if (!this.isLeaf()) {
            this.childrenStatus.clear();
            for (ResultNode child : this.children) {
                if (child.isLeaf()) {
                    TestStatus childStatus = child.getStatus();
                    if (childStatus == null) continue;
                    this.childrenStatus.increment(childStatus);
                    continue;
                }
                this.childrenStatus.increment(child.childrenStatus);
            }
        }
        if (this.parent != null) {
            this.parent.refreshCachedStatus();
        }
    }

    public int countTestCases() {
        return (int)this.stream().filter(node -> node.element instanceof TestCase).count();
    }

    public Stream<ResultNode> stream() {
        if (this.isContainer()) {
            return Stream.concat(Stream.of(this), this.children.stream().flatMap(child -> child.stream()));
        }
        return Stream.of(this);
    }

    public List<TestCase> getFailed() {
        ArrayList<TestCase> failed = new ArrayList<TestCase>();
        this.collectFailed(failed);
        return failed;
    }

    private void collectFailed(List<TestCase> failed) {
        if (this.getTestCase() != null) {
            TestStatus status;
            TestResult result = this.getTestCase().getResult();
            if (result != null && (status = result.getTestStatus()) != null && status.isFailedOrError()) {
                failed.add(this.getTestCase());
            }
        } else if (!this.isLeaf()) {
            ResultNode[] resultNodeArray = this.getChildren();
            int n = resultNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ResultNode node = resultNodeArray[n2];
                failed.addAll(node.getFailed());
                ++n2;
            }
        }
    }
}

