/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.builder.resourceloader;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.builder.resourceloader.AbstractResourceLoader;
import org.eclipse.xtext.builder.resourceloader.IResourceLoader;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class SerialResourceLoader
extends AbstractResourceLoader {
    public SerialResourceLoader(IResourceSetProvider resourceSetProvider, IResourceLoader.Sorter sorter) {
        super(resourceSetProvider, sorter);
    }

    @Override
    public IResourceLoader.LoadOperation create(final ResourceSet parent, IProject project) {
        final LinkedList queue = Lists.newLinkedList();
        return new AbstractResourceLoader.CheckedLoadOperation(this, new IResourceLoader.LoadOperation(){

            @Override
            public IResourceLoader.LoadResult next() {
                URI uri = (URI)queue.poll();
                try {
                    Resource resource = parent.getResource(uri, true);
                    return new IResourceLoader.LoadResult(resource, uri);
                }
                catch (WrappedException e) {
                    throw new IResourceLoader.LoadOperationException(uri, (Exception)e.getCause());
                }
            }

            @Override
            public boolean hasNext() {
                return !queue.isEmpty();
            }

            @Override
            public Collection<URI> cancel() {
                return queue;
            }

            @Override
            public void load(Collection<URI> uris) {
                queue.addAll(SerialResourceLoader.this.getSorter().sort(uris));
            }
        });
    }
}

