/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.IProjectSetSerializer;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.Team;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.internal.ui.TeamCapabilityHelper;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.UIProjectSetSerializationContext;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class ProjectSetImporter {
    public static IProject[] importProjectSetFromString(String psfContents, String filename, Shell shell, IProgressMonitor monitor) throws InvocationTargetException {
        XMLMemento xmlMemento = ProjectSetImporter.stringToXMLMemento(psfContents);
        return ProjectSetImporter.importProjectSet(xmlMemento, filename, shell, monitor);
    }

    public static IProject[] importProjectSet(String filename, Shell shell, IProgressMonitor monitor) throws InvocationTargetException {
        XMLMemento xmlMemento = ProjectSetImporter.filenameToXMLMemento(filename);
        return ProjectSetImporter.importProjectSet(xmlMemento, filename, shell, monitor);
    }

    private static IProject[] importProjectSet(XMLMemento xmlMemento, String filename, Shell shell, IProgressMonitor monitor) throws InvocationTargetException {
        try {
            String version = xmlMemento.getString("version");
            ArrayList<IProject> newProjects = new ArrayList<IProject>();
            if (version.equals("1.0")) {
                IProject[] projects;
                IProjectSetSerializer serializer = Team.getProjectSetSerializer((String)"versionOneSerializer");
                if (serializer != null && (projects = serializer.addToWorkspace(new String[0], filename, (Object)shell, monitor)) != null) {
                    newProjects.addAll(Arrays.asList(projects));
                }
            } else {
                UIProjectSetSerializationContext context = new UIProjectSetSerializationContext(shell, filename);
                ArrayList<TeamException> errors = new ArrayList<TeamException>();
                IMemento[] providers = xmlMemento.getChildren("provider");
                int i = 0;
                while (i < providers.length) {
                    ArrayList<String> referenceStrings = new ArrayList<String>();
                    IMemento[] projects = providers[i].getChildren("project");
                    int j = 0;
                    while (j < projects.length) {
                        referenceStrings.add(projects[j].getString("reference"));
                        ++j;
                    }
                    try {
                        IProject[] allProjects;
                        String id = providers[i].getString("id");
                        TeamCapabilityHelper.getInstance().processRepositoryId(id, PlatformUI.getWorkbench().getActivitySupport());
                        RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                        if (providerType == null) {
                            providerType = TeamPlugin.getAliasType((String)id);
                        }
                        if (providerType == null) {
                            throw new TeamException((IStatus)new Status(4, "org.eclipse.team.ui", 0, NLS.bind((String)TeamUIMessages.ProjectSetImportWizard_0, (Object[])new String[]{id}), null));
                        }
                        ProjectSetCapability serializer = providerType.getProjectSetCapability();
                        ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                        if (serializer != null && (allProjects = serializer.addToWorkspace(referenceStrings.toArray(new String[referenceStrings.size()]), (ProjectSetSerializationContext)context, monitor)) != null) {
                            newProjects.addAll(Arrays.asList(allProjects));
                        }
                    }
                    catch (TeamException e) {
                        errors.add(e);
                    }
                    ++i;
                }
                if (!errors.isEmpty()) {
                    TeamException[] exceptions = errors.toArray(new TeamException[errors.size()]);
                    IStatus[] status = new IStatus[exceptions.length];
                    int i2 = 0;
                    while (i2 < exceptions.length) {
                        status[i2] = exceptions[i2].getStatus();
                        ++i2;
                    }
                    throw new TeamException((IStatus)new MultiStatus("org.eclipse.team.ui", 0, status, TeamUIMessages.ProjectSetImportWizard_1, null));
                }
                IMemento[] sets = xmlMemento.getChildren("workingSets");
                IWorkingSetManager wsManager = TeamUIPlugin.getPlugin().getWorkbench().getWorkingSetManager();
                boolean replaceAll = false;
                boolean mergeAll = false;
                boolean skipAll = false;
                int i3 = 0;
                while (i3 < sets.length) {
                    IWorkingSet newWs = wsManager.createWorkingSet(sets[i3]);
                    if (newWs != null) {
                        IWorkingSet oldWs = wsManager.getWorkingSet(newWs.getName());
                        if (oldWs == null) {
                            wsManager.addWorkingSet(newWs);
                        } else if (replaceAll) {
                            ProjectSetImporter.replaceWorkingSet(wsManager, newWs, oldWs);
                        } else if (mergeAll) {
                            ProjectSetImporter.mergeWorkingSets(newWs, oldWs);
                        } else if (!skipAll) {
                            String title = TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_title;
                            String msg = NLS.bind((String)TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_message, (Object)newWs.getName());
                            String[] buttons = new String[]{TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_replace, TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_merge, TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_skip, IDialogConstants.CANCEL_LABEL};
                            AdviceDialog dialog = new AdviceDialog(shell, title, null, msg, 3, buttons, 0);
                            shell.getDisplay().syncExec(() -> {
                                int n = dialog.open();
                            });
                            switch (dialog.getReturnCode()) {
                                case 0: {
                                    ProjectSetImporter.replaceWorkingSet(wsManager, newWs, oldWs);
                                    replaceAll = dialog.applyToAll;
                                    break;
                                }
                                case 1: {
                                    ProjectSetImporter.mergeWorkingSets(newWs, oldWs);
                                    mergeAll = dialog.applyToAll;
                                    break;
                                }
                                case 2: {
                                    skipAll = dialog.applyToAll;
                                    break;
                                }
                                default: {
                                    throw new OperationCanceledException();
                                }
                            }
                        }
                    }
                    ++i3;
                }
            }
            return newProjects.toArray(new IProject[newProjects.size()]);
        }
        catch (TeamException e) {
            throw new InvocationTargetException(e);
        }
    }

    private static XMLMemento filenameToXMLMemento(String filename) throws InvocationTargetException {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(filename), StandardCharsets.UTF_8);
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)reader);
            return xMLMemento;
        }
        catch (FileNotFoundException e) {
            throw new InvocationTargetException(e);
        }
        catch (WorkbenchException e) {
            throw new InvocationTargetException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
        }
    }

    private static XMLMemento stringToXMLMemento(String stringContents) throws InvocationTargetException {
        try (StringReader reader = null;){
            reader = new StringReader(stringContents);
            XMLMemento xMLMemento = XMLMemento.createReadRoot((Reader)reader);
            return xMLMemento;
        }
    }

    public static boolean isValidProjectSetFile(String filename) {
        try {
            return ProjectSetImporter.filenameToXMLMemento(filename).getString("version") != null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    public static boolean isValidProjectSetString(String psfContent) {
        if (psfContent == null) {
            return false;
        }
        try {
            return ProjectSetImporter.stringToXMLMemento(psfContent).getString("version") != null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
    }

    private static void mergeWorkingSets(IWorkingSet newWs, IWorkingSet oldWs) {
        IAdaptable[] oldElements = oldWs.getElements();
        IAdaptable[] newElements = newWs.getElements();
        HashSet<IAdaptable> combinedElements = new HashSet<IAdaptable>();
        combinedElements.addAll(Arrays.asList(oldElements));
        combinedElements.addAll(Arrays.asList(newElements));
        oldWs.setElements(combinedElements.toArray(new IAdaptable[0]));
    }

    private static void replaceWorkingSet(IWorkingSetManager wsManager, IWorkingSet newWs, IWorkingSet oldWs) {
        if (oldWs != null) {
            wsManager.removeWorkingSet(oldWs);
        }
        wsManager.addWorkingSet(newWs);
    }

    private static class AdviceDialog
    extends MessageDialog {
        boolean applyToAll;

        public AdviceDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex) {
            super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        }

        protected Control createCustomArea(Composite parent) {
            final Button checkBox = new Button(parent, 32);
            checkBox.setText(TeamUIMessages.ImportProjectSetDialog_duplicatedWorkingSet_applyToAll);
            checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    applyToAll = checkBox.getSelection();
                }
            });
            return checkBox;
        }
    }
}

