/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.model;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.xpect.XjmClass;
import org.eclipse.xpect.model.XjmElementImpl;
import org.eclipse.xtext.common.types.JvmDeclaredType;

public class XjmElementImplCustom
extends XjmElementImpl {
    private void collectImports(XjmClass ctx, List<String> result, Set<XjmClass> visited) {
        if (!visited.add(ctx)) {
            return;
        }
        JvmDeclaredType jvmClass = ctx.getJvmClass();
        if (jvmClass != null) {
            if (jvmClass.eIsProxy()) {
                result.add("Proxy: " + ((InternalEObject)jvmClass).eProxyURI());
            } else {
                result.add(jvmClass.getSimpleName());
            }
        }
        for (XjmClass imp : ctx.getImports()) {
            this.collectImports(imp, result, visited);
        }
    }

    public String getImportedContributions() {
        ArrayList result = Lists.newArrayList();
        HashSet visited = Sets.newHashSet();
        for (XjmClass imp : this.getImports()) {
            this.collectImports(imp, result, visited);
        }
        return Joiner.on((String)", ").join((Iterable)result);
    }
}

