/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectModel.IExternalPackageManager;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;

@Singleton
public class FileBasedExternalPackageManager
implements IExternalPackageManager {
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private ExternalLibraryHelper externalLibraryHelper;

    @Override
    public boolean isN4ProjectRoot(URI rootLocation) {
        if (rootLocation != null && rootLocation.isFile()) {
            File projectRoot = new File(rootLocation.toFileString());
            return this.externalLibraryHelper.isExternalProjectDirectory(projectRoot);
        }
        return false;
    }

    @Override
    public ProjectDescription loadProjectDescriptionFromProjectRoot(URI rootLocation) {
        File projectRoot;
        if (rootLocation != null && rootLocation.isFile() && (projectRoot = new File(rootLocation.toFileString())).exists() && projectRoot.isDirectory()) {
            return this.projectDescriptionLoader.loadProjectDescriptionAtLocation(rootLocation);
        }
        return null;
    }
}

