/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.postprocessing;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.ArrayElement;
import org.eclipse.n4js.n4JS.ArrayLiteral;
import org.eclipse.n4js.n4JS.ArrayPadding;
import org.eclipse.n4js.n4JS.DestructureUtils;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.postprocessing.ASTMetaInfoCache;
import org.eclipse.n4js.postprocessing.AbstractPolyProcessor;
import org.eclipse.n4js.postprocessing.PolyProcessor;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TypableElement;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.DestructureHelper;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
class PolyProcessor_ArrayLiteral
extends AbstractPolyProcessor {
    @Inject
    private PolyProcessor polyProcessor;
    @Inject
    private N4JSTypeSystem ts;
    @Inject
    private TypeSystemHelper tsh;
    @Inject
    private DestructureHelper destructureHelper;

    PolyProcessor_ArrayLiteral() {
    }

    TypeRef processArrayLiteral(RuleEnvironment G, ArrayLiteral arrLit, TypeRef expectedTypeRef, InferenceContext infCtx, ASTMetaInfoCache cache) {
        boolean _isEmpty;
        boolean haveUsableExpectedType;
        int numOfElems = arrLit.getElements().size();
        List<TypeRef> expectedElemTypeRefs = this.getExpectedElemTypeRefs(G, expectedTypeRef);
        boolean isValueToBeDestructured = DestructureUtils.isArrayOrObjectLiteralBeingDestructured((EObject)arrLit);
        if (isValueToBeDestructured) {
            while (expectedElemTypeRefs.size() < numOfElems) {
                expectedElemTypeRefs.add((TypeRef)RuleEnvironmentExtensions.anyTypeRef(G));
            }
        }
        boolean bl = haveUsableExpectedType = !(_isEmpty = expectedElemTypeRefs.isEmpty());
        if (!haveUsableExpectedType && !TypeUtils.isInferenceVariable((TypeRef)expectedTypeRef)) {
            ArrayList elemTypeRefs = CollectionLiterals.newArrayList();
            Functions.Function1 _function = it -> {
                Expression _expression = it.getExpression();
                return _expression != null;
            };
            Iterable nonNullElems = IterableExtensions.filter((Iterable)arrLit.getElements(), (Functions.Function1)_function);
            for (ArrayElement arrElem : nonNullElems) {
                TypeRef _processExpr = this.polyProcessor.processExpr(G, arrElem.getExpression(), null, infCtx, cache);
                elemTypeRefs.add(_processExpr);
            }
            Consumer<Optional<Map<InferenceVariable, TypeRef>>> _function_1 = solution -> this.handleOnSolvedPerformanceTweak(G, cache, arrLit, expectedElemTypeRefs);
            infCtx.onSolved(_function_1);
            Object _xifexpression = null;
            boolean _isEmpty_1 = elemTypeRefs.isEmpty();
            boolean _not = !_isEmpty_1;
            _xifexpression = _not ? this.tsh.createUnionType(G, (TypeRef[])Conversions.unwrapArray((Object)elemTypeRefs, TypeRef.class)) : RuleEnvironmentExtensions.anyTypeRef(G);
            ParameterizedTypeRef unionOfElemTypes = _xifexpression;
            return RuleEnvironmentExtensions.arrayTypeRef(G, new TypeArgument[]{unionOfElemTypes});
        }
        int resultLen = this.getResultLength(arrLit, expectedElemTypeRefs);
        InferenceVariable[] resultInfVars = infCtx.newInferenceVariables(resultLen);
        this.processElements(G, cache, infCtx, arrLit, resultLen, (TypeVariable[])resultInfVars);
        TypeRef resultTypeRef = this.getResultTypeRef(G, resultLen, (TypeVariable[])resultInfVars);
        Consumer<Optional<Map<InferenceVariable, TypeRef>>> _function_2 = solution -> this.handleOnSolved(G, cache, arrLit, expectedElemTypeRefs, resultTypeRef, (Optional<Map<InferenceVariable, TypeRef>>)solution);
        infCtx.onSolved(_function_2);
        return resultTypeRef;
    }

    private List<TypeRef> getExpectedElemTypeRefs(RuleEnvironment G, TypeRef expectedTypeRef) {
        if (expectedTypeRef != null) {
            Iterable<TypeRef> extractedTypeRefs = this.destructureHelper.extractIterableElementTypesUBs(G, expectedTypeRef);
            return IterableExtensions.toList(extractedTypeRefs);
        }
        return CollectionLiterals.newArrayList();
    }

    private TypeRef buildFallbackTypeForArrayLiteral(boolean isIterableN, int resultLen, List<TypeRef> elemTypeRefs, List<TypeRef> expectedElemTypeRefs, RuleEnvironment G) {
        if (isIterableN) {
            boolean _greaterThan;
            TypeRef[] typeArgs = new TypeRef[resultLen];
            int i = 0;
            while (i < resultLen) {
                boolean isLastElem = i == resultLen - 1;
                TypeRef typeRef = null;
                if (isLastElem && elemTypeRefs.size() > resultLen) {
                    ArrayList allRemainingElementTypeRefs = CollectionLiterals.newArrayList();
                    TypeRef currExpectedElemTypeRef = expectedElemTypeRefs.get(i);
                    boolean allMatch = true;
                    int j = i;
                    while (j < elemTypeRefs.size()) {
                        boolean actualIsSubtypeOfExpected;
                        TypeRef currElementTypeRef = elemTypeRefs.get(j);
                        allRemainingElementTypeRefs.add(currElementTypeRef);
                        if (allMatch && !(actualIsSubtypeOfExpected = this.ts.subtypeSucceeded(G, (TypeArgument)currElementTypeRef, (TypeArgument)currExpectedElemTypeRef))) {
                            allMatch = false;
                        }
                        ++j;
                    }
                    typeRef = allMatch ? currExpectedElemTypeRef : this.tsh.createUnionType(G, (TypeRef[])Conversions.unwrapArray((Object)allRemainingElementTypeRefs, TypeRef.class));
                } else {
                    TypeRef currExpectedElemTypeRef_1;
                    TypeRef currElemTypeRef = elemTypeRefs.get(i);
                    boolean actualIsSubtypeOfExpected = this.ts.subtypeSucceeded(G, (TypeArgument)currElemTypeRef, (TypeArgument)(currExpectedElemTypeRef_1 = expectedElemTypeRefs.get(i)));
                    typeRef = actualIsSubtypeOfExpected ? currExpectedElemTypeRef_1 : currElemTypeRef;
                }
                typeArgs[i] = typeRef;
                ++i;
            }
            int _size = elemTypeRefs.size();
            boolean bl = _greaterThan = _size > resultLen;
            if (_greaterThan) {
                TypeRef[] remaining = Arrays.copyOfRange((TypeRef[])Conversions.unwrapArray(elemTypeRefs, TypeRef.class), resultLen - 1, elemTypeRefs.size());
                typeArgs[resultLen - 1] = this.tsh.createUnionType(G, remaining);
            }
            return RuleEnvironmentExtensions.iterableNTypeRef(G, resultLen, (TypeArgument[])typeArgs);
        }
        Object _xifexpression = null;
        boolean _isEmpty = elemTypeRefs.isEmpty();
        boolean _not = !_isEmpty;
        _xifexpression = _not ? this.tsh.createUnionType(G, (TypeRef[])Conversions.unwrapArray(elemTypeRefs, TypeRef.class)) : RuleEnvironmentExtensions.anyTypeRef(G);
        ParameterizedTypeRef unionOfElemTypes = _xifexpression;
        return RuleEnvironmentExtensions.arrayTypeRef(G, new TypeArgument[]{unionOfElemTypes});
    }

    private int getResultLength(ArrayLiteral arrLit, List<TypeRef> expectedElemTypeRefs) {
        int numOfElems = arrLit.getElements().size();
        int lenA = Math.min(expectedElemTypeRefs.size(), numOfElems);
        int lenB = Math.min(lenA, 9);
        int resultLen = Math.max(lenB, 1);
        return resultLen;
    }

    private TypeRef getResultTypeRef(RuleEnvironment G, int resultLen, TypeVariable[] resultInfVars) {
        boolean isIterableN = resultLen >= 2;
        Object _xifexpression = null;
        _xifexpression = isIterableN ? RuleEnvironmentExtensions.iterableNType(G, resultLen) : RuleEnvironmentExtensions.arrayType(G);
        TObjectPrototype declaredType = _xifexpression;
        Functions.Function1 _function = it -> TypeUtils.createTypeRef((Type)it, (TypeArgument[])new TypeArgument[0]);
        List typeArgs = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)resultInfVars)), (Functions.Function1)_function);
        ParameterizedTypeRef resultTypeRef = TypeUtils.createTypeRef((Type)declaredType, (TypeArgument[])((TypeArgument[])Conversions.unwrapArray((Object)typeArgs, TypeArgument.class)));
        return resultTypeRef;
    }

    private void processElements(RuleEnvironment G, ASTMetaInfoCache cache, InferenceContext infCtx, ArrayLiteral arrLit, int resultLen, TypeVariable[] resultInfVars) {
        int numOfElems = arrLit.getElements().size();
        int idxElem = 0;
        while (idxElem < numOfElems) {
            boolean _tripleEquals;
            ArrayElement currElem = (ArrayElement)arrLit.getElements().get(idxElem);
            Expression _expression = null;
            if (currElem != null) {
                _expression = currElem.getExpression();
            }
            boolean bl = _tripleEquals = _expression == null;
            if (!_tripleEquals) {
                int idxResult = Math.min(idxElem, resultLen - 1);
                TypeVariable currResultInfVar = resultInfVars[idxResult];
                TypeRef currElemTypeRef = this.polyProcessor.processExpr(G, currElem.getExpression(), (TypeRef)TypeUtils.createTypeRef((Type)currResultInfVar, (TypeArgument[])new TypeArgument[0]), infCtx, cache);
                infCtx.addConstraint((TypeArgument)currElemTypeRef, (TypeArgument)TypeUtils.createTypeRef((Type)currResultInfVar, (TypeArgument[])new TypeArgument[0]), Variance.CO);
            }
            ++idxElem;
        }
    }

    private void handleOnSolvedPerformanceTweak(RuleEnvironment G, ASTMetaInfoCache cache, ArrayLiteral arrLit, List<TypeRef> expectedElemTypeRefs) {
        List<TypeRef> betterElemTypeRefs = this.storeTypesOfArrayElements(G, cache, arrLit);
        TypeRef fallbackTypeRef = this.buildFallbackTypeForArrayLiteral(false, 1, betterElemTypeRefs, expectedElemTypeRefs, G);
        cache.storeType((TypableElement)arrLit, fallbackTypeRef);
    }

    private void handleOnSolved(RuleEnvironment G, ASTMetaInfoCache cache, ArrayLiteral arrLit, List<TypeRef> expectedElemTypeRefs, TypeRef resultTypeRef, Optional<Map<InferenceVariable, TypeRef>> solution) {
        int resultLen = this.getResultLength(arrLit, expectedElemTypeRefs);
        boolean isIterableN = resultLen >= 2;
        boolean _isPresent = solution.isPresent();
        if (_isPresent) {
            TypeRef typeRef = this.applySolution(resultTypeRef, G, (Map)solution.get());
            cache.storeType((TypableElement)arrLit, typeRef);
        } else {
            Functions.Function1 _function = it -> {
                Object _xifexpression = null;
                Expression _expression = it.getExpression();
                boolean _tripleNotEquals = _expression != null;
                _xifexpression = _tripleNotEquals ? this.getFinalResultTypeOfNestedPolyExpression(it.getExpression()) : RuleEnvironmentExtensions.anyTypeRef(G);
                return _xifexpression;
            };
            List betterElemTypeRefs = ListExtensions.map((List)arrLit.getElements(), (Functions.Function1)_function);
            TypeRef typeRef_1 = this.buildFallbackTypeForArrayLiteral(isIterableN, resultLen, betterElemTypeRefs, expectedElemTypeRefs, G);
            cache.storeType((TypableElement)arrLit, typeRef_1);
        }
        this.storeTypesOfArrayElements(G, cache, arrLit);
    }

    private List<TypeRef> storeTypesOfArrayElements(RuleEnvironment G, ASTMetaInfoCache cache, ArrayLiteral arrLit) {
        ArrayList storedElemTypeRefs = CollectionLiterals.newArrayList();
        EList _elements = arrLit.getElements();
        for (ArrayElement arrElem : _elements) {
            TypeRef exprType;
            if (arrElem instanceof ArrayPadding) {
                cache.storeType((TypableElement)arrElem, (TypeRef)RuleEnvironmentExtensions.undefinedTypeRef(G));
                continue;
            }
            Expression _expression = null;
            if (arrElem != null) {
                _expression = arrElem.getExpression();
            }
            Expression expr = _expression;
            TypeRef _xifexpression = null;
            if (expr != null) {
                _xifexpression = this.getFinalResultTypeOfNestedPolyExpression(expr);
            }
            if ((exprType = _xifexpression) != null) {
                cache.storeType((TypableElement)arrElem, exprType);
                storedElemTypeRefs.add(exprType);
                continue;
            }
            cache.storeType((TypableElement)arrElem, (TypeRef)TypeRefsFactory.eINSTANCE.createUnknownTypeRef());
        }
        return storedElemTypeRefs;
    }
}

