/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.factories.CFEMapper;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.ControlFlowable;
import org.eclipse.n4js.flowgraphs.model.JumpToken;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public abstract class Node
implements ControlFlowable {
    private static int ID_COUNTER = 0;
    public final int id = ID_COUNTER++;
    private final ControlFlowElement cfElem;
    public final String name;
    public final int astPosition;
    public final Map<Node, EdgeDescription> internalPred = new HashMap<Node, EdgeDescription>();
    public final Map<Node, EdgeDescription> internalSucc = new HashMap<Node, EdgeDescription>();
    public final TreeSet<ControlFlowEdge> pred = new TreeSet();
    public final TreeSet<ControlFlowEdge> succ = new TreeSet();
    public final Set<JumpToken> jumpToken = new HashSet<JumpToken>();
    public final List<CatchToken> catchToken = new ArrayList<CatchToken>();
    public final List<EffectInfo> effectInfos = new ArrayList<EffectInfo>();
    private Reachability reachability = Reachability.Unknown;
    private boolean isVisited = false;

    public Node(String name, int astPosition, ControlFlowElement cfElem) {
        this.name = name;
        this.astPosition = astPosition;
        this.cfElem = cfElem;
    }

    public abstract ControlFlowElement getDelegatedControlFlowElement();

    public abstract ControlFlowElement getRepresentedControlFlowElement();

    public void addInternalPrecessor(Node node) {
        this.addInternalPredecessor(node, ControlFlowType.Successor);
    }

    public void addInternalSuccessor(Node node) {
        this.addInternalSuccessor(node, ControlFlowType.Successor);
    }

    public void addInternalPredecessor(Node node, ControlFlowType cfType) {
        EdgeDescription sed = new EdgeDescription(node, cfType);
        this.internalPred.put(sed.node, sed);
    }

    public void removeInternalPredecessor(Node node) {
        this.internalPred.remove(node);
    }

    public void addInternalSuccessor(Node node, ControlFlowType cfType) {
        Preconditions.checkState((node != this ? 1 : 0) != 0, (Object)"Self loops are not allowed");
        EdgeDescription sed = new EdgeDescription(node, cfType);
        this.internalSucc.put(sed.node, sed);
    }

    public void removeInternalSuccessor(Node node) {
        this.internalSucc.remove(node);
    }

    void addSuccessor(ControlFlowEdge cfEdge) {
        boolean addSucceeded = this.succ.add(cfEdge);
        Preconditions.checkState((boolean)addSucceeded, (Object)"Adding an edge should always be successful");
    }

    void addPredecessor(ControlFlowEdge cfEdge) {
        boolean addSucceeded = this.pred.add(cfEdge);
        Preconditions.checkState((boolean)addSucceeded, (Object)"Adding an edge should always be successful");
    }

    public Set<Node> getInternalPredecessors() {
        return this.internalPred.keySet();
    }

    public Set<Node> getInternalSuccessors() {
        return this.internalSucc.keySet();
    }

    public ControlFlowType getInternalSuccessorControlFlowType(Node endNode) {
        if (this.internalSucc.containsKey(endNode)) {
            EdgeDescription sed = this.internalSucc.get(endNode);
            return sed.cfType;
        }
        return null;
    }

    public Set<ControlFlowEdge> getSuccessorEdges() {
        return this.succ;
    }

    public Set<ControlFlowEdge> getPredecessorEdges() {
        return this.pred;
    }

    public String getName() {
        return this.name;
    }

    public void addJumpToken(JumpToken jt) {
        this.jumpToken.add(jt);
    }

    public void addCatchToken(CatchToken ct) {
        this.catchToken.add(ct);
    }

    public void addEffectInfo(EffectInfo ei) {
        if (ei != null) {
            this.effectInfos.add(ei);
        }
    }

    public boolean isJump() {
        return !this.jumpToken.isEmpty();
    }

    public void setUnreachable() {
        this.reachability = Reachability.Unreachable;
        this.isVisited = true;
    }

    public void setReachable() {
        this.reachability = Reachability.Reachable;
        this.isVisited = true;
    }

    public boolean isVisited() {
        return this.isVisited;
    }

    public boolean isUnreachable() {
        return this.reachability == Reachability.Unreachable;
    }

    public boolean isReachable() {
        return this.reachability == Reachability.Reachable;
    }

    @Override
    public ControlFlowElement getControlFlowElement() {
        return CFEMapper.map(this.cfElem);
    }

    @Override
    public Node getEntry() {
        return this;
    }

    @Override
    public Node getExit() {
        return this;
    }

    public String toString() {
        return this.getName();
    }

    public String getExtendedString() {
        String s = "";
        s = String.valueOf(s) + "[" + FGUtils.getSourceText((EObject)this.getControlFlowElement()) + "]";
        s = String.valueOf(s) + "(" + this.getName() + ") ";
        return s;
    }

    private class EdgeDescription {
        final ControlFlowType cfType;
        final Node node;

        EdgeDescription(Node node2, ControlFlowType cfType) {
            this.node = node2;
            this.cfType = cfType;
        }
    }

    private static enum Reachability {
        Unknown,
        Reachable,
        Unreachable;

    }
}

