/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.preferences.external;

import java.util.function.BiFunction;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.n4js.ui.utils.UIUtils;
import org.eclipse.n4js.utils.StatusHelper;
import org.eclipse.n4js.utils.StatusUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

public class CleanAllNpmsButtonListener
extends SelectionAdapter {
    private final StatusHelper statusHelper;
    private final BiFunction<IProgressMonitor, MultiStatus, IStatus> action;

    CleanAllNpmsButtonListener(BiFunction<IProgressMonitor, MultiStatus, IStatus> action, StatusHelper statusHelper) {
        this.action = action;
        this.statusHelper = statusHelper;
    }

    public void widgetSelected(SelectionEvent e) {
        block10: {
            MultiStatus multistatus = this.statusHelper.createMultiStatus("Clean all npms.");
            try {
                new ProgressMonitorDialog(UIUtils.getShell()).run(true, true, monitor -> multistatus.merge(this.action.apply(monitor, multistatus)));
            }
            catch (InterruptedException | OperationCanceledException throwable) {
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Clean Failed", (String)descr, (IStatus)multistatus);
                    });
                }
                break block10;
            }
            catch (Exception exc) {
                try {
                    String msg = "Error while cleaning node_modules.";
                    Throwable causingExc = exc.getCause() == null ? exc : exc.getCause();
                    multistatus.merge(this.statusHelper.createError(msg, causingExc));
                }
                catch (Throwable throwable) {
                    if (!multistatus.isOK()) {
                        N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                        UIUtils.getDisplay().asyncExec(() -> {
                            String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                            ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Clean Failed", (String)descr, (IStatus)multistatus);
                        });
                    }
                    throw throwable;
                }
                if (!multistatus.isOK()) {
                    N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                    UIUtils.getDisplay().asyncExec(() -> {
                        String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                        ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Clean Failed", (String)descr, (IStatus)multistatus);
                    });
                }
                break block10;
            }
            if (!multistatus.isOK()) {
                N4JSActivator.getInstance().getLog().log((IStatus)multistatus);
                UIUtils.getDisplay().asyncExec(() -> {
                    String descr = StatusUtils.getErrorMessage((IStatus)multistatus, (boolean)true);
                    ErrorDialog.openError((Shell)UIUtils.getShell(), (String)"NPM Clean Failed", (String)descr, (IStatus)multistatus);
                });
            }
        }
    }
}

