/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.viewer;

import java.util.List;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.n4js.ui.viewer.ColumnViewerBuilder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class TableViewerBuilder
extends ColumnViewerBuilder<TableViewer, IStructuredContentProvider> {
    public TableViewerBuilder(List<String> columnLabels) {
        super(columnLabels, ArrayContentProvider.getInstance());
    }

    @Override
    protected TableViewer createViewer(Composite parent, AbstractColumnLayout columnLayout, int style) {
        TableViewer viewer = new TableViewer(parent, style);
        Table table = viewer.getTable();
        table.setLinesVisible(this.linesVisible);
        table.setHeaderVisible(this.headerVisible);
        int columnIndex = 0;
        for (String columnLabel : this.columnLabels) {
            TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
            TableColumn column = viewerColumn.getColumn();
            columnLayout.setColumnData((Widget)column, this.createColumnLayoutData(columnIndex));
            column.setText(columnLabel);
            column.setMoveable(this.moveable);
            ++columnIndex;
        }
        return viewer;
    }

    @Override
    protected AbstractColumnLayout createColumnLayout() {
        return new TableColumnLayout();
    }
}

