/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.core;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.core.AntClasspathEntry;
import org.eclipse.ant.internal.core.AntObject;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.util.tracker.ServiceTracker;

public class AntCorePreferences
implements Preferences.IPropertyChangeListener {
    private IEclipsePreferences.IPreferenceChangeListener prefListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String property = event.getKey();
            if (property.equals("tasks") || property.startsWith("task.")) {
                AntCorePreferences.this.restoreTasks();
            } else if (property.equals("types") || property.startsWith("type.")) {
                AntCorePreferences.this.restoreTypes();
            } else if (property.equals("ant_home_entries")) {
                AntCorePreferences.this.restoreAntHomeEntries();
            } else if (property.equals("additional_entries")) {
                AntCorePreferences.this.restoreAdditionalEntries();
            } else if (property.equals("ant_home")) {
                AntCorePreferences.this.restoreAntHome();
            } else if (property.equals("properties") || property.startsWith("property.")) {
                AntCorePreferences.this.restoreCustomProperties();
            } else if (property.equals("propertyfiles")) {
                AntCorePreferences.this.restoreCustomPropertyFiles();
            }
        }
    };
    private List<Task> defaultTasks;
    private List<Type> defaultTypes;
    private List<AntClasspathEntry> extraClasspathURLs;
    private List<Property> defaultProperties;
    private IAntClasspathEntry[] defaultAntHomeEntries;
    private Task[] customTasks;
    private Task[] oldCustomTasks;
    private Type[] customTypes;
    private Type[] oldCustomTypes;
    private IAntClasspathEntry[] antHomeEntries;
    private IAntClasspathEntry[] additionalEntries;
    private Property[] customProperties;
    private Property[] oldCustomProperties;
    private String[] customPropertyFiles;
    private List<WrappedClassLoader> pluginClassLoaders;
    private ClassLoader[] orderedPluginClassLoaders;
    private String antHome;
    private boolean runningHeadless = false;

    protected AntCorePreferences(List<IConfigurationElement> defaultTasks, List<IConfigurationElement> defaultExtraClasspath, List<IConfigurationElement> defaultTypes, boolean headless) {
        this(defaultTasks, defaultExtraClasspath, defaultTypes, Collections.emptyList(), headless);
    }

    protected AntCorePreferences(List<IConfigurationElement> defaultTasks, List<IConfigurationElement> defaultExtraClasspath, List<IConfigurationElement> defaultTypes, List<IConfigurationElement> defaultProperties, boolean headless) {
        this.runningHeadless = headless;
        this.initializePluginClassLoaders();
        this.extraClasspathURLs = new ArrayList<AntClasspathEntry>(20);
        this.defaultTasks = this.computeDefaultTasks(defaultTasks);
        this.defaultTypes = this.computeDefaultTypes(defaultTypes);
        this.computeDefaultExtraClasspathEntries(defaultExtraClasspath);
        this.computeDefaultProperties(defaultProperties);
        this.restoreCustomObjects();
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }

    private void restoreCustomObjects() {
        this.restoreAntHome();
        this.restoreTasks();
        this.restoreTypes();
        this.restoreAntHomeEntries();
        this.restoreAdditionalEntries();
        this.restoreCustomProperties();
        this.restoreCustomPropertyFiles();
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ant.core");
        if (node != null) {
            node.addPreferenceChangeListener(this.prefListener);
        }
    }

    private void restoreTasks() {
        String tasks = Platform.getPreferencesService().getString("org.eclipse.ant.core", "tasks", null, null);
        this.customTasks = tasks == null || "".equals(tasks) ? new Task[0] : this.extractTasks(AntCorePlugin.getPlugin().getPluginPreferences(), this.getArrayFromString(tasks));
    }

    private void restoreTypes() {
        String types = Platform.getPreferencesService().getString("org.eclipse.ant.core", "types", null, null);
        this.customTypes = types == null || "".equals(types) ? new Type[0] : this.extractTypes(AntCorePlugin.getPlugin().getPluginPreferences(), this.getArrayFromString(types));
    }

    private void restoreAntHomeEntries() {
        String entries = Platform.getPreferencesService().getString("org.eclipse.ant.core", "ant_urls", null, null);
        if (entries != null && !"".equals(entries)) {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ant.core");
            if (node != null) {
                node.remove("ant_urls");
                try {
                    node.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            this.antHomeEntries = this.migrateURLEntries(this.getArrayFromString(entries));
            return;
        }
        entries = Platform.getPreferencesService().getString("org.eclipse.ant.core", "ant_home_entries", null, null);
        this.antHomeEntries = entries == null || "".equals(entries) ? this.getDefaultAntHomeEntries() : this.extractEntries(this.getArrayFromString(entries));
    }

    private void restoreAdditionalEntries() {
        String entries = Platform.getPreferencesService().getString("org.eclipse.ant.core", "urls", null, null);
        if (entries != null && !"".equals(entries)) {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ant.core");
            if (node != null) {
                node.remove("urls");
                try {
                    node.flush();
                }
                catch (BackingStoreException backingStoreException) {}
            }
            this.additionalEntries = this.migrateURLEntries(this.getArrayFromString(entries));
            return;
        }
        entries = Platform.getPreferencesService().getString("org.eclipse.ant.core", "additional_entries", null, null);
        if (entries == null || "".equals(entries)) {
            IAntClasspathEntry toolsJarEntry = this.getToolsJarEntry();
            List<IAntClasspathEntry> userLibs = this.getUserLibraries();
            if (toolsJarEntry == null) {
                this.additionalEntries = userLibs == null ? new IAntClasspathEntry[0] : userLibs.toArray(new IAntClasspathEntry[userLibs.size()]);
            } else if (userLibs == null) {
                this.additionalEntries = new IAntClasspathEntry[]{toolsJarEntry};
            } else {
                userLibs.add(toolsJarEntry);
                this.additionalEntries = userLibs.toArray(new IAntClasspathEntry[userLibs.size()]);
            }
        } else {
            this.additionalEntries = this.extractEntries(this.getArrayFromString(entries));
        }
    }

    private IAntClasspathEntry[] migrateURLEntries(String[] urlEntries) {
        ArrayList<AntClasspathEntry> result = new ArrayList<AntClasspathEntry>(urlEntries.length);
        int i = 0;
        while (i < urlEntries.length) {
            block3: {
                URL url;
                try {
                    url = new URL(urlEntries[i]);
                }
                catch (MalformedURLException malformedURLException) {
                    break block3;
                }
                result.add(new AntClasspathEntry(url));
            }
            ++i;
        }
        return result.toArray(new IAntClasspathEntry[result.size()]);
    }

    private void restoreAntHome() {
        this.antHome = Platform.getPreferencesService().getString("org.eclipse.ant.core", "ant_home", null, null);
        if (this.antHome == null || "".equals(this.antHome)) {
            this.antHome = this.getDefaultAntHome();
        }
    }

    public String getDefaultAntHome() {
        IAntClasspathEntry[] entries = this.getDefaultAntHomeEntries();
        if (entries.length > 0) {
            URL antjar = entries[entries.length - 1].getEntryURL();
            Path antHomePath = new Path(antjar.getFile());
            antHomePath = antHomePath.removeLastSegments(2);
            return antHomePath.toFile().getAbsolutePath();
        }
        return null;
    }

    private void restoreCustomProperties() {
        String properties = Platform.getPreferencesService().getString("org.eclipse.ant.core", "properties", null, null);
        this.customProperties = properties == null || "".equals(properties) ? new Property[0] : this.extractProperties(AntCorePlugin.getPlugin().getPluginPreferences(), this.getArrayFromString(properties));
    }

    private void restoreCustomPropertyFiles() {
        String propertyFiles = Platform.getPreferencesService().getString("org.eclipse.ant.core", "propertyfiles", null, null);
        this.customPropertyFiles = propertyFiles == null || "".equals(propertyFiles) ? new String[0] : this.getArrayFromString(propertyFiles);
    }

    protected Task[] extractTasks(Preferences prefs, String[] tasks) {
        ArrayList<Task> result = new ArrayList<Task>(tasks.length);
        int i = 0;
        while (i < tasks.length) {
            String taskName = tasks[i];
            String[] values = this.getArrayFromString(prefs.getString("task." + taskName));
            if (values.length >= 2) {
                Task task = new Task();
                task.setTaskName(taskName);
                task.setClassName(values[0]);
                String library = values[1];
                if (library.startsWith("file:")) {
                    library = library.substring(5);
                }
                task.setLibraryEntry(new AntClasspathEntry(library));
                result.add(task);
            }
            ++i;
        }
        return result.toArray(new Task[result.size()]);
    }

    protected Type[] extractTypes(Preferences prefs, String[] types) {
        ArrayList<Type> result = new ArrayList<Type>(types.length);
        int i = 0;
        while (i < types.length) {
            String typeName = types[i];
            String[] values = this.getArrayFromString(prefs.getString("type." + typeName));
            if (values.length >= 2) {
                Type type = new Type();
                type.setTypeName(typeName);
                type.setClassName(values[0]);
                String library = values[1];
                if (library.startsWith("file:")) {
                    library = library.substring(5);
                }
                type.setLibraryEntry(new AntClasspathEntry(library));
                result.add(type);
            }
            ++i;
        }
        return result.toArray(new Type[result.size()]);
    }

    protected Property[] extractProperties(Preferences prefs, String[] properties) {
        Property[] result = new Property[properties.length];
        int i = 0;
        while (i < properties.length) {
            String propertyName = properties[i];
            String value = prefs.getString("property." + propertyName);
            Property property = new Property();
            property.setName(propertyName);
            property.setValue(value);
            result[i] = property;
            ++i;
        }
        return result;
    }

    private IAntClasspathEntry[] extractEntries(String[] entries) {
        IAntClasspathEntry[] result = new IAntClasspathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            result[i] = new AntClasspathEntry(entries[i]);
            ++i;
        }
        return result;
    }

    @Deprecated
    public URL[] getDefaultAntURLs() {
        IAntClasspathEntry[] entries = this.getDefaultAntHomeEntries();
        ArrayList<URL> result = new ArrayList<URL>(3);
        int i = 0;
        while (i < entries.length) {
            IAntClasspathEntry entry = entries[i];
            result.add(entry.getEntryURL());
            ++i;
        }
        URL toolsURL = this.getToolsJarURL();
        if (toolsURL != null) {
            result.add(toolsURL);
        }
        return result.toArray(new URL[result.size()]);
    }

    public synchronized IAntClasspathEntry[] getDefaultAntHomeEntries() {
        if (this.defaultAntHomeEntries == null) {
            tracker.open();
            try (ServiceTracker tracker = new ServiceTracker(AntCorePlugin.getPlugin().getBundle().getBundleContext(), PackageAdmin.class.getName(), null);){
                ArrayList<AntClasspathEntry> result = new ArrayList<AntClasspathEntry>(29);
                PackageAdmin packageAdmin = (PackageAdmin)tracker.getService();
                if (packageAdmin != null) {
                    ExportedPackage[] packages = packageAdmin.getExportedPackages("org.apache.tools.ant");
                    Bundle bundle = this.findHighestAntVersion(packages);
                    if (bundle == null) {
                        int i = 0;
                        while (i < packages.length) {
                            block13: {
                                bundle = packages[i].getExportingBundle();
                                if (bundle != null) {
                                    try {
                                        this.addLibraries(bundle, result);
                                        if (result.size() <= 0) break block13;
                                        break;
                                    }
                                    catch (IOException ioe) {
                                        AntCorePlugin.log(ioe);
                                        result.clear();
                                    }
                                }
                            }
                            ++i;
                        }
                    } else {
                        try {
                            this.addLibraries(bundle, result);
                        }
                        catch (IOException ioe) {
                            AntCorePlugin.log(ioe);
                        }
                    }
                }
                this.defaultAntHomeEntries = result.toArray(new IAntClasspathEntry[result.size()]);
            }
        }
        return this.defaultAntHomeEntries;
    }

    Bundle findHighestAntVersion(ExportedPackage[] packages) {
        Bundle bundle = null;
        HashSet<Bundle> bundles = new HashSet<Bundle>();
        int i = 0;
        while (i < packages.length) {
            bundle = packages[i].getExportingBundle();
            if (bundle != null && "org.apache.ant".equals(bundle.getSymbolicName())) {
                bundles.add(bundle);
            }
            ++i;
        }
        Bundle highest = null;
        Bundle temp2 = null;
        for (Bundle temp2 : bundles) {
            if (highest == null) {
                highest = temp2;
                continue;
            }
            if (highest.getVersion().compareTo(temp2.getVersion()) >= 0) continue;
            highest = temp2;
        }
        return highest;
    }

    @Deprecated
    public URL[] getAntURLs() {
        int extra = 0;
        IAntClasspathEntry entry = this.getToolsJarEntry();
        if (entry != null) {
            ++extra;
        }
        URL[] urls = new URL[this.antHomeEntries.length + extra];
        int i = 0;
        while (i < this.antHomeEntries.length) {
            URL url = this.antHomeEntries[i].getEntryURL();
            if (url != null) {
                urls[i] = url;
            }
            ++i;
        }
        if (entry != null) {
            urls[i] = entry.getEntryURL();
        }
        return urls;
    }

    protected List<Task> computeDefaultTasks(List<IConfigurationElement> tasks) {
        ArrayList<Task> result = new ArrayList<Task>(tasks.size());
        for (IConfigurationElement element : tasks) {
            if (!this.relevantRunningHeadless(element)) continue;
            Task task = new Task();
            task.setTaskName(element.getAttribute("name"));
            task.setClassName(element.getAttribute("class"));
            if (!this.configureAntObject(element, task, task.getTaskName(), InternalCoreAntMessages.AntCorePreferences_No_library_for_task)) continue;
            result.add(task);
        }
        return result;
    }

    private void addURLToExtraClasspathEntries(URL url, IConfigurationElement element) {
        String eclipseRuntime = element.getAttribute("eclipseRuntime");
        boolean eclipseRuntimeRequired = true;
        if (eclipseRuntime != null) {
            eclipseRuntimeRequired = Boolean.valueOf(eclipseRuntime);
        }
        for (IAntClasspathEntry iAntClasspathEntry : this.extraClasspathURLs) {
            if (!iAntClasspathEntry.getEntryURL().equals(url)) continue;
            return;
        }
        AntClasspathEntry antClasspathEntry = new AntClasspathEntry(url);
        antClasspathEntry.setEclipseRuntimeRequired(eclipseRuntimeRequired);
        this.extraClasspathURLs.add(antClasspathEntry);
    }

    protected List<Type> computeDefaultTypes(List<IConfigurationElement> types) {
        ArrayList<Type> result = new ArrayList<Type>(types.size());
        for (IConfigurationElement element : types) {
            if (!this.relevantRunningHeadless(element)) continue;
            Type type = new Type();
            type.setTypeName(element.getAttribute("name"));
            type.setClassName(element.getAttribute("class"));
            if (!this.configureAntObject(element, type, type.getTypeName(), InternalCoreAntMessages.AntCorePreferences_No_library_for_type)) continue;
            result.add(type);
        }
        return result;
    }

    private URL getClasspathEntryURL(Bundle bundle, String library) throws IOException {
        File urlFile = null;
        if (library.equals("/")) {
            urlFile = FileLocator.getBundleFile((Bundle)bundle);
        } else {
            try {
                URL fileURL = FileLocator.toFileURL((URL)bundle.getEntry(library));
                if (fileURL != null) {
                    urlFile = URIUtil.toFile((URI)URIUtil.toURI((URL)fileURL));
                }
            }
            catch (URISyntaxException e) {
                AntCorePlugin.log(e);
            }
        }
        if (urlFile == null || !urlFile.exists()) {
            return null;
        }
        String path = urlFile.getAbsolutePath();
        return new URL("file:" + (urlFile.isDirectory() ? String.valueOf(path) + "/" : path));
    }

    private boolean configureAntObject(IConfigurationElement element, AntObject antObject, String objectName, String errorMessage) {
        String library;
        block7: {
            String uri;
            String runtime = element.getAttribute("eclipseRuntime");
            if (runtime != null) {
                antObject.setEclipseRuntimeRequired(Boolean.valueOf(runtime));
            }
            if ((uri = element.getAttribute("uri")) != null) {
                antObject.setURI(uri);
            }
            if ((library = element.getAttribute("library")) == null) {
                Status status = new Status(4, "org.eclipse.ant.core", 3, NLS.bind((String)InternalCoreAntMessages.AntCorePreferences_Library_not_specified_for___0__4, (Object[])new String[]{objectName}), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                return false;
            }
            IContributor contributor = element.getContributor();
            antObject.setPluginLabel(contributor.getName());
            Bundle bundle = Platform.getBundle((String)contributor.getName());
            URL url = this.getClasspathEntryURL(bundle, library);
            if (url == null) break block7;
            this.addURLToExtraClasspathEntries(url, element);
            this.addPluginClassLoader(bundle);
            antObject.setLibraryEntry(new AntClasspathEntry(url));
            return true;
        }
        try {
            Status status = new Status(4, "org.eclipse.ant.core", 3, NLS.bind((String)errorMessage, (Object[])new String[]{library, element.getContributor().getName()}), null);
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            return false;
        }
        catch (MalformedURLException e) {
            Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.AntCorePreferences_Malformed_URL__1, (Throwable)e);
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        }
        catch (Exception exception) {
            Status status = new Status(4, "org.eclipse.ant.core", 3, NLS.bind((String)InternalCoreAntMessages.AntCorePreferences_8, (Object[])new String[]{library, element.getContributor().getName()}), null);
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
        }
        return false;
    }

    protected void computeDefaultExtraClasspathEntries(List<IConfigurationElement> entries) {
        for (IConfigurationElement element : entries) {
            Status status;
            if (!this.relevantRunningHeadless(element)) continue;
            String library = element.getAttribute("library");
            Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
            try {
                URL url = this.getClasspathEntryURL(bundle, library);
                if (url != null) {
                    this.addURLToExtraClasspathEntries(url, element);
                    this.addPluginClassLoader(bundle);
                    continue;
                }
                status = new Status(4, "org.eclipse.ant.core", 3, NLS.bind((String)InternalCoreAntMessages.AntCorePreferences_6, (Object[])new String[]{library, element.getContributor().getName()}), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            catch (MalformedURLException e) {
                status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.AntCorePreferences_Malformed_URL__1, (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            catch (Exception exception) {
                Status status2 = new Status(4, "org.eclipse.ant.core", 3, NLS.bind((String)InternalCoreAntMessages.AntCorePreferences_6, (Object[])new String[]{library, element.getContributor().getName()}), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status2);
            }
        }
    }

    private boolean relevantRunningHeadless(IConfigurationElement element) {
        boolean headlessProperty;
        String headless;
        return !this.runningHeadless || (headless = element.getAttribute("headless")) == null || (headlessProperty = Boolean.valueOf(headless).booleanValue());
    }

    private void computeDefaultProperties(List<IConfigurationElement> properties) {
        this.defaultProperties = new ArrayList<Property>(properties.size());
        for (IConfigurationElement element : properties) {
            String name;
            if (!this.relevantRunningHeadless(element) || (name = element.getAttribute("name")) == null) continue;
            String value = element.getAttribute("value");
            Property property = null;
            if (value != null) {
                property = new Property(name, value);
                property.setPluginLabel(element.getContributor().getName());
            } else {
                Bundle bundle = Platform.getBundle((String)element.getContributor().getName());
                if (bundle == null) continue;
                property = new Property();
                property.setName(name);
                property.setPluginLabel(element.getContributor().getName());
                String className = element.getAttribute("class");
                property.setValueProvider(className, this.getClassLoader(bundle));
            }
            this.defaultProperties.add(property);
            String runtime = element.getAttribute("eclipseRuntime");
            if (runtime == null) continue;
            property.setEclipseRuntimeRequired(Boolean.valueOf(runtime));
        }
    }

    private WrappedClassLoader getClassLoader(Bundle b) {
        return new WrappedClassLoader(b);
    }

    public IAntClasspathEntry getToolsJarEntry(IPath javaHomePath) {
        File tools;
        IPath newjh = javaHomePath;
        if ("jre".equalsIgnoreCase(newjh.lastSegment())) {
            newjh = newjh.removeLastSegments(1);
        }
        if (!(tools = (newjh = newjh.append("lib").append("tools.jar")).toFile()).exists()) {
            newjh = newjh.removeLastSegments(1);
            tools = (newjh = newjh.append("classes.zip")).toFile();
            if (!tools.exists()) {
                return null;
            }
        }
        return new AntClasspathEntry(tools.getAbsolutePath());
    }

    @Deprecated
    public URL getToolsJarURL() {
        Path path = new Path(System.getProperty("java.home"));
        IAntClasspathEntry entry = this.getToolsJarEntry((IPath)path);
        if (entry == null) {
            IDynamicVariable variable = VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable("env_var");
            String javaHome = null;
            try {
                if (variable != null) {
                    javaHome = variable.getValue("JAVA_HOME");
                }
                if (javaHome != null) {
                    path = new Path(javaHome);
                    entry = this.getToolsJarEntry((IPath)path);
                }
            }
            catch (CoreException e) {
                AntCorePlugin.log(e);
            }
        }
        if (entry != null) {
            return entry.getEntryURL();
        }
        return null;
    }

    public IAntClasspathEntry getToolsJarEntry() {
        Path path = new Path(System.getProperty("java.home"));
        IAntClasspathEntry entry = this.getToolsJarEntry((IPath)path);
        if (entry == null) {
            IDynamicVariable variable = VariablesPlugin.getDefault().getStringVariableManager().getDynamicVariable("env_var");
            String javaHome = null;
            try {
                if (variable != null) {
                    javaHome = variable.getValue("JAVA_HOME");
                }
                if (javaHome != null) {
                    path = new Path(javaHome);
                    entry = this.getToolsJarEntry((IPath)path);
                }
            }
            catch (CoreException e) {
                AntCorePlugin.log(e);
            }
        }
        return entry;
    }

    private List<IAntClasspathEntry> getUserLibraries() {
        File libDir = new File(System.getProperty("user.home"), ".ant" + File.separatorChar + "lib");
        URL[] urls = null;
        try {
            urls = this.getLocationURLs(libDir);
        }
        catch (MalformedURLException e) {
            AntCorePlugin.log(e);
        }
        if (urls == null) {
            return null;
        }
        ArrayList<IAntClasspathEntry> entries = new ArrayList<IAntClasspathEntry>(urls.length);
        int i = 0;
        while (i < urls.length) {
            AntClasspathEntry entry = new AntClasspathEntry(urls[i]);
            entries.add(entry);
            ++i;
        }
        return entries;
    }

    private URL[] getLocationURLs(File location) throws MalformedURLException {
        URL[] urls = null;
        if (!location.exists()) {
            return urls;
        }
        if (!location.isDirectory()) {
            urls = new URL[1];
            String path = location.getPath();
            if (path.toLowerCase().endsWith(".jar")) {
                urls[0] = location.toURI().toURL();
            }
            return urls;
        }
        File[] matches = location.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jar");
            }
        });
        urls = new URL[matches.length];
        int i = 0;
        while (i < matches.length) {
            urls[i] = matches[i].toURI().toURL();
            ++i;
        }
        return urls;
    }

    private void addLibraries(Bundle source, List<AntClasspathEntry> destination) throws IOException, MalformedURLException {
        ManifestElement[] libraries = null;
        try {
            libraries = ManifestElement.parseHeader((String)"Bundle-ClassPath", (String)((String)source.getHeaders("").get("Bundle-ClassPath")));
        }
        catch (BundleException e) {
            Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.AntCorePreferences_0, (Throwable)e);
            AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            return;
        }
        if (libraries == null) {
            return;
        }
        URL url = null;
        int i = 0;
        while (i < libraries.length) {
            url = source.getEntry(libraries[i].getValue());
            if (url != null) {
                destination.add(new AntClasspathEntry(FileLocator.toFileURL((URL)url)));
            }
            ++i;
        }
    }

    protected void addPluginClassLoader(Bundle bundle) {
        WrappedClassLoader loader = this.getClassLoader(bundle);
        if (!this.pluginClassLoaders.contains(loader)) {
            this.pluginClassLoaders.add(loader);
        }
    }

    public URL[] getExtraClasspathURLs() {
        URL[] urls = new URL[this.extraClasspathURLs.size()];
        int i = 0;
        while (i < this.extraClasspathURLs.size()) {
            IAntClasspathEntry entry = this.extraClasspathURLs.get(i);
            urls[i] = entry.getEntryURL();
            ++i;
        }
        return urls;
    }

    public URL[] getRemoteExtraClasspathURLs() {
        ArrayList<URL> urls = new ArrayList<URL>(this.extraClasspathURLs.size());
        int i = 0;
        while (i < this.extraClasspathURLs.size()) {
            IAntClasspathEntry entry = this.extraClasspathURLs.get(i);
            if (!entry.isEclipseRuntimeRequired()) {
                urls.add(entry.getEntryURL());
            }
            ++i;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public URL[] getURLs() {
        ArrayList<URL> result = new ArrayList<URL>(60);
        if (this.antHomeEntries != null) {
            this.addEntryURLs(result, this.antHomeEntries);
        }
        if (this.additionalEntries != null && this.additionalEntries.length > 0) {
            this.addEntryURLs(result, this.additionalEntries);
        }
        int i = 0;
        while (i < this.extraClasspathURLs.size()) {
            IAntClasspathEntry entry = this.extraClasspathURLs.get(i);
            URL url = entry.getEntryURL();
            if (url != null) {
                result.add(url);
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }

    private void addEntryURLs(List<URL> result, IAntClasspathEntry[] entries) {
        int i = 0;
        while (i < entries.length) {
            IAntClasspathEntry entry = entries[i];
            URL url = entry.getEntryURL();
            if (url != null) {
                result.add(url);
            }
            ++i;
        }
    }

    protected ClassLoader[] getPluginClassLoaders() {
        if (this.orderedPluginClassLoaders == null) {
            Iterator<WrappedClassLoader> classLoaders = this.pluginClassLoaders.iterator();
            HashMap<String, WrappedClassLoader> idToLoader = new HashMap<String, WrappedClassLoader>(this.pluginClassLoaders.size());
            ArrayList<BundleRevision> bundles = new ArrayList<BundleRevision>(this.pluginClassLoaders.size());
            while (classLoaders.hasNext()) {
                WrappedClassLoader loader = classLoaders.next();
                idToLoader.put(loader.bundle.getSymbolicName(), loader);
                BundleRevision revision = (BundleRevision)loader.bundle.adapt(BundleRevision.class);
                if (revision == null) continue;
                bundles.add(revision);
            }
            List<BundleRevision> sorted = this.computePrerequisiteOrder(bundles);
            ArrayList<WrappedClassLoader> loaders = new ArrayList<WrappedClassLoader>(sorted.size());
            for (BundleRevision revision : sorted) {
                String id = revision.getSymbolicName();
                loaders.add((WrappedClassLoader)idToLoader.get(id));
            }
            this.orderedPluginClassLoaders = loaders.toArray(new ClassLoader[loaders.size()]);
        }
        return this.orderedPluginClassLoaders;
    }

    private List<BundleRevision> computePrerequisiteOrder(List<BundleRevision> plugins) {
        ArrayList<Relation> prereqs = new ArrayList<Relation>(plugins.size());
        ArrayList<BundleRevision> fragments = new ArrayList<BundleRevision>();
        for (BundleRevision current : plugins) {
            BundleRevision[] prereqList;
            if ((current.getTypes() & 1) != 0) {
                fragments.add(current);
                continue;
            }
            boolean found = false;
            BundleRevision[] bundleRevisionArray = prereqList = this.getDependentBundles(current);
            int n = prereqList.length;
            int n2 = 0;
            while (n2 < n) {
                BundleRevision prereq = bundleRevisionArray[n2];
                if (plugins.contains(prereq)) {
                    found = true;
                    prereqs.add(new Relation(current, prereq));
                }
                ++n2;
            }
            if (found) continue;
            prereqs.add(new Relation(current, null));
        }
        for (BundleRevision currentFrag : fragments) {
            if (plugins.contains(currentFrag)) {
                List hostWires;
                BundleWiring wiring = currentFrag.getWiring();
                List list = hostWires = wiring == null ? Collections.emptyList() : wiring.getRequiredWires("osgi.wiring.host");
                if (hostWires.isEmpty()) continue;
                prereqs.add(new Relation(currentFrag, ((BundleWire)hostWires.get(0)).getProvider()));
                continue;
            }
            AntCorePlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.ant.core", 2, NLS.bind((String)InternalCoreAntMessages.AntCorePreferences_1, (Object[])new String[]{currentFrag.getSymbolicName()}), null));
        }
        return this.computeNodeOrder(prereqs);
    }

    private BundleRevision[] getDependentBundles(BundleRevision root) {
        BundleRevision[] imported = this.getImportedBundles(root);
        BundleRevision[] required = this.getRequiredBundles(root);
        BundleRevision[] dependents = new BundleRevision[imported.length + required.length];
        System.arraycopy(imported, 0, dependents, 0, imported.length);
        System.arraycopy(required, 0, dependents, imported.length, required.length);
        return dependents;
    }

    private BundleRevision[] getRequiredBundles(BundleRevision root) {
        return this.getDependantRequirements(root, "osgi.wiring.bundle");
    }

    private BundleRevision[] getImportedBundles(BundleRevision root) {
        return this.getDependantRequirements(root, "osgi.wiring.package");
    }

    private BundleRevision[] getDependantRequirements(BundleRevision root, String namespace) {
        if (root == null) {
            return new BundleRevision[0];
        }
        BundleWiring wiring = root.getWiring();
        List requiredWires = wiring == null ? Collections.emptyList() : wiring.getRequiredWires(namespace);
        ArrayList<BundleRevision> requirementProviders = new ArrayList<BundleRevision>(requiredWires.size());
        for (BundleWire requiredWire : requiredWires) {
            BundleRevision provider = requiredWire.getProvider();
            if (provider.equals((Object)root) || requirementProviders.contains(provider)) continue;
            requirementProviders.add(provider);
        }
        return requirementProviders.toArray(new BundleRevision[requirementProviders.size()]);
    }

    private void removeArcs(List<Relation> edges, List<BundleRevision> roots, Map<BundleRevision, Integer> counts) {
        for (BundleRevision root : roots) {
            int i = 0;
            while (i < edges.size()) {
                BundleRevision input;
                Integer count;
                if (root.equals(edges.get((int)i).to) && (count = counts.get(input = edges.get((int)i).from)) != null) {
                    counts.put(input, count - 1);
                }
                ++i;
            }
        }
    }

    private List<BundleRevision> computeNodeOrder(List<Relation> edges) {
        Map<BundleRevision, Integer> counts = this.computeCounts(edges);
        ArrayList<BundleRevision> nodes = new ArrayList<BundleRevision>(counts.size());
        while (!counts.isEmpty()) {
            List<BundleRevision> roots = this.findRootNodes(counts);
            if (roots.isEmpty()) break;
            Iterator<BundleRevision> i = roots.iterator();
            while (i.hasNext()) {
                counts.remove(i.next());
            }
            nodes.addAll(roots);
            this.removeArcs(edges, roots, counts);
        }
        return nodes;
    }

    private Map<BundleRevision, Integer> computeCounts(List<Relation> mappings) {
        HashMap<BundleRevision, Integer> counts = new HashMap<BundleRevision, Integer>(5);
        int i = 0;
        while (i < mappings.size()) {
            BundleRevision from = mappings.get((int)i).from;
            Integer fromCount = (Integer)counts.get(from);
            BundleRevision to = mappings.get((int)i).to;
            if (to == null) {
                counts.put(from, 0);
            } else {
                if (counts.get(to) == null) {
                    counts.put(to, 0);
                }
                fromCount = fromCount == null ? Integer.valueOf(1) : new Integer(fromCount + 1);
                counts.put(from, fromCount);
            }
            ++i;
        }
        return counts;
    }

    private List<BundleRevision> findRootNodes(Map<BundleRevision, Integer> counts) {
        ArrayList<BundleRevision> result = new ArrayList<BundleRevision>(5);
        for (BundleRevision node : counts.keySet()) {
            int count = counts.get(node);
            if (count != 0) continue;
            result.add(node);
        }
        return result;
    }

    private void initializePluginClassLoaders() {
        this.pluginClassLoaders = new ArrayList<WrappedClassLoader>(10);
        this.pluginClassLoaders.add(this.getClassLoader(AntCorePlugin.getPlugin().getBundle()));
    }

    public List<Task> getTasks() {
        ArrayList<Task> result = new ArrayList<Task>(10);
        if (this.defaultTasks != null && !this.defaultTasks.isEmpty()) {
            result.addAll(this.defaultTasks);
        }
        if (this.customTasks != null && this.customTasks.length != 0) {
            result.addAll(Arrays.asList(this.customTasks));
        }
        return result;
    }

    public List<Task> getRemoteTasks() {
        ArrayList<Task> result = new ArrayList<Task>(10);
        if (this.defaultTasks != null && !this.defaultTasks.isEmpty()) {
            for (Task task : this.defaultTasks) {
                if (task.isEclipseRuntimeRequired()) continue;
                result.add(task);
            }
        }
        if (this.customTasks != null && this.customTasks.length != 0) {
            result.addAll(Arrays.asList(this.customTasks));
        }
        return result;
    }

    public Task[] getCustomTasks() {
        return this.customTasks;
    }

    public Type[] getCustomTypes() {
        return this.customTypes;
    }

    public Property[] getCustomProperties() {
        return this.customProperties;
    }

    public List<Property> getProperties() {
        ArrayList<Property> result = new ArrayList<Property>(10);
        if (this.defaultProperties != null && !this.defaultProperties.isEmpty()) {
            result.addAll(this.defaultProperties);
        }
        if (this.customProperties != null && this.customProperties.length != 0) {
            result.addAll(Arrays.asList(this.customProperties));
        }
        return result;
    }

    public List<Property> getRemoteAntProperties() {
        ArrayList<Property> result = new ArrayList<Property>(10);
        if (this.defaultProperties != null && !this.defaultProperties.isEmpty()) {
            for (Property property : this.defaultProperties) {
                if (property.isEclipseRuntimeRequired()) continue;
                result.add(property);
            }
        }
        if (this.customProperties != null && this.customProperties.length != 0) {
            result.addAll(Arrays.asList(this.customProperties));
        }
        return result;
    }

    public String[] getCustomPropertyFiles(boolean performStringSubstition) {
        if (!performStringSubstition || this.customPropertyFiles == null || this.customPropertyFiles.length == 0) {
            return this.customPropertyFiles;
        }
        ArrayList<String> files = new ArrayList<String>(this.customPropertyFiles.length);
        int i = 0;
        while (i < this.customPropertyFiles.length) {
            String filename = this.customPropertyFiles[i];
            try {
                filename = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(filename);
                files.add(filename);
            }
            catch (CoreException coreException) {
                files.add(filename);
            }
            ++i;
        }
        return files.toArray(new String[files.size()]);
    }

    public String[] getCustomPropertyFiles() {
        return this.getCustomPropertyFiles(true);
    }

    @Deprecated
    public URL[] getCustomURLs() {
        URL[] urls = new URL[this.additionalEntries.length];
        int i = 0;
        while (i < this.additionalEntries.length) {
            URL url = this.additionalEntries[i].getEntryURL();
            if (url != null) {
                urls[i] = url;
            }
            ++i;
        }
        return urls;
    }

    public void setCustomTasks(Task[] tasks) {
        this.oldCustomTasks = this.customTasks;
        this.customTasks = tasks;
    }

    public void setCustomTypes(Type[] types) {
        this.oldCustomTypes = this.customTypes;
        this.customTypes = types;
    }

    @Deprecated
    public void setCustomURLs(URL[] urls) {
        this.additionalEntries = new IAntClasspathEntry[urls.length];
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            AntClasspathEntry entry = new AntClasspathEntry(url);
            this.additionalEntries[i] = entry;
            ++i;
        }
    }

    @Deprecated
    public void setAntURLs(URL[] urls) {
        this.antHomeEntries = new IAntClasspathEntry[urls.length];
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            AntClasspathEntry entry = new AntClasspathEntry(url);
            this.antHomeEntries[i] = entry;
            ++i;
        }
    }

    public void setCustomPropertyFiles(String[] paths) {
        this.customPropertyFiles = paths;
    }

    public void setCustomProperties(Property[] properties) {
        this.oldCustomProperties = this.customProperties;
        this.customProperties = properties;
    }

    public List<Type> getTypes() {
        ArrayList<Type> result = new ArrayList<Type>(10);
        if (this.defaultTypes != null && !this.defaultTypes.isEmpty()) {
            result.addAll(this.defaultTypes);
        }
        if (this.customTypes != null && this.customTypes.length != 0) {
            result.addAll(Arrays.asList(this.customTypes));
        }
        return result;
    }

    public List<Type> getRemoteTypes() {
        ArrayList<Type> result = new ArrayList<Type>(10);
        if (this.defaultTypes != null && !this.defaultTypes.isEmpty()) {
            for (Type type : this.defaultTypes) {
                if (type.isEclipseRuntimeRequired()) continue;
                result.add(type);
            }
        }
        if (this.customTypes != null && this.customTypes.length != 0) {
            result.addAll(Arrays.asList(this.customTypes));
        }
        return result;
    }

    public List<Type> getDefaultTypes() {
        ArrayList<Type> result = new ArrayList<Type>(10);
        if (this.defaultTypes != null && !this.defaultTypes.isEmpty()) {
            result.addAll(this.defaultTypes);
        }
        return result;
    }

    public List<Task> getDefaultTasks() {
        ArrayList<Task> result = new ArrayList<Task>(10);
        if (this.defaultTasks != null && !this.defaultTasks.isEmpty()) {
            result.addAll(this.defaultTasks);
        }
        return result;
    }

    public List<Property> getDefaultProperties() {
        ArrayList<Property> result = new ArrayList<Property>(10);
        if (this.defaultProperties != null && !this.defaultProperties.isEmpty()) {
            result.addAll(this.defaultProperties);
        }
        return result;
    }

    protected String[] getArrayFromString(String list) {
        String separator = ",";
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public void updatePluginPreferences() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.ant.core");
        if (node != null) {
            node.removePreferenceChangeListener(this.prefListener);
            Preferences prefs = AntCorePlugin.getPlugin().getPluginPreferences();
            this.updateTasks(prefs);
            this.updateTypes(prefs);
            this.updateAntHomeEntries(prefs);
            this.updateAdditionalEntries(prefs);
            this.updateProperties(prefs);
            this.updatePropertyFiles(prefs);
            boolean classpathChanged = AntCorePlugin.getPlugin().getPluginPreferences().needsSaving();
            AntCorePlugin.getPlugin().savePluginPreferences();
            if (classpathChanged) {
                prefs.setValue("classpath_changed", true);
            }
            prefs.setValue("classpath_changed", false);
            node.addPreferenceChangeListener(this.prefListener);
        }
    }

    protected void updateTasks(Preferences prefs) {
        if (this.oldCustomTasks != null) {
            int i = 0;
            while (i < this.oldCustomTasks.length) {
                Task oldTask = this.oldCustomTasks[i];
                prefs.setToDefault("task." + oldTask.getTaskName());
                ++i;
            }
            this.oldCustomTasks = null;
        }
        if (this.customTasks.length == 0) {
            prefs.setValue("tasks", "");
            return;
        }
        StringBuffer tasks = new StringBuffer();
        int i = 0;
        while (i < this.customTasks.length) {
            tasks.append(this.customTasks[i].getTaskName());
            tasks.append(',');
            prefs.setValue("task." + this.customTasks[i].getTaskName(), String.valueOf(this.customTasks[i].getClassName()) + "," + this.customTasks[i].getLibraryEntry().getLabel());
            ++i;
        }
        prefs.setValue("tasks", tasks.toString());
    }

    protected void updateTypes(Preferences prefs) {
        if (this.oldCustomTypes != null) {
            int i = 0;
            while (i < this.oldCustomTypes.length) {
                Type oldType = this.oldCustomTypes[i];
                prefs.setToDefault("type." + oldType.getTypeName());
                ++i;
            }
            this.oldCustomTypes = null;
        }
        if (this.customTypes.length == 0) {
            prefs.setValue("types", "");
            return;
        }
        StringBuffer types = new StringBuffer();
        int i = 0;
        while (i < this.customTypes.length) {
            types.append(this.customTypes[i].getTypeName());
            types.append(',');
            prefs.setValue("type." + this.customTypes[i].getTypeName(), String.valueOf(this.customTypes[i].getClassName()) + "," + this.customTypes[i].getLibraryEntry().getLabel());
            ++i;
        }
        prefs.setValue("types", types.toString());
    }

    protected void updateProperties(Preferences prefs) {
        if (this.oldCustomProperties != null) {
            int i = 0;
            while (i < this.oldCustomProperties.length) {
                Property oldProperty = this.oldCustomProperties[i];
                prefs.setToDefault("property." + oldProperty.getName());
                ++i;
            }
            this.oldCustomProperties = null;
        }
        if (this.customProperties.length == 0) {
            prefs.setValue("properties", "");
            return;
        }
        StringBuffer properties = new StringBuffer();
        int i = 0;
        while (i < this.customProperties.length) {
            properties.append(this.customProperties[i].getName());
            properties.append(',');
            prefs.setValue("property." + this.customProperties[i].getName(), this.customProperties[i].getValue(false));
            ++i;
        }
        prefs.setValue("properties", properties.toString());
    }

    protected void updateAdditionalEntries(Preferences prefs) {
        prefs.setValue("urls", "");
        String serialized = "";
        IAntClasspathEntry toolsJarEntry = this.getToolsJarEntry();
        List<IAntClasspathEntry> userLibs = this.getUserLibraries();
        if (userLibs == null) {
            userLibs = new ArrayList<IAntClasspathEntry>();
        }
        if (toolsJarEntry != null) {
            userLibs.add(toolsJarEntry);
        }
        boolean changed = true;
        if (this.additionalEntries.length == userLibs.size()) {
            changed = false;
            int i = 0;
            while (i < this.additionalEntries.length) {
                if (!this.additionalEntries[i].equals(userLibs.get(i))) {
                    changed = true;
                    break;
                }
                ++i;
            }
        }
        if (changed) {
            StringBuffer entries = new StringBuffer();
            int i = 0;
            while (i < this.additionalEntries.length) {
                entries.append(this.additionalEntries[i].getLabel());
                entries.append(',');
                ++i;
            }
            serialized = entries.toString();
        }
        prefs.setValue("additional_entries", serialized);
        String prefAntHome = "";
        if (this.antHome != null && !this.antHome.equals(this.getDefaultAntHome())) {
            prefAntHome = this.antHome;
        }
        prefs.setValue("ant_home", prefAntHome);
    }

    protected void updateAntHomeEntries(Preferences prefs) {
        prefs.setValue("ant_urls", "");
        IAntClasspathEntry[] defaultEntries = this.getDefaultAntHomeEntries();
        boolean dflt = false;
        if (defaultEntries.length == this.antHomeEntries.length) {
            dflt = true;
            int i = 0;
            while (i < this.antHomeEntries.length) {
                if (!this.antHomeEntries[i].equals(defaultEntries[i])) {
                    dflt = false;
                    break;
                }
                ++i;
            }
        }
        if (dflt) {
            prefs.setValue("ant_home_entries", "");
            return;
        }
        StringBuffer entries = new StringBuffer();
        int i = 0;
        while (i < this.antHomeEntries.length) {
            entries.append(this.antHomeEntries[i].getLabel());
            entries.append(',');
            ++i;
        }
        prefs.setValue("ant_home_entries", entries.toString());
    }

    protected void updatePropertyFiles(Preferences prefs) {
        StringBuffer files = new StringBuffer();
        int i = 0;
        while (i < this.customPropertyFiles.length) {
            files.append(this.customPropertyFiles[i]);
            files.append(',');
            ++i;
        }
        prefs.setValue("propertyfiles", files.toString());
    }

    public void setAntHome(String antHome) {
        this.antHome = antHome;
    }

    public String getAntHome() {
        return this.antHome;
    }

    public IAntClasspathEntry[] getAntHomeClasspathEntries() {
        return this.antHomeEntries;
    }

    public IAntClasspathEntry[] getAdditionalClasspathEntries() {
        return this.additionalEntries;
    }

    public void setAntHomeClasspathEntries(IAntClasspathEntry[] entries) {
        this.antHomeEntries = entries;
    }

    public void setAdditionalClasspathEntries(IAntClasspathEntry[] entries) {
        this.additionalEntries = entries;
    }

    public URL[] getRemoteAntURLs() {
        IAntClasspathEntry entry;
        int i;
        ArrayList<URL> result = new ArrayList<URL>(40);
        if (this.antHomeEntries != null) {
            i = 0;
            while (i < this.antHomeEntries.length) {
                entry = this.antHomeEntries[i];
                result.add(entry.getEntryURL());
                ++i;
            }
        }
        if (this.additionalEntries != null && this.additionalEntries.length > 0) {
            i = 0;
            while (i < this.additionalEntries.length) {
                entry = this.additionalEntries[i];
                result.add(entry.getEntryURL());
                ++i;
            }
        }
        if (this.extraClasspathURLs != null) {
            i = 0;
            while (i < this.extraClasspathURLs.size()) {
                entry = this.extraClasspathURLs.get(i);
                if (!entry.isEclipseRuntimeRequired()) {
                    result.add(entry.getEntryURL());
                }
                ++i;
            }
        }
        return result.toArray(new URL[result.size()]);
    }

    public IAntClasspathEntry[] getContributedClasspathEntries() {
        return this.extraClasspathURLs.toArray(new IAntClasspathEntry[this.extraClasspathURLs.size()]);
    }

    private static class Relation {
        BundleRevision from;
        BundleRevision to;

        Relation(BundleRevision from, BundleRevision to) {
            this.from = from;
            this.to = to;
        }

        public String toString() {
            return String.valueOf(this.from.toString()) + "->" + (this.to == null ? "" : this.to.toString());
        }
    }

    class WrappedClassLoader
    extends ClassLoader {
        private Bundle bundle;

        public WrappedClassLoader(Bundle bundle) {
            this.bundle = bundle;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            return this.bundle.loadClass(name);
        }

        @Override
        public URL findResource(String name) {
            return this.bundle.getResource(name);
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.bundle.getResources(name);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof WrappedClassLoader)) {
                return false;
            }
            return this.bundle == ((WrappedClassLoader)obj).bundle;
        }

        public int hashCode() {
            return this.bundle.hashCode();
        }

        public String toString() {
            return "WrappedClassLoader(" + this.bundle.toString() + ")";
        }
    }
}

