/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base.running;

import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.generator.headless.logging.IHeadlessLogger;
import org.eclipse.n4js.hlc.base.ErrorExitCode;
import org.eclipse.n4js.hlc.base.ExitCodeException;
import org.eclipse.n4js.hlc.base.running.RunnableLookupHelper;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;
import org.eclipse.n4js.runner.extension.IRunnerDescriptor;
import org.eclipse.n4js.runner.extension.RunnerRegistry;

public class HeadlessRunner {
    @Inject
    private RunnerFrontEnd runnerFrontEnd;
    @Inject
    private RunnerRegistry runnerRegistry;
    @Inject
    private IHeadlessLogger logger;
    @Inject
    RunnableLookupHelper runnerLookup;

    public void startRunner(String runner, String implementationId, URI locationToRun, Collection<String> additionalPaths) throws ExitCodeException {
        IRunnerDescriptor runnerDescriptor = this.checkRunner(runner);
        this.logger.info("Using runner :" + runnerDescriptor.getId());
        RunConfiguration runConfiguration = null;
        try {
            runConfiguration = this.runnerFrontEnd.createConfiguration(runnerDescriptor.getId(), implementationId, locationToRun);
            runConfiguration.addAdditionalPath(additionalPaths);
        }
        catch (IllegalStateException e2) {
            this.logger.error(Throwables.getStackTraceAsString((Throwable)e2));
            throw new ExitCodeException(ErrorExitCode.EXITCODE_RUNNER_STOPPED_WITH_ERROR, "Cannot create run configuration.", (Throwable)e2);
        }
        try {
            Process process = this.runnerFrontEnd.run(runConfiguration);
            int exit = process.waitFor();
            if (exit != 0) {
                throw new ExitCodeException(ErrorExitCode.EXITCODE_RUNNER_STOPPED_WITH_ERROR, "The spawned runner '" + runnerDescriptor.getId() + "' exited with code=" + exit);
            }
        }
        catch (Exception e1) {
            this.logger.error(Throwables.getStackTraceAsString((Throwable)e1));
            throw new ExitCodeException(ErrorExitCode.EXITCODE_RUNNER_STOPPED_WITH_ERROR, "The spawned runner exited by throwing an exception", (Throwable)e1);
        }
    }

    private IRunnerDescriptor checkRunner(String runner) throws ExitCodeException {
        List matchingRunnerDescs = this.runnerLookup.findRunnableById(runner, this.runnerRegistry.getDescriptors());
        if (matchingRunnerDescs.isEmpty()) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_RUNNER_NOT_FOUND, "no runner found for id: " + runner);
        }
        if (matchingRunnerDescs.size() > 1) {
            throw new ExitCodeException(ErrorExitCode.EXITCODE_RUNNER_NOT_FOUND, "several runners match given id \"" + runner + "\":\n\t" + Joiner.on((String)"\n\t").join(matchingRunnerDescs));
        }
        return (IRunnerDescriptor)matchingRunnerDescs.get(0);
    }
}

