/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.migrations;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TypingStrategy;

public class SuperClassifierIterator
implements Iterator<SuperClassifierEntry> {
    private final Deque<SuperClassifierEntry> queue = new ArrayDeque<SuperClassifierEntry>();

    public SuperClassifierIterator(TClassifier baseClassifier) {
        this.queue.push(new SuperClassifierEntry(0, baseClassifier));
    }

    @Override
    public boolean hasNext() {
        return !this.queue.isEmpty();
    }

    @Override
    public SuperClassifierEntry next() {
        if (this.queue.isEmpty()) {
            throw new NoSuchElementException();
        }
        SuperClassifierEntry nextEntry = this.queue.pop();
        this.queue.addAll(this.getSuperClassifiers(nextEntry.level, nextEntry.classifier));
        return nextEntry;
    }

    private Collection<SuperClassifierEntry> getSuperClassifiers(int level, TClassifier classifier) {
        return StreamSupport.stream(classifier.getSuperClassifierRefs().spliterator(), false).filter(c -> c.getTypingStrategy() == TypingStrategy.NOMINAL).map(c -> c.getDeclaredType()).filter(c -> c instanceof TClassifier).map(c -> new SuperClassifierEntry(level + 1, (TClassifier)c)).collect(Collectors.toList());
    }

    public static class SuperClassifierEntry {
        public final TClassifier classifier;
        public final int level;

        public SuperClassifierEntry(int level, TClassifier classifier) {
            this.level = level;
            this.classifier = classifier;
        }
    }
}

