/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.inject.Inject;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.external.N4JSExternalProject;
import org.eclipse.n4js.preferences.ExternalLibraryPreferenceStore;
import org.eclipse.n4js.ui.external.EclipseExternalLibraryWorkspace;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.service.OperationCanceledError;
import org.eclipse.xtext.ui.editor.validation.MarkerCreator;
import org.eclipse.xtext.ui.validation.DefaultResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.IResourceUIValidatorExtension;
import org.eclipse.xtext.ui.validation.MarkerEraser;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.IResourceValidator;
import org.eclipse.xtext.validation.Issue;

public class ResourceUIValidatorExtension
extends MarkerEraser
implements IResourceUIValidatorExtension {
    private static final Logger LOGGER = Logger.getLogger(DefaultResourceUIValidatorExtension.class);
    @Inject
    private ExternalLibraryPreferenceStore externalLibraryPreferenceStore;
    @Inject
    private EclipseExternalLibraryWorkspace externalLibraryWorkspace;

    public void updateValidationMarkers(IFile file, Resource resource, CheckMode mode, IProgressMonitor monitor) throws OperationCanceledException {
        if (this.shouldProcess(file)) {
            this.addMarkers(file, resource, mode, monitor);
        }
    }

    public void deleteValidationMarkers(IFile file, CheckMode checkMode, IProgressMonitor monitor) {
        super.deleteValidationMarkers(file, checkMode, monitor);
    }

    private void addMarkers(IFile file, Resource resource, CheckMode mode, IProgressMonitor monitor) throws OperationCanceledException {
        try {
            List list = this.getValidator(resource).validate(resource, mode, this.getCancelIndicator(monitor));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.deleteMarkers(file, mode, monitor);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.createMarkers((IResource)file, resource, list);
        }
        catch (OperationCanceledError error) {
            throw error.getWrapped();
        }
        catch (CoreException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void createMarkers(IResource iResource, Resource resource, List<Issue> list) throws CoreException {
        this.createMarkers(iResource, list, this.getMarkerCreator(resource), this.getMarkerTypeProvider(resource));
    }

    private void createMarkers(IResource iResource, List<Issue> list, MarkerCreator markerCreator, MarkerTypeProvider markerTypeProvider) throws CoreException {
        for (Issue issue : list) {
            markerCreator.createMarker(issue, iResource, markerTypeProvider.getMarkerType(issue));
        }
    }

    private CancelIndicator getCancelIndicator(IProgressMonitor monitor) {
        return () -> monitor.isCanceled();
    }

    private IResourceValidator getValidator(Resource resource) {
        return this.getService(resource, IResourceValidator.class);
    }

    private MarkerCreator getMarkerCreator(Resource resource) {
        return this.getService(resource, MarkerCreator.class);
    }

    private MarkerTypeProvider getMarkerTypeProvider(Resource resource) {
        return this.getService(resource, MarkerTypeProvider.class);
    }

    private <T> T getService(Resource resource, Class<T> clazz) {
        IResourceServiceProvider serviceProvider = ((XtextResource)resource).getResourceServiceProvider();
        return (T)serviceProvider.get(clazz);
    }

    public void clearAllMarkersOfExternalProject(String projectName) {
        List<N4JSExternalProject> projects = this.externalLibraryWorkspace.getProjectsForName(projectName);
        N4JSExternalProject[] projectsArray = projects.toArray(new N4JSExternalProject[projects.size()]);
        this.clearAllMarkersOfExternalProjects(projectsArray);
    }

    public void clearAllMarkersOfAllExternalProjects() {
        Collection locations = this.externalLibraryPreferenceStore.getLocations();
        for (URI location : locations) {
            this.deleteMarkersRecursively(location);
        }
    }

    public void clearAllMarkersOfExternalProjects(N4JSExternalProject[] projects) {
        if (projects == null) {
            return;
        }
        N4JSExternalProject[] n4JSExternalProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            N4JSExternalProject prj = n4JSExternalProjectArray[n2];
            URI location = prj.getLocationURI();
            this.deleteMarkersRecursively(location);
            ++n2;
        }
    }

    private void deleteMarkersRecursively(URI location) {
        if (location == null) {
            return;
        }
        String fileString = location.getPath();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath iPath = Path.fromOSString((String)fileString);
        if (iPath == null) {
            return;
        }
        IContainer[] containers = root.findContainersForLocationURI(location);
        if (containers == null || containers.length == 0) {
            return;
        }
        try {
            IContainer[] iContainerArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                IContainer container = iContainerArray[n2];
                if (container.isAccessible()) {
                    container.deleteMarkers(null, true, 2);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

