/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.navigator.internal;

import com.google.common.base.Charsets;
import com.google.common.collect.FluentIterable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ts.ui.navigation.IURIBasedStorage;
import org.eclipse.n4js.ui.ImageDescriptorCache;
import org.eclipse.n4js.ui.navigator.internal.Node;
import org.eclipse.n4js.ui.navigator.internal.NodeAdapter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

class ResourceNode
extends NodeAdapter
implements IURIBasedStorage {
    private static final Image SRC_FOLDER_IMG = (Image)ImageDescriptorCache.ImageRef.SRC_FOLDER.asImage().orNull();
    private static final Image FOLDER_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private static final Image FILE_IMG = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
    private final File file;
    private final String label;

    public static ResourceNode create(Node parent, File file) {
        return ResourceNode.create(parent, file, file.getName());
    }

    public static ResourceNode create(Node parent, File file, String label) {
        if (file == null || !file.exists()) {
            return null;
        }
        ResourceNode resourceNode = new ResourceNode(parent, file, label);
        return resourceNode;
    }

    private ResourceNode(Node parent, File file, String label) {
        super(parent);
        this.file = file;
        this.label = label;
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public Object[] getChildren() {
        if (this.file.isDirectory()) {
            FluentIterable subFiles = FluentIterable.from(Arrays.asList(this.file.listFiles()));
            return subFiles.transform(f -> ResourceNode.create(this, f)).toArray(ResourceNode.class);
        }
        return EMPTY_ARRAY;
    }

    @Override
    public Image getImage() {
        return this.file.isDirectory() ? (this.getParent() instanceof ResourceNode ? FOLDER_IMG : SRC_FOLDER_IMG) : FILE_IMG;
    }

    public InputStream getContents() throws CoreException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File '" + this.file + "' does not exist.", e);
        }
    }

    public IPath getFullPath() {
        return new Path(this.file.getAbsolutePath());
    }

    public String getName() {
        return this.label;
    }

    public boolean isReadOnly() {
        return true;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    File getResource() {
        return this.file;
    }

    public URI getURI() {
        return URI.createFileURI((String)this.file.getAbsolutePath());
    }

    public String getCharset() throws CoreException {
        return Charsets.UTF_8.name();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.file == null ? 0 : this.file.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceNode)) {
            return false;
        }
        ResourceNode other = (ResourceNode)obj;
        return !(this.file == null ? other.file != null : !this.file.equals(other.file));
    }
}

