/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.util;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;
import org.eclipse.xpect.runner.XpectRunner;

public class ClasspathUtil {
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final Logger LOG = Logger.getLogger(ClasspathUtil.class);

    public static Collection<URL> findResources(String ... fileNames) {
        LinkedHashSet result;
        block24: {
            File pl;
            int n;
            int n2;
            String[] stringArray;
            Object resources;
            int n3;
            result = Sets.newLinkedHashSet();
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            try {
                String[] stringArray2 = fileNames;
                n3 = fileNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    resources = classLoader.getResources(fileName);
                    while (resources.hasMoreElements()) {
                        result.add((URL)resources.nextElement());
                    }
                    ++n4;
                }
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader ucl = (URLClassLoader)classLoader;
                resources = ucl.getURLs();
                int n5 = ((URL[])resources).length;
                n3 = 0;
                while (n3 < n5) {
                    block23: {
                        Object u = resources[n3];
                        if (!((URL)u).getFile().endsWith(".jar")) {
                            try {
                                File f = new File(((URL)u).toURI());
                                if (!f.isDirectory()) break block23;
                                int levels = 5;
                                while (levels >= 0 && f != null) {
                                    stringArray = fileNames;
                                    n2 = fileNames.length;
                                    n = 0;
                                    while (n < n2) {
                                        String fileName = stringArray[n];
                                        pl = new File(f + "/" + fileName);
                                        if (pl.isFile()) {
                                            result.add(pl.toURI().toURL());
                                            break block23;
                                        }
                                        ++n;
                                    }
                                    --levels;
                                    f = f.getParentFile();
                                }
                            }
                            catch (URISyntaxException e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                            catch (MalformedURLException e) {
                                LOG.error((Object)e.getMessage(), (Throwable)e);
                            }
                        }
                    }
                    ++n3;
                }
            }
            if (XpectRunner.INSTANCE != null) {
                Class clazz = XpectRunner.INSTANCE.getTestClass().getJavaClass();
                Object[] segments = clazz.getName().split("\\.");
                String fileName = String.valueOf(Joiner.on((char)'/').join(segments)) + ".class";
                URL resource = clazz.getClassLoader().getResource(fileName);
                if (!"jar".equals(resource.getProtocol())) {
                    try {
                        File classFile;
                        File packageRootFolder = classFile = new File(resource.toURI());
                        int i = 0;
                        while (i < segments.length) {
                            if ((packageRootFolder = packageRootFolder.getParentFile()) == null) {
                                LOG.error((Object)("Could not determine package root for " + clazz));
                            }
                            ++i;
                        }
                        File current = packageRootFolder;
                        while (current != null) {
                            stringArray = fileNames;
                            n2 = fileNames.length;
                            n = 0;
                            while (n < n2) {
                                String name = stringArray[n];
                                pl = new File(current, name);
                                if (pl.isFile()) {
                                    result.add(pl.toURI().toURL());
                                    break block24;
                                }
                                ++n;
                            }
                            current = current.getParentFile();
                        }
                    }
                    catch (URISyntaxException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                    catch (MalformedURLException e) {
                        LOG.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
        return result;
    }

    public static String getSymbolicName(InputStream manifestInputStream) {
        try {
            Manifest manifest = new Manifest(manifestInputStream);
            String string = ClasspathUtil.getSymbolicName(manifest);
            return string;
        }
        catch (IOException e) {
            LOG.error((Object)"error parsing manifest", (Throwable)e);
        }
        finally {
            try {
                Closeables.close((Closeable)manifestInputStream, (boolean)true);
            }
            catch (IOException e) {
                LOG.error((Object)"error parsing manifest", (Throwable)e);
            }
        }
        return null;
    }

    public static String getSymbolicName(Manifest manifest) {
        int i;
        String name = manifest.getMainAttributes().getValue(BUNDLE_SYMBOLIC_NAME);
        if (name != null && (i = name.indexOf(59)) >= 0) {
            name = name.substring(0, i);
        }
        return name;
    }
}

