/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.operations;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.ArrowFunction;
import org.eclipse.n4js.n4JS.Block;
import org.eclipse.n4js.n4JS.ExportDeclaration;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.Expression;
import org.eclipse.n4js.n4JS.ExpressionStatement;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.n4JS.FunctionExpression;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.ImportSpecifier;
import org.eclipse.n4js.n4JS.N4ClassDeclaration;
import org.eclipse.n4js.n4JS.N4EnumDeclaration;
import org.eclipse.n4js.n4JS.N4InterfaceDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.ParameterizedCallExpression;
import org.eclipse.n4js.n4JS.ReturnStatement;
import org.eclipse.n4js.n4JS.Statement;
import org.eclipse.n4js.n4JS.VariableBinding;
import org.eclipse.n4js.n4JS.VariableDeclaration;
import org.eclipse.n4js.n4JS.VariableStatement;
import org.eclipse.n4js.transpiler.TranspilerBuilderBlocks;
import org.eclipse.n4js.transpiler.TranspilerState;
import org.eclipse.n4js.transpiler.im.ImPackage;
import org.eclipse.n4js.transpiler.im.ParameterizedPropertyAccessExpression_IM;
import org.eclipse.n4js.transpiler.im.ReferencingElement_IM;
import org.eclipse.n4js.transpiler.im.SymbolTableEntry;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.transpiler.operations.SymbolTableManagement;
import org.eclipse.n4js.transpiler.utils.TranspilerUtils;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.ModuleNamespaceVirtualType;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class TranspilerStateOperations {
    public static SymbolTableEntryOriginal addNamespaceImport(TranspilerState state, TModule moduleToImport, String namespaceName) {
        NamespaceImportSpecifier importSpec = TranspilerBuilderBlocks._NamespaceImportSpecifier(namespaceName, true);
        ImportDeclaration importDecl = TranspilerBuilderBlocks._ImportDecl(new ImportSpecifier[]{importSpec});
        ModuleNamespaceVirtualType typeForNamespace = TypesFactory.eINSTANCE.createModuleNamespaceVirtualType();
        typeForNamespace.setName(namespaceName);
        state.resource.addTemporaryType((Type)typeForNamespace);
        SymbolTableEntryOriginal steForNamespace = SymbolTableManagement.getSymbolTableEntryOriginal(state, (IdentifiableElement)typeForNamespace, true);
        steForNamespace.setImportSpecifier((ImportSpecifier)importSpec);
        EList scriptElements = state.im.getScriptElements();
        boolean _isEmpty = scriptElements.isEmpty();
        if (_isEmpty) {
            scriptElements.add((Object)importDecl);
        } else {
            TranspilerStateOperations.insertBefore(state, (EObject)scriptElements.get(0), new EObject[]{importDecl});
        }
        state.info.setImportedModule(importDecl, moduleToImport);
        return steForNamespace;
    }

    public static SymbolTableEntryOriginal addNamedImport(TranspilerState state, IdentifiableElement elementToImport, String aliasOrNull) {
        SymbolTableEntryOriginal steOfElementToImport = SymbolTableManagement.getSymbolTableEntryOriginal(state, elementToImport, true);
        TranspilerStateOperations.addNamedImport(state, steOfElementToImport, aliasOrNull);
        return steOfElementToImport;
    }

    public static void addNamedImport(TranspilerState state, SymbolTableEntryOriginal steOfElementToImport, String aliasOrNull) {
        IdentifiableElement originalTarget = steOfElementToImport.getOriginalTarget();
        if (originalTarget instanceof ModuleNamespaceVirtualType) {
            throw new IllegalArgumentException("cannot create named import for a ModuleNamespaceVirtualType");
        }
        ImportSpecifier existingImportSpec = steOfElementToImport.getImportSpecifier();
        if (existingImportSpec != null) {
            return;
        }
        NamedImportSpecifier importSpec = TranspilerBuilderBlocks._NamedImportSpecifier(steOfElementToImport.getExportedName(), aliasOrNull, true);
        ImportDeclaration importDecl = TranspilerBuilderBlocks._ImportDecl(new ImportSpecifier[]{importSpec});
        EList scriptElements = state.im.getScriptElements();
        boolean _isEmpty = scriptElements.isEmpty();
        if (_isEmpty) {
            scriptElements.add((Object)importDecl);
        } else {
            TranspilerStateOperations.insertBefore(state, (EObject)scriptElements.get(0), new EObject[]{importDecl});
        }
        steOfElementToImport.setImportSpecifier((ImportSpecifier)importSpec);
        TModule moduleOfOriginalTarget = originalTarget.getContainingModule();
        state.info.setImportedModule(importDecl, moduleOfOriginalTarget);
    }

    public static void addEmptyImport(TranspilerState state, String moduleSpecifier) {
        ImportDeclaration __ImportDecl = TranspilerBuilderBlocks._ImportDecl(new ImportSpecifier[0]);
        Procedures.Procedure1 _function = it -> it.setModuleSpecifierAsText(moduleSpecifier);
        ImportDeclaration importDecl = (ImportDeclaration)ObjectExtensions.operator_doubleArrow((Object)__ImportDecl, (Procedures.Procedure1)_function);
        EList scriptElements = state.im.getScriptElements();
        boolean _isEmpty = scriptElements.isEmpty();
        if (_isEmpty) {
            scriptElements.add((Object)importDecl);
        } else {
            TranspilerStateOperations.insertBefore(state, (EObject)scriptElements.get(0), new EObject[]{importDecl});
        }
    }

    public static void setTarget(TranspilerState state, ParameterizedCallExpression callExpr, Expression newTarget) {
        Expression oldTarget = callExpr.getTarget();
        if (oldTarget != null) {
            TranspilerStateOperations.replaceWithoutRewire(state, (EObject)oldTarget, new EObject[]{newTarget});
        } else {
            callExpr.setTarget(newTarget);
        }
    }

    public static void setTarget(TranspilerState state, ParameterizedPropertyAccessExpression_IM accExpr, Expression newTarget) {
        Expression oldTarget = accExpr.getTarget();
        if (oldTarget != null) {
            TranspilerStateOperations.replaceWithoutRewire(state, (EObject)oldTarget, new EObject[]{newTarget});
        } else {
            accExpr.setTarget(newTarget);
        }
    }

    public static void addArgument(TranspilerState state, ParameterizedCallExpression callExpr, int index, Expression newArgument) {
        callExpr.getArguments().add(index, (Object)TranspilerBuilderBlocks._Argument(newArgument));
    }

    public static void remove(TranspilerState state, EObject elementInIM) {
        TranspilerStateOperations.replaceWithoutRewire(state, elementInIM, new EObject[0]);
        if (elementInIM instanceof ReferencingElement_IM) {
            ((ReferencingElement_IM)elementInIM).setRewiredTarget(null);
        }
    }

    public static VariableStatement removeExport(TranspilerState state, ExportedVariableStatement exVarStmnt) {
        boolean _not;
        boolean _isIntermediateModelElement = TranspilerUtils.isIntermediateModelElement((EObject)exVarStmnt);
        boolean bl = _not = !_isIntermediateModelElement;
        if (_not) {
            throw new IllegalArgumentException("not an element in the intermediate model: " + exVarStmnt);
        }
        EObject _eContainer = exVarStmnt.eContainer();
        ExportDeclaration exportDecl = (ExportDeclaration)_eContainer;
        VariableStatement __VariableStatement = TranspilerBuilderBlocks._VariableStatement(new VariableDeclaration[0]);
        Procedures.Procedure1 _function = it -> {
            EList _varDeclsOrBindings = it.getVarDeclsOrBindings();
            EList _varDeclsOrBindings_1 = exVarStmnt.getVarDeclsOrBindings();
            Iterables.addAll((Collection)_varDeclsOrBindings, (Iterable)_varDeclsOrBindings_1);
            it.setVarStmtKeyword(exVarStmnt.getVarStmtKeyword());
        };
        VariableStatement varStmnt = (VariableStatement)ObjectExtensions.operator_doubleArrow((Object)__VariableStatement, (Procedures.Procedure1)_function);
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)exportDecl, new EObject[]{varStmnt});
        return varStmnt;
    }

    public static void replace(TranspilerState state, Statement stmnt, ReturnStatement returnStmnt) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)stmnt, new EObject[]{returnStmnt});
    }

    public static void replace(TranspilerState state, N4ClassDeclaration classDecl, FunctionDeclaration funDecl) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)classDecl, new EObject[]{funDecl});
        SymbolTableManagement.rewireSymbolTable(state, (EObject)classDecl, (EObject)funDecl);
    }

    public static void replace(TranspilerState state, N4InterfaceDeclaration ifcDecl, VariableDeclaration varDecl) {
        EObject _eContainer = ifcDecl.eContainer();
        boolean isExported = _eContainer instanceof ExportDeclaration;
        VariableStatement varStmnt = TranspilerBuilderBlocks._VariableStatement(isExported, varDecl);
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)ifcDecl, new EObject[]{varStmnt});
        SymbolTableManagement.rewireSymbolTable(state, (EObject)ifcDecl, (EObject)varDecl);
    }

    public static void replace(TranspilerState state, N4EnumDeclaration enumDecl, VariableDeclaration varDecl) {
        EObject _eContainer = enumDecl.eContainer();
        boolean isExported = _eContainer instanceof ExportDeclaration;
        VariableStatement varStmnt = TranspilerBuilderBlocks._VariableStatement(isExported, varDecl);
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)enumDecl, new EObject[]{varStmnt});
        SymbolTableManagement.rewireSymbolTable(state, (EObject)enumDecl, (EObject)varDecl);
    }

    public static void replace(TranspilerState state, N4EnumDeclaration enumDecl, FunctionDeclaration funDecl) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)enumDecl, new EObject[]{funDecl});
        SymbolTableManagement.rewireSymbolTable(state, (EObject)enumDecl, (EObject)funDecl);
    }

    public static void replace(TranspilerState state, FunctionDeclaration funDecl, VariableDeclaration varDecl) {
        EObject _eContainer = funDecl.eContainer();
        boolean isExported = _eContainer instanceof ExportDeclaration;
        VariableStatement varStmnt = TranspilerBuilderBlocks._VariableStatement(isExported, varDecl);
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)funDecl, new EObject[]{varStmnt});
        SymbolTableManagement.rewireSymbolTable(state, (EObject)funDecl, (EObject)varDecl);
        Expression varValue = varDecl.getExpression();
        if (!(varValue instanceof FunctionExpression)) {
            throw new IllegalArgumentException("when replacing a function declaration by a variable declaration, we expect the variable to be initialized with a function expression");
        }
        SymbolTableManagement.rewireSymbolTable(state, (EObject)funDecl.getLocalArgumentsVariable(), (EObject)((FunctionExpression)varValue).getLocalArgumentsVariable());
    }

    public static void replace(TranspilerState state, FunctionDeclaration functionDecl, ExpressionStatement stmt) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)functionDecl, new EObject[]{stmt});
    }

    public static void replace(TranspilerState state, N4MemberDeclaration memberDecl, N4MemberDeclaration replacement) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)memberDecl, new EObject[]{replacement});
        SymbolTableManagement.rewireSymbolTable(state, (EObject)memberDecl, (EObject)replacement);
    }

    public static void replace(TranspilerState state, VariableStatement varStmnt, Statement ... newStmnts) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)varStmnt, (EObject[])newStmnts);
    }

    public static void replace(TranspilerState state, VariableBinding varBinding, VariableDeclaration ... varDecls) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)varBinding, (EObject[])varDecls);
    }

    public static void replace(TranspilerState state, Expression exprOld, Expression exprNew) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)exprOld, new EObject[]{exprNew});
    }

    public static void replace(TranspilerState state, ArrowFunction exprOld, ParameterizedCallExpression exprNew, FunctionExpression rewireTarget) {
        TranspilerStateOperations.replaceWithoutRewire(state, (EObject)exprOld, new EObject[]{exprNew});
        SymbolTableManagement.rewireSymbolTable(state, (EObject)exprOld, (EObject)rewireTarget);
    }

    public static void replaceAndRelocate(TranspilerState state, FormalParameter fPar_to_remove, VariableStatement varStmnt, VariableDeclaration varDecl_wireTo, Block newContainer) {
        boolean _tripleNotEquals;
        EObject _eContainer = varDecl_wireTo.eContainer();
        boolean bl = _tripleNotEquals = _eContainer != varStmnt;
        if (_tripleNotEquals) {
            throw new IllegalArgumentException("varDecl must be contained in varStmnt");
        }
        TranspilerStateOperations.replaceAndRelocateWithoutRewire_internal(state, (EObject)fPar_to_remove, (EObject)varStmnt, newContainer.getStatements(), 0);
        SymbolTableManagement.rewireSymbolTable(state, (EObject)fPar_to_remove, (EObject)varDecl_wireTo);
    }

    public static <T extends Expression> void wrapExistingExpression(TranspilerState state, T exprToWrap, Expression outerExpr_without_exprToWrap, Procedures.Procedure1<? super T> inserterFunction) {
        TranspilerStateOperations.insertOrReplace_internal(state, exprToWrap, new EObject[]{outerExpr_without_exprToWrap}, true, false);
        inserterFunction.apply(exprToWrap);
    }

    private static void replaceAndRelocateWithoutRewire_internal(TranspilerState state, EObject removeThis, EObject insertThis, EList<?> newContainer, int pos) {
        EObjectContainmentEList newContainerCasted;
        boolean _tripleNotEquals;
        EReference eRefRemove = TranspilerStateOperations.checkedContainmentFeature(removeThis);
        EObject _eContainer = insertThis.eContainer();
        boolean bl = _tripleNotEquals = _eContainer != null;
        if (_tripleNotEquals) {
            EObject _eContainer_1 = insertThis.eContainer();
            String _plus = "The new element must not be contained anywhere. insertThis=" + insertThis + " is currently contained in " + _eContainer_1;
            throw new IllegalArgumentException(_plus);
        }
        if (newContainer instanceof EObjectContainmentEList) {
            boolean _equals;
            newContainerCasted = (EObjectContainmentEList)newContainer;
            state.tracer.copyTrace(removeThis, insertThis);
            state.tracer.discardIntermediateModelNode(removeThis);
            int _upperBound = eRefRemove.getUpperBound();
            boolean bl2 = _equals = _upperBound == 1;
            if (_equals) {
                boolean _isUnsettable = eRefRemove.isUnsettable();
                if (_isUnsettable) {
                    removeThis.eContainer().eUnset((EStructuralFeature)eRefRemove);
                } else {
                    removeThis.eContainer().eSet((EStructuralFeature)eRefRemove, null);
                }
            } else {
                Object _eGet = removeThis.eContainer().eGet((EStructuralFeature)eRefRemove);
                List l = (List)_eGet;
                int idx = l.indexOf(removeThis);
                l.remove(idx);
            }
        } else {
            throw new IllegalArgumentException("designated new container-list must be a subtype of type EObjectContainmentList");
        }
        int _xifexpression = 0;
        _xifexpression = pos < 0 || pos >= ((EObjectContainmentEList)newContainer).size() ? ((EObjectContainmentEList)newContainer).size() : pos;
        int idx_1 = _xifexpression;
        newContainerCasted.add(idx_1, (Object)insertThis);
    }

    private static void replaceWithoutRewire(TranspilerState state, EObject elementInIntermediateModel, EObject ... replacements) {
        state.tracer.copyTrace(elementInIntermediateModel, replacements);
        state.tracer.discardIntermediateModelNode(elementInIntermediateModel);
        TranspilerStateOperations.insertOrReplace_internal(state, elementInIntermediateModel, replacements, true, false);
    }

    public static void insertBefore(TranspilerState state, EObject elementInIntermediateModel, EObject ... newElements) {
        TranspilerStateOperations.insertOrReplace_internal(state, elementInIntermediateModel, newElements, false, false);
    }

    public static void insertAfter(TranspilerState state, EObject elementInIntermediateModel, EObject ... newElements) {
        TranspilerStateOperations.insertOrReplace_internal(state, elementInIntermediateModel, newElements, false, true);
    }

    private static void insertOrReplace_internal(TranspilerState state, EObject elementInIntermediateModel, EObject[] newElements, boolean replace, boolean after) {
        boolean _equals;
        boolean _not;
        if (((List)Conversions.doWrapArray((Object)newElements)).isEmpty() && !replace) {
            return;
        }
        EReference eRef = TranspilerStateOperations.checkedContainmentFeature(elementInIntermediateModel);
        EClass eRefType = eRef.getEReferenceType();
        Functions.Function1 _function = it -> {
            boolean _isSuperTypeOf = eRefType.isSuperTypeOf(it.eClass());
            return !_isSuperTypeOf;
        };
        Iterable replElemsOfWrongType = IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)newElements)), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)replElemsOfWrongType);
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _name = eRef.getEReferenceType().getName();
            String _plus = "one or more elements are of wrong type, expected: " + _name;
            String _plus_1 = String.valueOf(_plus) + ", actual: ";
            Functions.Function1 _function_1 = it -> it.eClass().getName();
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)replElemsOfWrongType, (Functions.Function1)_function_1), (CharSequence)", ");
            String _plus_2 = String.valueOf(_plus_1) + _join;
            throw new IllegalArgumentException(_plus_2);
        }
        int _upperBound = eRef.getUpperBound();
        boolean bl2 = _equals = _upperBound == 1;
        if (_equals) {
            boolean _equals_1;
            boolean _greaterThan;
            int _length = newElements.length;
            boolean bl3 = _greaterThan = _length > 1;
            if (_greaterThan) {
                String _name_1 = eRef.getName();
                String _plus_3 = "the single-valued reference " + _name_1;
                String _plus_4 = String.valueOf(_plus_3) + " in class ";
                EClass _eContainingClass = eRef.getEContainingClass();
                String _plus_5 = String.valueOf(_plus_4) + _eContainingClass;
                String _plus_6 = String.valueOf(_plus_5) + " is not able to hold ";
                int _length_1 = newElements.length;
                String _plus_7 = String.valueOf(_plus_6) + Integer.valueOf(_length_1);
                String _plus_8 = String.valueOf(_plus_7) + " elements.";
                throw new IllegalArgumentException(_plus_8);
            }
            int _length_2 = newElements.length;
            boolean bl4 = _equals_1 = _length_2 == 1;
            if (_equals_1) {
                if (!replace) {
                    String _name_2 = eRef.getName();
                    String _plus_9 = "Cannot insert another element into a single-valued containment reference " + _name_2;
                    String _plus_10 = String.valueOf(_plus_9) + " in class ";
                    EClass _eContainingClass_1 = eRef.getEContainingClass();
                    String _plus_11 = String.valueOf(_plus_10) + _eContainingClass_1;
                    throw new IllegalArgumentException(_plus_11);
                }
                elementInIntermediateModel.eContainer().eSet((EStructuralFeature)eRef, (Object)newElements[0]);
            } else {
                if (!replace) {
                    throw new IllegalArgumentException("Inserting zero elements with replace==false is pointless.");
                }
                boolean _isUnsettable = eRef.isUnsettable();
                if (_isUnsettable) {
                    elementInIntermediateModel.eContainer().eUnset((EStructuralFeature)eRef);
                } else {
                    elementInIntermediateModel.eContainer().eSet((EStructuralFeature)eRef, null);
                }
            }
        } else {
            Object _eGet = elementInIntermediateModel.eContainer().eGet((EStructuralFeature)eRef);
            List l = (List)_eGet;
            int idx = l.indexOf(elementInIntermediateModel);
            if (replace) {
                l.remove(idx);
            } else if (after) {
                ++idx;
            }
            l.addAll(idx, (Collection)Conversions.doWrapArray((Object)newElements));
        }
    }

    private static EReference checkedContainmentFeature(EObject elementInIntermediateModel) {
        boolean _not;
        boolean _isIntermediateModelElement = TranspilerUtils.isIntermediateModelElement(elementInIntermediateModel);
        boolean bl = _not = !_isIntermediateModelElement;
        if (_not) {
            throw new IllegalArgumentException("not an element in the intermediate model: " + elementInIntermediateModel);
        }
        EReference eRef = elementInIntermediateModel.eContainmentFeature();
        if (eRef == null) {
            throw new IllegalArgumentException("element is not contained anywhere");
        }
        return eRef;
    }

    public static void rename(TranspilerState state, SymbolTableEntry entry, String newName) {
        SymbolTableManagement.rename(state, entry, newName);
    }

    public static <T extends EObject> T copy(TranspilerState state, T elementInIM) {
        IM2IMCopier copier = new IM2IMCopier();
        EObject result = copier.copy(elementInIM);
        copier.copyReferences();
        state.tracer.copyTrace(elementInIM, result);
        return (T)result;
    }

    private static final class IM2IMCopier
    extends EcoreUtil.Copier {
        private static final EReference eRef__ReferencingElement_IM__rewiredTarget = ImPackage.eINSTANCE.getReferencingElement_IM_RewiredTarget();

        private IM2IMCopier() {
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (eReference == eRef__ReferencingElement_IM__rewiredTarget) {
                ((ReferencingElement_IM)copyEObject).setRewiredTarget(((ReferencingElement_IM)eObject).getRewiredTarget());
            } else {
                super.copyReference(eReference, eObject, copyEObject);
            }
        }
    }
}

