/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalProject;
import org.eclipse.n4js.ui.internal.EclipseBasedN4JSWorkspace;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseCore;
import org.eclipse.n4js.ui.projectModel.IN4JSEclipseProject;
import org.eclipse.xtext.ui.shared.contribution.IEagerContribution;
import org.eclipse.xtext.ui.shared.contribution.ISharedStateContributionRegistry;

@Singleton
public class ProjectDescriptionLoadListener
implements IEagerContribution {
    private final IN4JSEclipseCore eclipseCore;
    private final EclipseBasedN4JSWorkspace internalWorkspace;
    private ImmutableList<? extends Strategy> strategies;

    @Inject
    private ProjectDescriptionLoadListener(IN4JSEclipseCore eclipseCore, EclipseBasedN4JSWorkspace internalWorkspace) {
        this.eclipseCore = eclipseCore;
        this.internalWorkspace = internalWorkspace;
    }

    @Inject
    private void injectStrategies(ISharedStateContributionRegistry registry) {
        this.strategies = registry.getContributedInstances(Strategy.class);
    }

    void onDescriptionLoaded(URI location) {
        if (location.isPlatformResource() && location.segmentCount() == 2) {
            IN4JSEclipseProject n4project = this.eclipseCore.create(location);
            IProject eclipseProject = n4project.getProject();
            this.updateProjectReferencesIfNecessary(eclipseProject);
        }
    }

    public void initialize() {
        this.internalWorkspace.setProjectDescriptionLoadListener(this);
    }

    public void discard() {
        this.internalWorkspace.setProjectDescriptionLoadListener(null);
    }

    public void updateProjectReferencesIfNecessary(final IProject project) {
        if (project instanceof ExternalProject) {
            return;
        }
        try {
            Object[] eclipseRequired = project.getDescription().getDynamicReferences();
            HashSet currentRequires = Sets.newHashSet((Object[])eclipseRequired);
            final SortedSet<IProject> newRequires = this.getProjectDependenciesAsSet(project);
            if (currentRequires.equals(newRequires)) {
                return;
            }
            final IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IProjectDescription description = project.getDescription();
                    IProject[] array = newRequires.toArray(new IProject[newRequires.size()]);
                    description.setDynamicReferences(array);
                    project.setDescription(description, 64, monitor);
                }
            };
            final IWorkspace workspace = this.internalWorkspace.getWorkspace().getWorkspace();
            if (workspace.isTreeLocked()) {
                new Job("Update project description for " + project.getName()){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            workspace.run(runnable, null, 1, null);
                        }
                        catch (CoreException e) {
                            return e.getStatus();
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            } else {
                workspace.run(runnable, null, 1, null);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected SortedSet<IProject> getProjectDependenciesAsSet(IProject project) {
        TreeSet<IProject> result = new TreeSet<IProject>(new Comparator<IProject>(){

            @Override
            public int compare(IProject o1, IProject o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (Strategy strategy : this.strategies) {
            result.addAll(strategy.getProjectDependencies(project));
        }
        return result;
    }

    static interface Strategy {
        public List<IProject> getProjectDependencies(IProject var1);
    }
}

