/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MemberType implements Enumerator
{
    GETTER(0, "GETTER", "GETTER"),
    SETTER(1, "SETTER", "SETTER"),
    FIELD(2, "FIELD", "FIELD"),
    METHOD(3, "METHOD", "METHOD");

    public static final int GETTER_VALUE = 0;
    public static final int SETTER_VALUE = 1;
    public static final int FIELD_VALUE = 2;
    public static final int METHOD_VALUE = 3;
    private static final MemberType[] VALUES_ARRAY;
    public static final List<MemberType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MemberType[]{GETTER, SETTER, FIELD, METHOD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MemberType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MemberType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MemberType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MemberType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MemberType get(int value) {
        switch (value) {
            case 0: {
                return GETTER;
            }
            case 1: {
                return SETTER;
            }
            case 2: {
                return FIELD;
            }
            case 3: {
                return METHOD;
            }
        }
        return null;
    }

    private MemberType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

