/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum UnaryOperator implements Enumerator
{
    DELETE(0, "delete", "delete"),
    VOID(1, "void", "void"),
    TYPEOF(2, "typeof", "typeof"),
    INC(3, "inc", "++"),
    DEC(4, "dec", "--"),
    POS(5, "pos", "+"),
    NEG(6, "neg", "-"),
    INV(7, "inv", "~"),
    NOT(8, "not", "!");

    public static final int DELETE_VALUE = 0;
    public static final int VOID_VALUE = 1;
    public static final int TYPEOF_VALUE = 2;
    public static final int INC_VALUE = 3;
    public static final int DEC_VALUE = 4;
    public static final int POS_VALUE = 5;
    public static final int NEG_VALUE = 6;
    public static final int INV_VALUE = 7;
    public static final int NOT_VALUE = 8;
    private static final UnaryOperator[] VALUES_ARRAY;
    public static final List<UnaryOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new UnaryOperator[]{DELETE, VOID, TYPEOF, INC, DEC, POS, NEG, INV, NOT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static UnaryOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            UnaryOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static UnaryOperator get(int value) {
        switch (value) {
            case 0: {
                return DELETE;
            }
            case 1: {
                return VOID;
            }
            case 2: {
                return TYPEOF;
            }
            case 3: {
                return INC;
            }
            case 4: {
                return DEC;
            }
            case 5: {
                return POS;
            }
            case 6: {
                return NEG;
            }
            case 7: {
                return INV;
            }
            case 8: {
                return NOT;
            }
        }
        return null;
    }

    private UnaryOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

