/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.generator.headless;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.internal.N4JSProject;

public class BuildSet {
    final Set<N4JSProject> requestedProjects;
    final Set<N4JSProject> discoveredProjects;
    final Predicate<URI> resourceFilter;

    public static BuildSet combineDiscovered(BuildSet set1, BuildSet set2) {
        return new BuildSet(set1.requestedProjects, (Set<N4JSProject>)Sets.union(set1.discoveredProjects, set2.discoveredProjects), set1.resourceFilter);
    }

    public Set<N4JSProject> getAllProjects() {
        return Sets.union(this.requestedProjects, this.discoveredProjects);
    }

    BuildSet(Collection<N4JSProject> requestedProjects, Collection<N4JSProject> discoveredProjects, Predicate<URI> projectFilter) {
        this.requestedProjects = Collections.unmodifiableSet(new LinkedHashSet<N4JSProject>(requestedProjects));
        this.discoveredProjects = Collections.unmodifiableSet(new LinkedHashSet<N4JSProject>(discoveredProjects));
        this.resourceFilter = projectFilter;
    }

    BuildSet(Set<N4JSProject> requestedProjects, Set<N4JSProject> discoveredProjects, Predicate<URI> projectFilter) {
        this.requestedProjects = Collections.unmodifiableSet(requestedProjects);
        this.discoveredProjects = Collections.unmodifiableSet(discoveredProjects);
        this.resourceFilter = projectFilter;
    }
}

