/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.actions.NewWizardShortcutAction;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class BaseNewWizardMenu
extends CompoundContributionItem {
    private final Map actions = new HashMap(21);
    private final IExtensionChangeHandler configListener = new IExtensionChangeHandler(){

        public void removeExtension(IExtension source, Object[] objects) {
            Object[] objectArray = objects;
            int n = objects.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof NewWizardShortcutAction) {
                    BaseNewWizardMenu.this.actions.values().remove(object);
                }
                ++n2;
            }
        }

        public void addExtension(IExtensionTracker tracker, IExtension extension) {
        }
    };
    private final IRegistryChangeListener registryListener = event -> {
        if (this.getParent() != null) {
            this.getParent().markDirty();
        }
    };
    private ActionFactory.IWorkbenchAction showDlgAction;
    private IWorkbenchWindow workbenchWindow;

    public BaseNewWizardMenu(IWorkbenchWindow window, String id) {
        super(id);
        Assert.isNotNull((Object)window);
        this.workbenchWindow = window;
        this.showDlgAction = ActionFactory.NEW.create(window);
        this.registerListeners();
        if (window instanceof WorkbenchWindow) {
            ((WorkbenchWindow)window).addSubmenu(4);
        }
    }

    protected void addItems(List list) {
        if (this.addShortcuts(list)) {
            list.add(new Separator());
        }
        list.add(new ActionContributionItem(this.getShowDialogAction()));
    }

    protected boolean addShortcuts(List list) {
        boolean added = false;
        IWorkbenchPage page = this.workbenchWindow.getActivePage();
        if (page != null) {
            String[] wizardIds;
            String[] stringArray = wizardIds = page.getNewWizardShortcuts();
            int n = wizardIds.length;
            int n2 = 0;
            while (n2 < n) {
                String wizardId = stringArray[n2];
                IAction action = this.getAction(wizardId);
                if (action != null && !WorkbenchActivityHelper.filterItem(action)) {
                    list.add(new ActionContributionItem(action));
                    added = true;
                }
                ++n2;
            }
        }
        return added;
    }

    @Override
    public void dispose() {
        if (this.workbenchWindow != null) {
            this.unregisterListeners();
            this.showDlgAction.dispose();
            this.showDlgAction = null;
            this.workbenchWindow = null;
            super.dispose();
        }
    }

    private IAction getAction(String id) {
        IWizardDescriptor wizardDesc;
        Object action = (IAction)this.actions.get(id);
        if (action == null && (wizardDesc = WorkbenchPlugin.getDefault().getNewWizardRegistry().findWizard(id)) != null) {
            action = new NewWizardShortcutAction(this.workbenchWindow, wizardDesc);
            this.actions.put(id, action);
            IConfigurationElement element = (IConfigurationElement)Adapters.adapt((Object)wizardDesc, IConfigurationElement.class);
            if (element != null) {
                this.workbenchWindow.getExtensionTracker().registerObject(element.getDeclaringExtension(), action, 2);
            }
        }
        return action;
    }

    @Override
    protected IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> list = new ArrayList<ActionContributionItem>();
        if (this.workbenchWindow != null && this.workbenchWindow.getActivePage() != null && this.workbenchWindow.getActivePage().getPerspective() != null) {
            this.addItems(list);
        } else {
            String text = WorkbenchMessages.Workbench_noApplicableItems;
            Action dummyAction = new Action(text){};
            dummyAction.setEnabled(false);
            list.add(new ActionContributionItem((IAction)dummyAction));
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    protected IAction getShowDialogAction() {
        return this.showDlgAction;
    }

    protected IWorkbenchWindow getWindow() {
        return this.workbenchWindow;
    }

    private void registerListeners() {
        Platform.getExtensionRegistry().addRegistryChangeListener(this.registryListener);
        this.workbenchWindow.getExtensionTracker().registerHandler(this.configListener, null);
    }

    protected boolean registryHasCategory(String categoryId) {
        return WorkbenchPlugin.getDefault().getNewWizardRegistry().findCategory(categoryId) != null;
    }

    private void unregisterListeners() {
        Platform.getExtensionRegistry().removeRegistryChangeListener(this.registryListener);
        IExtensionTracker extensionTracker = this.workbenchWindow.getExtensionTracker();
        if (extensionTracker != null) {
            extensionTracker.unregisterHandler(this.configListener);
        }
    }
}

