/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;

public interface StyledTextDescriptor {
    public String getText();

    public StyleRange[] getRanges();

    public Font getFont();

    default public StyledText toStyledText(Composite parent, int style) {
        StyledText text = new StyledText(parent, 8 | style);
        text.setText(this.getText());
        text.setStyleRanges(this.getRanges());
        text.setFont(this.getFont());
        text.setEditable(false);
        text.setEnabled(false);
        AtomicReference<Color> colorRef = new AtomicReference<Color>();
        IPreferenceStore prefStore = EditorsUI.getPreferenceStore();
        if (prefStore == null || prefStore.getBoolean("AbstractTextEditor.Color.Background.SystemDefault")) {
            colorRef.set(Display.getDefault().getSystemColor(25));
        } else {
            RGB rgb = null;
            if (prefStore.contains("AbstractTextEditor.Color.Background") && (rgb = prefStore.isDefault("AbstractTextEditor.Color.Background") ? PreferenceConverter.getDefaultColor((IPreferenceStore)prefStore, (String)"AbstractTextEditor.Color.Background") : PreferenceConverter.getColor((IPreferenceStore)prefStore, (String)"AbstractTextEditor.Color.Background")) != null) {
                colorRef.set(new Color((Device)text.getDisplay(), rgb));
            }
        }
        if (colorRef.get() != null) {
            text.setBackground((Color)colorRef.get());
            text.addDisposeListener(e -> {
                if (!((Color)colorRef.get()).isDisposed()) {
                    ((Color)colorRef.get()).dispose();
                }
            });
        }
        text.pack();
        return text;
    }
}

