/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class ContentTypeUtil {
    private static Logger LOG = Logger.getLogger(ContentTypeUtil.class);
    private static final String XPECT = "XPECT";
    private static final String IGNORE_TAIL = "_IGNORE";
    public static final String XPECT_CONTENT_TYPE_NAME = "text/x-xpect-xt";

    public XpectContentType getContentType(IFile file) {
        if (file == null || !file.exists()) {
            return XpectContentType.BINARY;
        }
        if ("xt".equals(file.getFileExtension())) {
            return XpectContentType.XPECT;
        }
        Reader contents = null;
        try {
            contents = new InputStreamReader(file.getContents(), file.getCharset());
            XpectContentType xpectContentType = this.getContentType(contents);
            return xpectContentType;
        }
        catch (CoreException coreException) {
            XpectContentType xpectContentType = XpectContentType.BINARY;
            return xpectContentType;
        }
        catch (IOException iOException) {
            XpectContentType xpectContentType = XpectContentType.BINARY;
            return xpectContentType;
        }
        finally {
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public XpectContentType getContentType(Reader contents) throws IOException {
        char[] buf = new char[2048];
        int len = contents.read(buf);
        int i = 0;
        while (i < len) {
            char c = buf[i];
            if (c < ' ' && c != '\n' && c != '\r' && c != '\t') {
                return XpectContentType.BINARY;
            }
            ++i;
        }
        String stringBuf = new String(buf);
        int index = -1;
        while ((index = stringBuf.indexOf(XPECT, index + 1)) >= 0) {
            String tail;
            int after;
            int before = index - 1;
            if (before >= 0 && Character.isAlphabetic(stringBuf.charAt(before)) || (after = index + XPECT.length()) < stringBuf.length() && Character.isAlphabetic(stringBuf.charAt(after))) continue;
            if (after + IGNORE_TAIL.length() < stringBuf.length() && IGNORE_TAIL.equals(tail = stringBuf.substring(after, after + IGNORE_TAIL.length()))) {
                return XpectContentType.TEXT;
            }
            return XpectContentType.XPECT;
        }
        return XpectContentType.TEXT;
    }

    public static enum XpectContentType {
        BINARY,
        TEXT,
        XPECT;

    }
}

