/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.internal;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.n4js.tester.TestTreeTransformer;
import org.eclipse.n4js.tester.domain.TestTree;

public class DefaultTestTreeTransformer
implements TestTreeTransformer {
    private static final Logger LOGGER = Logger.getLogger(DefaultTestTreeTransformer.class);
    @Inject
    @Named(value="httpServerPortKey")
    private String httpServerPort;

    @Override
    public Object apply(TestTree tree) {
        return this.apply(tree, Collections.singletonMap("port", this.getHttpServerPort()));
    }

    @Override
    public Object apply(TestTree tree, Map<String, Object> properties) {
        HashMap tests = Maps.newHashMap();
        tree.forEach(testCase -> {
            String origin = testCase.getOrigin();
            Multimap fqnsWithTests = (Multimap)tests.get(origin);
            if (fqnsWithTests == null) {
                fqnsWithTests = HashMultimap.create();
            }
            fqnsWithTests.put((Object)testCase.getClassName(), (Object)testCase.getName());
            tests.put(origin, fqnsWithTests);
        });
        final ArrayList testDescriptors = Lists.newArrayList();
        tests.entrySet().forEach(new Consumer<Map.Entry<String, Multimap<String, String>>>(){

            @Override
            public void accept(Map.Entry<String, Multimap<String, String>> entry) {
                final String origin = entry.getKey();
                entry.getValue().asMap().entrySet().forEach(new Consumer<Map.Entry<String, Collection<String>>>(){

                    @Override
                    public void accept(Map.Entry<String, Collection<String>> fqnWithTests) {
                        MTestDescriptor testDescriptor = new MTestDescriptor();
                        testDescriptor.origin = origin;
                        testDescriptor.fqn = fqnWithTests.getKey();
                        if (fqnWithTests.getValue() != null && !fqnWithTests.getValue().isEmpty()) {
                            testDescriptor.testMethods = Lists.newArrayList((Iterable)fqnWithTests.getValue());
                        }
                        testDescriptors.add(testDescriptor);
                    }
                });
            }
        });
        Collections.sort(testDescriptors);
        testDescriptors.forEach(desc -> {
            if (((MTestDescriptor)desc).testMethods != null) {
                Collections.sort(((MTestDescriptor)desc).testMethods);
            }
        });
        MTestTree transformedTree = new MTestTree();
        transformedTree.sessionId = tree.getSessionId().getValue();
        transformedTree.testDescriptors = testDescriptors;
        this.trySetEndpoint(properties, transformedTree);
        return transformedTree;
    }

    private void trySetEndpoint(Map<String, Object> properties, MTestTree transformedTree) {
        Object portValue;
        if (properties != null && (portValue = properties.get("port")) != null) {
            transformedTree.endpoint = this.getEndpoint(this.tryParsePort(portValue));
        }
    }

    private String getEndpoint(int port) {
        return "http://localhost:" + port;
    }

    private int tryParsePort(Object portValue) {
        try {
            return Integer.parseInt(String.valueOf(portValue));
        }
        catch (NumberFormatException e) {
            LOGGER.error((Object)("Error while trying to parse port number: " + portValue), (Throwable)e);
            return -1;
        }
    }

    public String getHttpServerPort() {
        return this.httpServerPort;
    }

    public void setHttpServerPort(String httpServerPort) {
        this.httpServerPort = httpServerPort;
    }

    @JsonAutoDetect
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected static final class MTestDescriptor
    implements Comparable<MTestDescriptor> {
        @JsonProperty
        private String origin;
        @JsonProperty
        private String fqn;
        @JsonProperty
        private List<String> testMethods;

        protected MTestDescriptor() {
        }

        @Override
        public int compareTo(MTestDescriptor o) {
            int result = this.origin.compareTo(o.origin);
            if (result == 0) {
                return this.fqn.compareTo(o.fqn);
            }
            return result;
        }
    }

    @JsonAutoDetect
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    protected static final class MTestTree {
        private static final String PORT_KEY = "port";
        private static final int ILLEGAL_PORT_NUMBER = -1;
        @JsonProperty
        private String endpoint;
        @JsonProperty
        private String sessionId;
        @JsonProperty
        private List<MTestDescriptor> testDescriptors;

        protected MTestTree() {
        }

        public List<MTestDescriptor> getTestDescriptors() {
            return this.testDescriptors;
        }
    }
}

