/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.util;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.parameter.OffsetRegion;
import org.eclipse.xpect.setup.ThisArgumentType;
import org.eclipse.xpect.setup.XpectSetupFactory;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.text.OffsetToString;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parsetree.reconstr.impl.NodeIterator;
import org.eclipse.xtext.resource.XtextResource;

@XpectImport(value={NodeProvider.class, EObjectProvider.class})
public class XtextOffsetAdapter {

    protected static class CrossEReferenceAndEObject
    extends EStructuralFeatureAndEObject
    implements ICrossEReferenceAndEObject {
        public CrossEReferenceAndEObject(EObject object, EStructuralFeature feature) {
            super(object, feature);
        }

        @Override
        public EReference getCrossEReference() {
            return (EReference)this.getEStructuralFeature();
        }
    }

    @XpectSetupFactory
    protected static class CrossEReferenceAndEObjectProvider
    extends EStructuralFeatureAndEObjectProvider {
        public CrossEReferenceAndEObjectProvider(@ThisResource XtextResource resource, XpectInvocation statement) {
            super(resource, statement);
        }

        public CrossEReferenceAndEObjectProvider(@ThisResource XtextResource resource, XpectInvocation statement, OffsetRegion region) {
            super(resource, statement, region);
        }

        @Override
        protected EStructuralFeatureAndEObject create(EObject object, EStructuralFeature feat) {
            return new CrossEReferenceAndEObject(object, feat);
        }

        @Creates
        public ICrossEReferenceAndEObject createCrossEReferenceAndEObject() {
            return (ICrossEReferenceAndEObject)((Object)this.createStructuralFeatureAndEObject());
        }

        @Override
        protected boolean matches(EObject object, EStructuralFeature feature) {
            return feature instanceof EReference && !((EReference)feature).isContainment();
        }

        @Creates
        public ICrossEReferenceAndEObject create() {
            return (ICrossEReferenceAndEObject)((Object)this.createStructuralFeatureAndEObject());
        }
    }

    protected static class EAttributeAndEObject
    extends EStructuralFeatureAndEObject
    implements IEAttributeAndEObject {
        public EAttributeAndEObject(EObject object, EStructuralFeature feature) {
            super(object, feature);
        }

        @Override
        public EAttribute getEAttribute() {
            return (EAttribute)this.getEStructuralFeature();
        }
    }

    @XpectSetupFactory
    protected static class EAttributeAndEObjectProvider
    extends EStructuralFeatureAndEObjectProvider {
        public EAttributeAndEObjectProvider(XtextResource resource, XpectInvocation statement) {
            super(resource, statement);
        }

        public EAttributeAndEObjectProvider(XtextResource resource, XpectInvocation statement, OffsetRegion region) {
            super(resource, statement, region);
        }

        @Override
        protected EStructuralFeatureAndEObject create(EObject object, EStructuralFeature feat) {
            return new EAttributeAndEObject(object, feat);
        }

        @Creates
        public IEAttributeAndEObject createEAttributeAndEObject() {
            return (IEAttributeAndEObject)((Object)this.createStructuralFeatureAndEObject());
        }

        @Override
        protected boolean matches(EObject object, EStructuralFeature feature) {
            return feature instanceof EAttribute;
        }
    }

    @XpectSetupFactory
    protected static class EObjectProvider<T extends EObject> {
        private final T eObject;

        public EObjectProvider(@ThisResource XtextResource resource, XpectInvocation statement, @ThisArgumentType Class<T> expectedType) {
            ICompositeNode statementNode = NodeModelUtils.getNode((EObject)statement);
            this.eObject = this.find(resource, statementNode.getOffset() + statementNode.getLength(), expectedType);
        }

        public EObjectProvider(@ThisResource XtextResource resource, XpectInvocation statement, @ThisArgumentType Class<T> expectedType, OffsetRegion offset) {
            this.eObject = this.find(resource, offset.getMatchedOffset(), expectedType);
        }

        public boolean canProvide(Class<?> expectedType) {
            return EObject.class.isAssignableFrom(expectedType);
        }

        protected T find(Class<T> expectedType, INode node, Set<EObject> visited) {
            EObject current = node.getSemanticElement();
            int startoffset = node.getOffset();
            EObject result = null;
            while (current != null && NodeModelUtils.getNode((EObject)current).getOffset() >= startoffset) {
                if (expectedType.isInstance(current)) {
                    result = (EObject)expectedType.cast(current);
                }
                visited.add(current);
                current = current.eContainer();
            }
            return (T)result;
        }

        protected T find(XtextResource res, int offset, Class<T> expectedType) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)res.getParseResult().getRootNode(), (int)offset);
            HashSet visited = Sets.newHashSet();
            NodeIterator ni = null;
            while (ni == null || ni.hasNext()) {
                T result;
                ILeafNode next;
                Object object = next = ni == null ? leaf : ni.next();
                if (ni == null) {
                    ni = new NodeIterator((INode)leaf);
                }
                if ((result = this.find(expectedType, (INode)next, visited)) == null) continue;
                return result;
            }
            return null;
        }

        @Creates
        public T getEObject() {
            return this.eObject;
        }
    }

    protected static class EReferenceAndEObject
    extends EStructuralFeatureAndEObject
    implements IEReferenceAndEObject {
        public EReferenceAndEObject(EObject object, EStructuralFeature feature) {
            super(object, feature);
        }

        @Override
        public EReference getEReference() {
            return (EReference)this.getEStructuralFeature();
        }
    }

    @XpectSetupFactory
    protected static class EReferenceAndEObjectProvider
    extends EStructuralFeatureAndEObjectProvider {
        public EReferenceAndEObjectProvider(XtextResource resource, XpectInvocation statement) {
            super(resource, statement);
        }

        public EReferenceAndEObjectProvider(XtextResource resource, XpectInvocation statement, OffsetRegion region) {
            super(resource, statement, region);
        }

        @Override
        protected EStructuralFeatureAndEObject create(EObject object, EStructuralFeature feat) {
            return new EReferenceAndEObject(object, feat);
        }

        @Creates
        public IEReferenceAndEObject createReferenceAndEObject() {
            return (IEReferenceAndEObject)((Object)this.createStructuralFeatureAndEObject());
        }

        @Override
        protected boolean matches(EObject object, EStructuralFeature feature) {
            return feature instanceof EReference;
        }
    }

    protected static class EStructuralFeatureAndEObject
    implements IEStructuralFeatureAndEObject {
        private final EStructuralFeature feature;
        private final EObject object;

        public EStructuralFeatureAndEObject(EObject object, EStructuralFeature feature) {
            this.object = object;
            this.feature = feature;
        }

        @Override
        public EObject getEObject() {
            return this.object;
        }

        @Override
        public EStructuralFeature getEStructuralFeature() {
            return this.feature;
        }
    }

    @XpectSetupFactory
    protected static class EStructuralFeatureAndEObjectProvider {
        private final IEStructuralFeatureAndEObject structuralFeatureAndEObject;

        public EStructuralFeatureAndEObjectProvider(@ThisResource XtextResource resource, XpectInvocation statement) {
            ICompositeNode statementNode = NodeModelUtils.getNode((EObject)statement);
            int offset = statementNode.getOffset() + statementNode.getLength();
            this.structuralFeatureAndEObject = this.findAfterOffset(resource, offset);
        }

        public EStructuralFeatureAndEObjectProvider(@ThisResource XtextResource resource, XpectInvocation statement, OffsetRegion region) {
            int offset = region.getMatchedOffset();
            this.structuralFeatureAndEObject = region.getMatchedRegion() == null ? this.findAfterOffset(resource, offset) : this.findAtOffset(resource, region, offset);
        }

        protected EStructuralFeatureAndEObject create(EObject object, EStructuralFeature feat) {
            return new EStructuralFeatureAndEObject(object, feat);
        }

        @Creates
        public IEStructuralFeatureAndEObject createStructuralFeatureAndEObject() {
            return this.structuralFeatureAndEObject;
        }

        protected IEStructuralFeatureAndEObject findInParent(INode node) {
            return null;
        }

        protected IEStructuralFeatureAndEObject findAfterOffset(XtextResource resource, int offset) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
            NodeIterator ni = null;
            while (ni == null || ni.hasNext()) {
                ILeafNode next;
                Object object = next = ni == null ? leaf : ni.next();
                if (ni == null) {
                    ni = new NodeIterator((INode)leaf);
                }
                EObject object2 = NodeModelUtils.findActualSemanticObjectFor((INode)next);
                ILeafNode current = next;
                do {
                    EStructuralFeature feat;
                    Assignment ass;
                    if ((ass = GrammarUtil.containingAssignment((EObject)current.getGrammarElement())) == null || (feat = object2.eClass().getEStructuralFeature(ass.getFeature())) == null || !this.matches(object2, feat)) continue;
                    return this.create(object2, feat);
                } while ((current = current.getParent()) != null && object2 == NodeModelUtils.findActualSemanticObjectFor((INode)current));
            }
            throw new RuntimeException("No EStructuralFeature found at offset " + offset);
        }

        protected IEStructuralFeatureAndEObject findAtOffset(XtextResource resource, OffsetRegion region, int offset) {
            ILeafNode leaf = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
            EObject object = NodeModelUtils.findActualSemanticObjectFor((INode)leaf);
            ILeafNode current = leaf;
            do {
                EStructuralFeature feat;
                Assignment ass;
                if ((ass = GrammarUtil.containingAssignment((EObject)current.getGrammarElement())) == null || (feat = object.eClass().getEStructuralFeature(ass.getFeature())) == null) continue;
                if (this.matches(object, feat)) {
                    return this.create(object, feat);
                }
                String name = String.valueOf(feat.eClass().getName()) + " '" + feat.getEContainingClass().getName() + "." + feat.getName() + "'";
                String offsetString = new OffsetToString().with(offset, region.getDocument()).toString();
                throw new RuntimeException("The " + name + " found at " + offsetString + " is not valid here.");
            } while ((current = current.getParent()) != null && object == NodeModelUtils.findActualSemanticObjectFor((INode)current));
            String offsetString = new OffsetToString().with(offset, region.getDocument()).toString();
            throw new RuntimeException("no EStructuralFeature found at '" + offsetString + "'");
        }

        protected boolean matches(EObject object, EStructuralFeature feature) {
            return true;
        }
    }

    @XpectImport(value={CrossEReferenceAndEObjectProvider.class})
    public static interface ICrossEReferenceAndEObject
    extends IEObjectOwner {
        public EReference getCrossEReference();
    }

    @XpectImport(value={EAttributeAndEObjectProvider.class})
    public static interface IEAttributeAndEObject
    extends IEObjectOwner {
        public EAttribute getEAttribute();
    }

    public static interface IEObjectOwner {
        public EObject getEObject();
    }

    @XpectImport(value={EReferenceAndEObjectProvider.class})
    public static interface IEReferenceAndEObject
    extends IEObjectOwner {
        public EReference getEReference();
    }

    @XpectImport(value={EStructuralFeatureAndEObjectProvider.class})
    public static interface IEStructuralFeatureAndEObject
    extends IEObjectOwner {
        public EStructuralFeature getEStructuralFeature();
    }

    @XpectSetupFactory
    protected static class NodeProvider {
        private final ILeafNode leaf;

        public NodeProvider(@ThisResource XtextResource resource, XpectInvocation statement) {
            ICompositeNode statementNode = NodeModelUtils.getNode((EObject)statement);
            int offset = statementNode.getOffset() + statementNode.getLength();
            ILeafNode node = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset);
            NodeIterator it = new NodeIterator((INode)node);
            ILeafNode cand = null;
            while (cand == null && it.hasNext()) {
                INode next = it.next();
                if (!(next instanceof ILeafNode) || ((ILeafNode)next).isHidden()) continue;
                cand = (ILeafNode)next;
            }
            this.leaf = cand;
        }

        public NodeProvider(@ThisResource XtextResource resource, XpectInvocation statement, OffsetRegion offset) {
            this.leaf = NodeModelUtils.findLeafNodeAtOffset((INode)resource.getParseResult().getRootNode(), (int)offset.getMatchedOffset());
        }

        @Creates
        public ICompositeNode getCompositeNode() {
            return this.leaf.getParent();
        }

        @Creates
        public ILeafNode getLeafNode() {
            return this.leaf;
        }

        @Creates
        public INode getNode() {
            return this.leaf;
        }
    }
}

