/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import java.io.File;
import java.util.Map;
import org.eclipse.n4js.jsdoc2spec.KeyUtils;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.adoc.ADocFactory;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.jsdoc2spec.adoc.SpecSection;

public class SpecRequirementSection
extends SpecSection {
    final String specModuleKey;
    final String specKey;

    SpecRequirementSection(SpecInfo specInfo, File rootDir, RepoRelativePathHolder repoPathHolder) {
        super(specInfo, rootDir);
        this.specModuleKey = KeyUtils.getSpecModuleKey(repoPathHolder, specInfo);
        this.specKey = KeyUtils.getSpecKey(repoPathHolder, specInfo);
    }

    @Override
    public String getSpecModuleKey() {
        return this.specModuleKey;
    }

    @Override
    public String getSpecKey() {
        return this.specKey;
    }

    @Override
    public File getFile() {
        String fileName = this.rootDir + FileSystem.SEP + "api-gen" + FileSystem.SEP;
        fileName = String.valueOf(fileName) + "requirements" + File.separator;
        fileName = String.valueOf(fileName) + this.specKey + ".adoc";
        return new File(fileName);
    }

    public String getRequirementID() {
        return this.specInfo.specElementRef.requirementID;
    }

    @Override
    protected String computeADocText(ADocFactory adocFactory, Map<String, SpecSection> specsByKey) {
        CharSequence regionStr = adocFactory.createSpecRegionString(this, specsByKey);
        return regionStr.toString();
    }
}

