/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4JS;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum RelationalOperator implements Enumerator
{
    LT(0, "lt", "<"),
    GT(1, "gt", ">"),
    LTE(2, "lte", "<="),
    GTE(3, "gte", ">="),
    INSTANCEOF(4, "instanceof", "instanceof"),
    IN(5, "in", "in");

    public static final int LT_VALUE = 0;
    public static final int GT_VALUE = 1;
    public static final int LTE_VALUE = 2;
    public static final int GTE_VALUE = 3;
    public static final int INSTANCEOF_VALUE = 4;
    public static final int IN_VALUE = 5;
    private static final RelationalOperator[] VALUES_ARRAY;
    public static final List<RelationalOperator> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new RelationalOperator[]{LT, GT, LTE, GTE, INSTANCEOF, IN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static RelationalOperator get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperator result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperator getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            RelationalOperator result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static RelationalOperator get(int value) {
        switch (value) {
            case 0: {
                return LT;
            }
            case 1: {
                return GT;
            }
            case 2: {
                return LTE;
            }
            case 3: {
                return GTE;
            }
            case 4: {
                return INSTANCEOF;
            }
            case 5: {
                return IN;
            }
        }
        return null;
    }

    private RelationalOperator(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

