/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.fsm;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.n4js.tester.TesterEventBus;
import org.eclipse.n4js.tester.events.SessionEndedEvent;
import org.eclipse.n4js.tester.events.SessionFailedEvent;
import org.eclipse.n4js.tester.events.SessionFinishedEvent;
import org.eclipse.n4js.tester.events.SessionPingedEvent;
import org.eclipse.n4js.tester.events.SessionStartedEvent;
import org.eclipse.n4js.tester.events.TestEndedEvent;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.events.TestPingedEvent;
import org.eclipse.n4js.tester.events.TestStartedEvent;
import org.eclipse.n4js.tester.fsm.TestFsm;
import org.eclipse.n4js.tester.fsm.TestFsmImpl;
import org.eclipse.n4js.tester.fsm.TestFsmRegistry;
import org.eclipse.n4js.tester.internal.InternalTestTreeRegistry;

@Singleton
public class TestFsmRegistryImpl
implements TestFsmRegistry {
    private static final Logger LOGGER = Logger.getLogger(TestFsmRegistryImpl.class);
    private static final boolean debugEnabled = LOGGER.isDebugEnabled();
    @Inject
    private Provider<TestFsm> fsmProvider;
    private final TesterEventBus bus;
    private final InternalTestTreeRegistry treeRegistry;
    private final LoadingCache<String, TestFsm> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, TestFsm>(){

        public TestFsm load(String sessionId) throws Exception {
            return ((TestFsm)TestFsmRegistryImpl.this.fsmProvider.get()).initializeSession(sessionId);
        }
    });

    @Inject
    public TestFsmRegistryImpl(TesterEventBus bus, InternalTestTreeRegistry treeRegistry) {
        this.bus = bus;
        this.treeRegistry = treeRegistry;
        this.bus.register(this);
    }

    @Override
    public TestFsm getTestFsm(String sessionId) {
        if (debugEnabled) {
            LOGGER.debug((Object)("Registering new FSM with '" + sessionId + "' session ID..."));
        }
        TestFsm fsm = this.getSession(sessionId);
        if (debugEnabled) {
            LOGGER.debug((Object)("FSM has been successfully registered with '" + sessionId + "' session ID."));
        }
        return fsm;
    }

    @Override
    public boolean isSessionExist(String sessionId) {
        return this.exists(sessionId);
    }

    @Subscribe
    @AllowConcurrentEvents
    public void receivedTestEvent(TestEvent event) {
        if (event instanceof SessionFailedEvent && ((SessionFailedEvent)event).getComment().isPresent()) {
            LOGGER.error((Object)("Received event: " + event + ". Reason: " + (String)((SessionFailedEvent)event).getComment().get()));
        } else if (debugEnabled) {
            LOGGER.debug((Object)("Received event: " + event));
        }
        String sessionId = event.getSessionId();
        if (event instanceof SessionStartedEvent) {
            if (!this.isSessionExist(sessionId)) {
                this.getTestFsm(sessionId);
            }
            this.getSession(sessionId).startSession(sessionId);
        } else if (event instanceof SessionPingedEvent) {
            long timeout = ((SessionPingedEvent)event).getTimeout();
            this.getSession(sessionId).pingSession(sessionId, timeout);
        } else if (event instanceof SessionEndedEvent) {
            TestFsm fsm = this.getSession(sessionId).endSession(sessionId);
            if (fsm instanceof TestFsmImpl && !((TestFsmImpl)fsm).isFailed() && !this.treeRegistry.validateTestTree(sessionId)) {
                ((TestFsmImpl)fsm).fail("Test session has been terminated unexpectedly. There are test cases without any test results after receiving the session ended event.");
                return;
            }
            this.bus.post(new SessionFinishedEvent(sessionId));
        } else if (event instanceof SessionFailedEvent) {
            this.treeRegistry.purgeTestTree(sessionId);
            this.unregisterFsm(sessionId);
        } else if (event instanceof SessionFinishedEvent) {
            this.unregisterFsm(sessionId);
        } else if (event instanceof TestStartedEvent) {
            String testId = ((TestStartedEvent)event).getTestId();
            long timeout = ((TestStartedEvent)event).getTimeout();
            this.getSession(sessionId).startTest(testId, timeout);
        } else if (event instanceof TestPingedEvent) {
            long timeout = ((TestPingedEvent)event).getTimeout();
            String testId = ((TestPingedEvent)event).getTestId();
            this.getSession(sessionId).pingTest(testId, timeout);
        } else if (event instanceof TestEndedEvent) {
            TestEndedEvent testEndedEvent = (TestEndedEvent)event;
            String testId = testEndedEvent.getTestId();
            TestFsm fsm = this.getSession(sessionId).endTest(testId);
            if (fsm instanceof TestFsmImpl && !((TestFsmImpl)fsm).isFailed()) {
                this.treeRegistry.putTestResult(sessionId, testId, testEndedEvent.getResult());
            }
        } else {
            LOGGER.error((Object)("Unexpected test event: " + event));
        }
    }

    private void unregisterFsm(String sessionId) {
        if (debugEnabled) {
            LOGGER.debug((Object)("Unregistering FSM with '" + sessionId + "' session ID..."));
        }
        this.cache.invalidate((Object)sessionId);
        Preconditions.checkState((!this.exists(sessionId) ? 1 : 0) != 0, (Object)("Error while unregistering session with '" + sessionId + "' session ID."));
        if (debugEnabled) {
            LOGGER.debug((Object)("FSM has been successfully unregistered with '" + sessionId + "' session ID."));
        }
    }

    private boolean exists(String sessionId) {
        return this.cache.getIfPresent((Object)sessionId) != null;
    }

    private TestFsm getSession(String sessionId) {
        return (TestFsm)this.cache.getUnchecked((Object)sessionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(TestFsmRegistryImpl.class.getSimpleName());
        sb.append(" [");
        sb.append(Objects.hashCode(this));
        sb.append("]");
        return sb.toString();
    }
}

