/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.util;

import com.google.inject.Injector;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.runner.XpectRunner;
import org.eclipse.xpect.ui.internal.XpectActivator;
import org.eclipse.xpect.ui.util.XpectFileAccess;
import org.eclipse.xtext.resource.ClassloaderClasspathUriResolver;
import org.eclipse.xtext.resource.IClasspathUriResolver;
import org.eclipse.xtext.resource.XtextResourceFactory;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.util.JdtClasspathUriResolver;

public class XpectUtil {
    public static XpectFile loadFile(IFile file) {
        Injector injector = XpectActivator.getInstance().getInjector("org.eclipse.xpect.Xpect");
        XtextResourceSet rs = new XtextResourceSet();
        IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
        if (XpectRunner.testClassloader != null) {
            rs.setClasspathURIContext((Object)XpectRunner.testClassloader);
            rs.setClasspathUriResolver((IClasspathUriResolver)new ClassloaderClasspathUriResolver());
        } else if (javaProject != null && javaProject.exists()) {
            rs.setClasspathURIContext((Object)javaProject);
            rs.setClasspathUriResolver((IClasspathUriResolver)new JdtClasspathUriResolver());
        } else {
            rs.setClasspathURIContext((Object)XpectFileAccess.getXpectLibClassLoader());
            rs.setClasspathUriResolver((IClasspathUriResolver)new ClassloaderClasspathUriResolver());
        }
        URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        Resource resource = ((XtextResourceFactory)injector.getInstance(XtextResourceFactory.class)).createResource(uri);
        rs.getResources().add((Object)resource);
        try {
            resource.load(Collections.emptyMap());
            for (EObject obj : resource.getContents()) {
                if (!(obj instanceof XpectFile)) continue;
                return (XpectFile)obj;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static XpectJavaModel loadJavaModel(IFile file) {
        XpectFile xpectFile = XpectUtil.loadFile(file);
        if (xpectFile != null) {
            return xpectFile.getJavaModel();
        }
        return null;
    }
}

