/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.dataflow.Assumption;
import org.eclipse.n4js.flowgraphs.dataflow.DataFlowVisitor;
import org.eclipse.n4js.flowgraphs.dataflow.EffectInfo;
import org.eclipse.n4js.flowgraphs.dataflow.EffectType;
import org.eclipse.n4js.flowgraphs.dataflow.PartialResult;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class UsedBeforeDeclaredAnalyserOnDataflow
extends DataFlowVisitor {
    public List<ControlFlowElement> getUsedButNotDeclaredIdentifierRefs() {
        LinkedList<ControlFlowElement> idRefs = new LinkedList<ControlFlowElement>();
        for (Assumption ass : this.failedAssumptions.values()) {
            for (PartialResult result : ass.failedBranches) {
                UsedBeforeFailed ubf = (UsedBeforeFailed)result;
                idRefs.add(ubf.useLocation);
            }
        }
        return idRefs;
    }

    @Override
    public void visitEffect(EffectInfo effect, ControlFlowElement cfe) {
        if (effect.type == EffectType.Declaration) {
            IsNotUsedBefore symbolNotUsedBefore = new IsNotUsedBefore(effect);
            this.assume(symbolNotUsedBefore);
        }
    }

    class IsNotUsedBefore
    extends Assumption {
        IsNotUsedBefore(EffectInfo effect) {
            super(effect.location, effect.symbol);
        }

        IsNotUsedBefore(IsNotUsedBefore copy) {
            super(copy);
        }

        @Override
        public Assumption copy() {
            return new IsNotUsedBefore(this);
        }

        @Override
        protected boolean followAliases() {
            return false;
        }

        @Override
        protected PartialResult holdsOnEffect(EffectInfo effect, ControlFlowElement container) {
            return new UsedBeforeFailed(effect.location);
        }
    }

    static class UsedBeforeFailed
    extends PartialResult.Failed {
        public final ControlFlowElement useLocation;

        UsedBeforeFailed(ControlFlowElement useLocation) {
            this.useLocation = useLocation;
        }

        @Override
        public String toString() {
            return (Object)((Object)this.type) + ": used at " + FGUtils.getSourceText((EObject)this.useLocation);
        }

        @Override
        public Object[] getEqualityProperties() {
            return new Object[]{this.useLocation};
        }
    }
}

