/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.utils;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.n4js.external.LibraryManager;
import org.eclipse.n4js.ui.internal.N4JSActivator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

@Singleton
public class WizardHelper {
    @Inject
    private LibraryManager libManager;

    public void runNpmInstallInWizard(IWizardContainer container, final Iterable<IProject> projects) {
        if (Iterables.isEmpty(projects)) {
            return;
        }
        for (IProject project : projects) {
            if (project.isAccessible()) continue;
            throw new IllegalArgumentException("project not accessible: " + project.getLocationURI());
        }
        try {
            container.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.subTask("Installing dependencies");
                        for (IProject project : projects) {
                            URI projectFolderURI = URI.createFileURI((String)project.getLocation().toFile().getAbsolutePath());
                            IStatus status = WizardHelper.this.libManager.runNpmYarnInstall(projectFolderURI, monitor);
                            if (!status.matches(4)) continue;
                            throw status.getException();
                        }
                    }
                    catch (Throwable e) {
                        throw new InvocationTargetException(e, "An error occurred while installing dependencies");
                    }
                }
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            String pluginId = N4JSActivator.getInstance().getBundle().getSymbolicName();
            Status status = new Status(4, pluginId, e.getCause().getMessage(), e.getCause());
            ErrorDialog.openError((Shell)container.getShell(), (String)"Error", (String)e.getMessage(), (IStatus)status);
            StatusManager.getManager().handle((IStatus)status);
        }
    }
}

