/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.registry.IExtensionInfo;
import org.eclipse.xpect.registry.ITestSuiteInfo;
import org.eclipse.xpect.registry.LazyClass;
import org.eclipse.xpect.util.URIDelegationHandler;

public class TestSuiteInfoRegistry
implements ITestSuiteInfo.Registry {
    private static final String ORG_ECLIPSE_XPECT_TEST_SUITE = "org.eclipse.xpect.testSuite";
    private static final Logger LOG = Logger.getLogger(TestSuiteInfoRegistry.class);
    private final Map<String, ITestSuiteInfo> extToInfo;

    public static void main(String[] args) {
        System.out.println(new TestSuiteInfoRegistry().toString());
    }

    public TestSuiteInfoRegistry() {
        HashMultimap suiteToExt = HashMultimap.create();
        for (IExtensionInfo info : IExtensionInfo.Registry.INSTANCE.getExtensions(ORG_ECLIPSE_XPECT_TEST_SUITE)) {
            LazyClass<Object> clazz = LazyClass.create(Object.class, info, "class");
            if (clazz == null) {
                LOG.warn((Object)("Attribute 'class' missing for extension 'org.eclipse.xpect.testSuite' in " + info.getLocation()));
                continue;
            }
            String fileExtension = info.getAttributeValue("fileExtension");
            if (fileExtension == null) {
                LOG.warn((Object)("Attribute 'fileExtension' missing for extension 'org.eclipse.xpect.testSuite' in " + info.getLocation()));
                continue;
            }
            suiteToExt.put(clazz, (Object)fileExtension);
        }
        HashMap infos = Maps.newHashMap();
        for (Map.Entry e : suiteToExt.asMap().entrySet()) {
            TestSuiteInfo info = new TestSuiteInfo((LazyClass)e.getKey(), (Collection)e.getValue());
            for (String ext : (Collection)e.getValue()) {
                infos.put(ext, info);
            }
        }
        this.extToInfo = ImmutableMap.copyOf((Map)infos);
    }

    @Override
    public ITestSuiteInfo getTestSuite(Resource resource) {
        String fileExtension = new URIDelegationHandler().getOriginalFileExtension(resource.getURI().lastSegment());
        return this.extToInfo.get(fileExtension);
    }

    public String toString() {
        Collection<ITestSuiteInfo> values = this.extToInfo.values();
        if (values.isEmpty()) {
            return "(empty)";
        }
        return Joiner.on((char)'\n').join(values);
    }

    public static class Delegate
    implements ITestSuiteInfo.Registry {
        private ITestSuiteInfo.Registry delegate;

        @Override
        public ITestSuiteInfo getTestSuite(Resource resource) {
            if (this.delegate == null) {
                this.delegate = new TestSuiteInfoRegistry();
            }
            return this.delegate.getTestSuite(resource);
        }

        public void setDelegate(ITestSuiteInfo.Registry delegate) {
            this.delegate = delegate;
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    public static class TestSuiteInfo
    implements ITestSuiteInfo {
        private final LazyClass<Object> clazz;
        private final Set<String> fileExtensions;

        public TestSuiteInfo(LazyClass<Object> clazz, Collection<String> fileExtensions) {
            this.clazz = clazz;
            this.fileExtensions = ImmutableSet.copyOf(fileExtensions);
        }

        @Override
        public LazyClass<Object> getClazz() {
            return this.clazz;
        }

        @Override
        public Set<String> getFileExtensions() {
            return this.fileExtensions;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("fileExtensions", this.fileExtensions).add("class", this.clazz).toString();
        }
    }
}

