/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.n4js.smith.ui.ASTGraphProvider;
import org.eclipse.n4js.smith.ui.graph.Edge;
import org.eclipse.n4js.smith.ui.graph.Graph;
import org.eclipse.n4js.smith.ui.graph.GraphUtils;
import org.eclipse.n4js.smith.ui.graph.Node;
import org.eclipse.n4js.smith.ui.graph.Rectangle;
import org.eclipse.swt.graphics.GC;

public class ASTGraph
extends Graph<ASTGraphProvider> {
    private final float GAP_X = 10.0f;
    private final float GAP_Y = 60.0f;

    @Override
    public void build(ASTGraphProvider provider, Object input) {
        ArrayList elements = new ArrayList();
        ArrayList<Node> newNodes = new ArrayList<Node>();
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        if (input != null && provider != null) {
            elements.addAll(provider.getElements(input));
            for (Object currE : elements) {
                Node node = provider.getNode(currE);
                newNodes.add(node);
            }
            for (Node currNode : newNodes) {
                List<Edge> connectedEdges = provider.getConnectedEdges(currNode, newNodes);
                newEdges.addAll(connectedEdges);
            }
        }
        for (Edge e : newEdges) {
            if (e.isCrossLink()) {
                boolean internal = e.isInternal();
                boolean external = e.isExternal();
                for (Node n : e.getStartNodes()) {
                    n.hasOutgoingCrossLinksInternal |= internal;
                    n.hasOutgoingCrossLinksExternal |= external;
                }
                for (Node n : e.getEndNodes()) {
                    n.hasIncomingCrossLinksInternal |= internal;
                }
                continue;
            }
            Node parent = e.getFirstStartNode();
            if (parent == null) continue;
            parent.children.addAll(e.getEndNodes());
            for (Node en : e.getEndNodes()) {
                en.parent = parent;
            }
        }
        this.setGraph(newNodes, newEdges);
    }

    @Override
    void setGraph(List<Node> nodes, List<Edge> edges) {
        this.clear();
        this.nodes.addAll(nodes);
        this.edges.addAll(edges);
    }

    @Override
    public void layout(GC gc) {
        this.doTreeLayout(gc);
    }

    Stream<Node> getTree(Node node) {
        return Stream.concat(Stream.of(node), node.children.stream().flatMap(this::getTree));
    }

    void moveTree(Node node, float dx, float dy) {
        node.move(dx, dy);
        node.children.forEach(ch -> this.moveTree((Node)ch, dx, dy));
    }

    private void doTreeLayout(GC gc) {
        for (Node n2 : this.nodes) {
            n2.trim(gc);
        }
        Stream<Node> roots = this.nodes.stream().filter(n -> n.parent == null);
        this.doLayoutSubtrees(roots);
    }

    private void doLayoutSubtrees(Stream<Node> nodes) {
        float px = 0.0f;
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            this.doLayoutSubtree(n);
            Rectangle b = GraphUtils.getBounds(this.getTree(n));
            this.moveTree(n, px - b.x, 0.0f);
            px += b.width + 10.0f;
        }
    }

    private void doLayoutSubtree(Node node) {
        this.doLayoutSubtrees(node.children.stream());
        if (!node.children.isEmpty()) {
            Node first = node.children.get(0);
            Node last = node.children.get(node.children.size() - 1);
            float xLeft = first.getX() + first.getWidth() / 2.0f;
            float xRight = last.getX() + last.getWidth() / 2.0f;
            float width = xRight - xLeft;
            node.x = xLeft + width / 2.0f - node.getWidth() / 2.0f;
        } else {
            node.x = 0.0f;
        }
        node.y = -100.0f;
        this.moveTree(node, 0.0f, -node.y);
    }
}

