/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.search.internal.ui.text.FileMatch;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;

public class LineElement {
    private final IResource fParent;
    private final int fLineNumber;
    private final int fLineStartOffset;
    private final String fLineContents;

    public LineElement(IResource parent, int lineNumber, int lineStartOffset, String lineContents) {
        this.fParent = parent;
        this.fLineNumber = lineNumber;
        this.fLineStartOffset = lineStartOffset;
        this.fLineContents = lineContents;
    }

    public IResource getParent() {
        return this.fParent;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getContents() {
        return this.fLineContents;
    }

    public int getOffset() {
        return this.fLineStartOffset;
    }

    public boolean contains(int offset) {
        return this.fLineStartOffset <= offset && offset < this.fLineStartOffset + this.fLineContents.length();
    }

    public int getLength() {
        return this.fLineContents.length();
    }

    public FileMatch[] getMatches(AbstractTextSearchResult result) {
        Match[] matches;
        ArrayList<FileMatch> res = new ArrayList<FileMatch>();
        Match[] matchArray = matches = result.getMatches(this.fParent);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            FileMatch curr = (FileMatch)match;
            if (curr.getLineElement() == this) {
                res.add(curr);
            }
            ++n2;
        }
        return res.toArray(new FileMatch[res.size()]);
    }

    public int getNumberOfMatches(AbstractTextSearchResult result) {
        Match[] matches;
        int count = 0;
        Match[] matchArray = matches = result.getMatches(this.fParent);
        int n = matches.length;
        int n2 = 0;
        while (n2 < n) {
            Match match = matchArray[n2];
            FileMatch curr = (FileMatch)match;
            if (curr.getLineElement() == this) {
                ++count;
            }
            ++n2;
        }
        return count;
    }
}

