/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.ui.adoc;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.n4js.jsdoc2spec.CheckCanceled;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.FileSystem;
import org.eclipse.n4js.jsdoc2spec.ui.SpecProcessPage;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.ConfigAdoc;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.TaskGenerateAdoc;

class TaskWriteFiles
implements IRunnableWithProgress {
    final SpecProcessPage processOutputPage;
    final TaskGenerateAdoc taskGenAdoc;
    private ConfigAdoc configAdoc;

    TaskWriteFiles(SpecProcessPage processHtmlPage, TaskGenerateAdoc taskGenAdoc) {
        this.processOutputPage = processHtmlPage;
        this.taskGenAdoc = taskGenAdoc;
    }

    void setConfig(ConfigAdoc configAdoc) {
        this.configAdoc = configAdoc;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException {
        try {
            this.performTasks(monitor);
        }
        catch (InterruptedException e) {
            this.processOutputPage.displayMessage("User canceled tasks.");
        }
        catch (Exception e) {
            this.processOutputPage.displayMessageRed(e.getMessage());
            e.printStackTrace();
        }
    }

    public void performTasks(IProgressMonitor monitor) throws IOException, InterruptedException {
        File rootDir = this.configAdoc.getDocRootDir();
        FileSystem.ensureFileStructure((File)rootDir);
        int workload = 1;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)workload);
        this.writeAdocFiles((IProgressMonitor)subMonitor);
        subMonitor.subTask("Finished.");
        subMonitor.done();
        monitor.done();
    }

    private void writeAdocFiles(IProgressMonitor monitor) throws IOException, InterruptedException {
        Set<SpecFile> specChangeSet = this.taskGenAdoc.getSpecChangeSet();
        monitor.beginTask("Write adoc files", specChangeSet.size() + 1);
        for (SpecFile specChangeFile : specChangeSet) {
            File parent;
            File file = specChangeFile.getFile();
            String newContent = specChangeFile.getNewContent();
            if (file.exists()) {
                file.delete();
            }
            if (!(parent = file.getParentFile()).exists() && !parent.mkdirs()) {
                throw new IllegalStateException("Couldn't create dir: " + parent);
            }
            file.createNewFile();
            Files.write((CharSequence)newContent, (File)file, (Charset)Charsets.UTF_8);
            monitor.worked(1);
            CheckCanceled.checkUserCanceled((IProgressMonitor)monitor);
        }
        monitor.worked(1);
        monitor.done();
    }
}

